/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanavarro.graphlib;

import com.github.fanavarro.graphlib.Graph;
import com.github.fanavarro.graphlib.algorithms.Algorithm;
import com.github.fanavarro.graphlib.algorithms.AlgorithmInput;
import com.github.fanavarro.graphlib.algorithms.AlgorithmOutput;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractGraph<N, E>
implements Graph<N, E> {
    private static final long serialVersionUID = -3585035402556938043L;

    @Override
    public Map<N, Set<E>> getEdgesByAdjacentNodeMap(N node) {
        Map adjacentNodesByEdgeMap = this.getAdjacentNodesByEdgeMap(node);
        return this.trasposeMap(adjacentNodesByEdgeMap);
    }

    private Map<N, Set<E>> trasposeMap(Map<E, Set<N>> nodesByEdgeMap) {
        HashMap edgeByNodeMap = new HashMap();
        for (Map.Entry<E, Set<N>> entry : nodesByEdgeMap.entrySet()) {
            E edge = entry.getKey();
            for (N adjacentNode : entry.getValue()) {
                if (!edgeByNodeMap.containsKey(adjacentNode)) {
                    edgeByNodeMap.put(adjacentNode, new HashSet());
                }
                ((Set)edgeByNodeMap.get(adjacentNode)).add(edge);
            }
        }
        return edgeByNodeMap;
    }

    @Override
    public Set<N> getAdjacentNodes(N node) {
        return this.getAdjacentNodesByEdgeMap(node).values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Set<E> getOutgoingEdges(N node) {
        return this.getAdjacentNodesByEdgeMap(node).keySet();
    }

    @Override
    public Map<E, Set<N>> getIncomingNodesByEdgeMap(N node) {
        HashMap incomingNodes = new HashMap();
        for (Object otherNode : this.getNodes()) {
            if (otherNode.equals(node)) continue;
            Map adjacentNodes = this.getAdjacentNodesByEdgeMap(otherNode);
            for (Map.Entry entry : adjacentNodes.entrySet()) {
                if (!entry.getValue().contains(node)) continue;
                Object edge = entry.getKey();
                incomingNodes.putIfAbsent(edge, new HashSet());
                ((Set)incomingNodes.get(edge)).add(otherNode);
            }
        }
        return incomingNodes;
    }

    @Override
    public Map<N, Set<E>> getEdgesByIncomingNodesMap(N node) {
        Map<E, Set<N>> incomingNodesByEdgeMap = this.getIncomingNodesByEdgeMap(node);
        return this.trasposeMap(incomingNodesByEdgeMap);
    }

    @Override
    public Set<N> getIncomingNodes(N node) {
        return this.getIncomingNodesByEdgeMap(node).values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Set<E> getIncomingEdges(N node) {
        return this.getIncomingNodesByEdgeMap(node).keySet();
    }

    @Override
    public Set<N> getSourceNodes(E edge) {
        return this.getNodes().stream().filter(n -> this.getOutgoingEdges(n).contains(edge)).collect(Collectors.toSet());
    }

    @Override
    public Set<N> getTargetNodes(E edge) {
        return this.getNodes().stream().filter(n -> this.getIncomingEdges(n).contains(edge)).collect(Collectors.toSet());
    }

    @Override
    public boolean isContainedIn(Graph<N, E> other) {
        boolean isSubGraph = true;
        Set thisNodes = this.getNodes();
        if (other != null && other.getNodes().containsAll(thisNodes)) {
            for (Object node : thisNodes) {
                Map adjacentNodes = this.getAdjacentNodesByEdgeMap(node);
                Map<E, Set<N>> otherAdjacentNodes = other.getAdjacentNodesByEdgeMap(node);
                if (adjacentNodes.equals(otherAdjacentNodes = this.removeNodesNotContainedInCurrentGraph(otherAdjacentNodes, thisNodes))) continue;
                isSubGraph = false;
                break;
            }
        } else {
            isSubGraph = false;
        }
        return isSubGraph;
    }

    private Map<E, Set<N>> removeNodesNotContainedInCurrentGraph(Map<E, Set<N>> otherAdjacentNodes, Set<N> thisNodes) {
        HashMap filteredAdjacentNodes = new HashMap();
        for (Map.Entry<E, Set<N>> entry : otherAdjacentNodes.entrySet()) {
            E edge = entry.getKey();
            HashSet nodes = new HashSet(entry.getValue());
            Iterator iterator = nodes.iterator();
            while (iterator.hasNext()) {
                Object node = iterator.next();
                if (thisNodes.contains(node)) continue;
                iterator.remove();
            }
            if (nodes.isEmpty()) continue;
            filteredAdjacentNodes.put(edge, nodes);
        }
        return filteredAdjacentNodes;
    }

    @Override
    public AlgorithmOutput<N, E> applyAlgorithm(Algorithm<N, E> algorithm, AlgorithmInput<N, E> input) {
        input.setGraph(this);
        return algorithm.apply(input);
    }

    @Override
    public boolean isEmpty() {
        return this.getNodes().isEmpty();
    }

    public int hashCode() {
        int h = 0;
        for (Object node : this.getNodes()) {
            Map adjacentNodes = this.getAdjacentNodesByEdgeMap(node);
            AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(node, adjacentNodes);
            h += entry.hashCode();
        }
        return h;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Graph)) {
            return false;
        }
        Graph otherGraph = (Graph)other;
        if (!this.getNodes().equals(otherGraph.getNodes())) {
            return false;
        }
        for (Object node : this.getNodes()) {
            if (this.getAdjacentNodesByEdgeMap(node).equals(otherGraph.getAdjacentNodesByEdgeMap(node))) continue;
            return false;
        }
        return true;
    }
}

