/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanavarro.graphlib;

import com.github.fanavarro.graphlib.AbstractGraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SimpleGraphImpl<N, E>
extends AbstractGraph<N, E> {
    private static final long serialVersionUID = 2726268195016138010L;
    private Map<N, Map<E, Set<N>>> adjacentNodes = new HashMap<N, Map<E, Set<N>>>();

    @Override
    public Set<N> getNodes() {
        return this.adjacentNodes.keySet();
    }

    @Override
    public Map<E, Set<N>> getAdjacentNodesByEdgeMap(N node) {
        return this.adjacentNodes.getOrDefault(node, new HashMap());
    }

    public void addNode(N node) {
        if (!this.adjacentNodes.containsKey(node)) {
            this.adjacentNodes.put(node, new HashMap());
        }
    }

    public void addNode(N node, E edge, N adjacentNode) {
        if (!this.adjacentNodes.containsKey(node)) {
            this.addNode(node);
        }
        if (!this.adjacentNodes.containsKey(adjacentNode)) {
            this.addNode(adjacentNode);
        }
        if (!this.adjacentNodes.get(node).containsKey(edge)) {
            this.adjacentNodes.get(node).put(edge, new HashSet());
        }
        this.adjacentNodes.get(node).get(edge).add(adjacentNode);
    }

    public void addNode(N node, E edge, Set<N> adjacentNodes) {
        for (N adjacentNode : adjacentNodes) {
            this.addNode(node, edge, adjacentNode);
        }
    }

    public void addNode(N node, Set<E> edges, N adjacentNode) {
        for (E edge : edges) {
            this.addNode(node, edge, adjacentNode);
        }
    }

    public void removeNode(N nodeToRemove) {
        this.adjacentNodes.remove(nodeToRemove);
        for (Map.Entry<N, Map<E, Set<N>>> entry : this.adjacentNodes.entrySet()) {
            N node = entry.getKey();
            Iterator<E> edgeIterator = this.adjacentNodes.get(node).keySet().iterator();
            while (edgeIterator.hasNext()) {
                E edge = edgeIterator.next();
                this.adjacentNodes.get(node).get(edge).remove(nodeToRemove);
                if (!this.adjacentNodes.get(node).get(edge).isEmpty()) continue;
                edgeIterator.remove();
            }
        }
    }

    public void removeLink(N source, E edge, N target) {
        if (this.adjacentNodes.containsKey(source) && this.adjacentNodes.get(source).containsKey(edge)) {
            this.adjacentNodes.get(source).get(edge).remove(target);
            if (this.adjacentNodes.get(source).get(edge).isEmpty()) {
                this.adjacentNodes.get(source).remove(edge);
            }
            if (this.getAdjacentNodes(source).isEmpty() && this.getIncomingNodes(source).isEmpty()) {
                this.removeNode(source);
            }
            if (this.getAdjacentNodes(target).isEmpty() && this.getIncomingNodes(target).isEmpty()) {
                this.removeNode(target);
            }
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleGraphImpl)) {
            return false;
        }
        SimpleGraphImpl castOther = (SimpleGraphImpl)other;
        return new EqualsBuilder().append(this.adjacentNodes, castOther.adjacentNodes).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.adjacentNodes).toHashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<N, Map<E, Set<N>>> entry : this.adjacentNodes.entrySet()) {
            N node = entry.getKey();
            Map<E, Set<N>> adjacentNodesWithEdge = entry.getValue();
            for (Map.Entry<E, Set<N>> entry2 : adjacentNodesWithEdge.entrySet()) {
                E edge = entry2.getKey();
                Set<N> adjacentNodes = entry2.getValue();
                sb.append(String.format("%s -[%s]->  %s\n", node, edge, adjacentNodes));
            }
        }
        return sb.toString();
    }
}

