/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanavarro.graphlib;

import com.github.fanavarro.graphlib.AbstractTree;
import com.github.fanavarro.graphlib.SimpleGraphImpl;
import com.github.fanavarro.graphlib.algorithms.AlgorithmInput;
import com.github.fanavarro.graphlib.algorithms.AlgorithmOutput;
import com.github.fanavarro.graphlib.algorithms.shortest_path.ShortestPathAlgorithm;
import com.github.fanavarro.graphlib.algorithms.shortest_path.ShortestPathInput;
import com.github.fanavarro.graphlib.algorithms.shortest_path.ShortestPathOutput;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SimpleTreeImpl<N, E>
extends AbstractTree<N, E> {
    private static final long serialVersionUID = -7635999002152850671L;
    private SimpleGraphImpl<N, E> internalGraph = new SimpleGraphImpl();

    @Override
    public Set<N> getNodes() {
        return this.internalGraph.getNodes();
    }

    @Override
    public Map<E, Set<N>> getAdjacentNodesByEdgeMap(N node) {
        return this.internalGraph.getAdjacentNodesByEdgeMap(node);
    }

    public void addNode(N node) {
        this.internalGraph.addNode(node);
    }

    public void addNode(N node, E edge, N adjacentNode) {
        this.internalGraph.addNode(node, edge, adjacentNode);
    }

    public void addNode(N node, E edge, Set<N> adjacentNodes) {
        this.internalGraph.addNode(node, edge, adjacentNodes);
    }

    public void addNode(N node, Set<E> edges, N adjacentNodes) {
        this.internalGraph.addNode(node, edges, adjacentNodes);
    }

    public void removeNode(N nodeToRemove) {
        this.internalGraph.removeNode(nodeToRemove);
    }

    public void removeLink(N source, E edge, N target) {
        this.internalGraph.removeLink(source, edge, target);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleTreeImpl)) {
            return false;
        }
        SimpleTreeImpl castOther = (SimpleTreeImpl)other;
        return new EqualsBuilder().append(this.internalGraph, castOther.internalGraph).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.internalGraph).toHashCode();
    }

    public String toString() {
        return this.internalGraph.toString();
    }

    @Override
    public int getHeight() {
        Object root = this.getRoot();
        Set leaves = this.getLeaves();
        int height = 0;
        ShortestPathAlgorithm shortestPathAlgorithm = new ShortestPathAlgorithm();
        for (Object leaf : leaves) {
            ShortestPathInput input = new ShortestPathInput();
            input.setGraph(this);
            input.setMaxDepth(Integer.MAX_VALUE);
            input.setSourceNode(root);
            input.setTargetNode(leaf);
            AlgorithmOutput output = shortestPathAlgorithm.apply((AlgorithmInput)input);
            if (output == null || ((ShortestPathOutput)output).getPath() == null || ((ShortestPathOutput)output).getPath().size() <= height) continue;
            height = ((ShortestPathOutput)output).getPath().size();
        }
        return height + 1;
    }

    @Override
    public int getMaxWidth() {
        int maxWidth = 0;
        for (N node : this.getNodes()) {
            Set<N> adjacentNodes = this.getAdjacentNodes(node);
            if (adjacentNodes == null || adjacentNodes.size() <= maxWidth) continue;
            maxWidth = adjacentNodes.size();
        }
        return maxWidth;
    }
}

