/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanavarro.graphlib.algorithms.islands;

import com.github.fanavarro.graphlib.Graph;
import com.github.fanavarro.graphlib.SimpleGraphImpl;
import com.github.fanavarro.graphlib.algorithms.Algorithm;
import com.github.fanavarro.graphlib.algorithms.AlgorithmInput;
import com.github.fanavarro.graphlib.algorithms.AlgorithmOutput;
import com.github.fanavarro.graphlib.algorithms.islands.IslandsInput;
import com.github.fanavarro.graphlib.algorithms.islands.IslandsOutput;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class IslandsAlgorithm<N, E>
implements Algorithm<N, E> {
    @Override
    public AlgorithmOutput<N, E> apply(AlgorithmInput<N, E> input) {
        IslandsOutput<N, E> output = new IslandsOutput<N, E>();
        Graph<N, E> graph = input.getGraph();
        boolean ignoreEdgeDirection = ((IslandsInput)input).isIgnoreEdgeDirection();
        TreeSet<N> nodesToVisit = new TreeSet<N>(graph.getNodes());
        Set islands = new HashSet<Graph<N, E>>();
        while (!nodesToVisit.isEmpty()) {
            Object rootNode = nodesToVisit.first();
            Graph island = this.getIslandFrom(rootNode, graph, ignoreEdgeDirection);
            islands.add(island);
            nodesToVisit.removeAll(island.getNodes());
        }
        if (!ignoreEdgeDirection) {
            islands = this.removeRedundantIslands(islands);
        }
        output.setInput(input);
        output.setIslands(islands);
        return output;
    }

    private Set<Graph<N, E>> removeRedundantIslands(Set<Graph<N, E>> islands) {
        HashSet<Graph<N, Graph<N, E>>> finalIslands = new HashSet<Graph<N, Graph<N, E>>>();
        if (islands.size() == 1) {
            return islands;
        }
        for (Graph<N, E> island1 : islands) {
            boolean valid = true;
            for (Graph<N, E> island2 : islands) {
                if (island1 == island2 || !island1.isContainedIn(island2)) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            finalIslands.add(island1);
        }
        return finalIslands;
    }

    private Graph<N, E> getIslandFrom(N node, Graph<N, E> graph, boolean ignoreEdgeDirection) {
        SimpleGraphImpl island = new SimpleGraphImpl();
        HashSet visited = new HashSet();
        this.expand(node, graph, island, visited, ignoreEdgeDirection);
        return island;
    }

    private void expand(N node, Graph<N, E> graph, SimpleGraphImpl<N, E> island, Set<N> visited, boolean ignoreEdgeDirection) {
        if (visited.contains(node)) {
            return;
        }
        island.addNode(node);
        visited.add(node);
        Map<E, Set<N>> adjacentNodesWithEdges = graph.getAdjacentNodesByEdgeMap(node);
        this.visit(node, graph, island, visited, adjacentNodesWithEdges, RelationType.ADJACENT_NODE, ignoreEdgeDirection);
        if (ignoreEdgeDirection) {
            Map<E, Set<N>> incomingNodesWithEdges = graph.getIncomingNodesByEdgeMap(node);
            this.visit(node, graph, island, visited, incomingNodesWithEdges, RelationType.INCOMING_NODE, ignoreEdgeDirection);
        }
    }

    private void visit(N node, Graph<N, E> graph, SimpleGraphImpl<N, E> island, Set<N> visited, Map<E, Set<N>> relatedNodesWithEdges, RelationType relationType, boolean ignoreEdgeDirection) {
        for (Map.Entry<E, Set<N>> entry : relatedNodesWithEdges.entrySet()) {
            E edge = entry.getKey();
            Set<N> relatedNodes = entry.getValue();
            if (RelationType.ADJACENT_NODE.equals((Object)relationType)) {
                island.addNode(node, edge, relatedNodes);
            }
            if (RelationType.INCOMING_NODE.equals((Object)relationType)) {
                this.addIncomingNodes(island, relatedNodes, edge, node);
            }
            for (N relatedNode : relatedNodes) {
                this.expand(relatedNode, graph, island, visited, ignoreEdgeDirection);
            }
        }
    }

    private void addIncomingNodes(SimpleGraphImpl<N, E> island, Set<N> incomingNodes, E edge, N node) {
        for (N incomingNode : incomingNodes) {
            island.addNode(incomingNode, edge, node);
        }
    }

    private static enum RelationType {
        ADJACENT_NODE,
        INCOMING_NODE;

    }
}

