/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanavarro.graphlib.algorithms.least_common_node;

import com.github.fanavarro.graphlib.Graph;
import com.github.fanavarro.graphlib.algorithms.Algorithm;
import com.github.fanavarro.graphlib.algorithms.AlgorithmInput;
import com.github.fanavarro.graphlib.algorithms.least_common_node.LeastCommonNodeInput;
import com.github.fanavarro.graphlib.algorithms.least_common_node.LeastCommonNodeOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class LeastCommonNodeAlgorithm<N, E>
implements Algorithm<N, E> {
    @Override
    public LeastCommonNodeOutput<N, E> apply(AlgorithmInput<N, E> input) {
        LeastCommonNodeInput leastCommonNodeInput = (LeastCommonNodeInput)input;
        Set nodes = leastCommonNodeInput.getNodes();
        Graph graph = leastCommonNodeInput.getGraph();
        boolean reverse = leastCommonNodeInput.isReverse();
        Set leastCommonNodes = this.getLeastCommonNode(graph, nodes, reverse);
        LeastCommonNodeOutput leastCommonNodeOutput = new LeastCommonNodeOutput();
        leastCommonNodeOutput.setInput(leastCommonNodeInput);
        leastCommonNodeOutput.setLeastCommonNodes(leastCommonNodes);
        return leastCommonNodeOutput;
    }

    private Set<N> getLeastCommonNode(Graph<N, E> graph, Set<N> nodes, boolean reverse) {
        Set<N> commonNodes = null;
        ArrayList<SortedMap<Integer, Set<N>>> nodesByLevels = new ArrayList<SortedMap<Integer, Set<N>>>();
        for (N node : nodes) {
            TreeMap<Integer, Set<N>> nodesByLevel = new TreeMap<Integer, Set<N>>();
            this.getRelatedNodesByLevel(graph, nodesByLevel, node, 0, reverse);
            nodesByLevels.add(nodesByLevel);
        }
        commonNodes = this.getLeastCommonNode(nodesByLevels);
        return commonNodes;
    }

    private Set<N> getLeastCommonNode(List<SortedMap<Integer, Set<N>>> nodesByLevels) {
        HashSet<N> leastCommonNodes = new HashSet<N>();
        int minLevel = Integer.MAX_VALUE;
        Set<N> commonNodes = this.getCommonNodes(nodesByLevels);
        for (N node : commonNodes) {
            int level = this.getMaxLevel(nodesByLevels, node);
            if (level < minLevel) {
                minLevel = level;
                leastCommonNodes.clear();
                leastCommonNodes.add(node);
                continue;
            }
            if (level != minLevel) continue;
            leastCommonNodes.add(node);
        }
        return leastCommonNodes;
    }

    private int getMaxLevel(List<SortedMap<Integer, Set<N>>> nodesByLevels, N node) {
        int max = Integer.MIN_VALUE;
        for (SortedMap<Integer, Set<N>> nodesByLevel : nodesByLevels) {
            for (Map.Entry<Integer, Set<N>> entry : nodesByLevel.entrySet()) {
                if (!entry.getValue().contains(node) || entry.getKey() <= max) continue;
                max = entry.getKey();
            }
        }
        return max;
    }

    private Set<N> getCommonNodes(List<SortedMap<Integer, Set<N>>> nodesByLevels) {
        Set<Object> commonNodes = new HashSet();
        ArrayList<Set<N>> nodes = new ArrayList<Set<N>>();
        for (SortedMap<Integer, Set<N>> nodesByLevel : nodesByLevels) {
            nodes.add(nodesByLevel.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        }
        commonNodes = this.findIntersection(nodes);
        return commonNodes;
    }

    private Set<N> getRelatedNodes(Graph<N, E> graph, N node, boolean reverse) {
        Set<N> relatedNodes = reverse ? graph.getIncomingNodes(node) : graph.getAdjacentNodes(node);
        return relatedNodes;
    }

    private void getRelatedNodesByLevel(Graph<N, E> graph, Map<Integer, Set<N>> nodesByLevel, N node, int level, boolean reverse) {
        if (nodesByLevel.get(level) == null) {
            nodesByLevel.put(level, new HashSet());
        }
        nodesByLevel.get(level).add(node);
        Set<N> relatedNodes = this.getRelatedNodes(graph, node, reverse);
        for (Object relatedNode : relatedNodes) {
            if (nodesByLevel.values().stream().flatMap(Collection::stream).anyMatch(n -> n.equals(relatedNode))) continue;
            this.getRelatedNodesByLevel(graph, nodesByLevel, relatedNode, level + 1, reverse);
        }
    }

    public Set<N> findIntersection(List<Set<N>> nodes) {
        HashSet<N> hashSet = new HashSet<N>();
        boolean first = true;
        for (Set<N> collection : nodes) {
            if (first) {
                hashSet.addAll(collection);
                first = false;
                continue;
            }
            hashSet.retainAll(collection);
        }
        return hashSet;
    }
}

