/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanavarro.graphlib.algorithms.shortest_path;

import com.github.fanavarro.graphlib.Graph;
import com.github.fanavarro.graphlib.algorithms.Algorithm;
import com.github.fanavarro.graphlib.algorithms.AlgorithmInput;
import com.github.fanavarro.graphlib.algorithms.shortest_path.PathNode;
import com.github.fanavarro.graphlib.algorithms.shortest_path.ShortestPathInput;
import com.github.fanavarro.graphlib.algorithms.shortest_path.ShortestPathOutput;
import com.github.fanavarro.graphlib.algorithms.shortest_path.TreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class ShortestPathAlgorithm<N, E>
implements Algorithm<N, E> {
    @Override
    public ShortestPathOutput<N, E> apply(AlgorithmInput<N, E> input) {
        ShortestPathInput shortestPathInput = (ShortestPathInput)input;
        Object source = shortestPathInput.getSourceNode();
        Object target = shortestPathInput.getTargetNode();
        Graph<N, E> graph = input.getGraph();
        int maxDepth = Integer.MAX_VALUE;
        if (shortestPathInput.getMaxDepth() > 0) {
            maxDepth = shortestPathInput.getMaxDepth();
        }
        TreeNode<N, Set<E>> destinyNode = this.getTreePaths(graph, source, target, maxDepth);
        List<PathNode<N, E>> path = this.buildPath(destinyNode);
        ShortestPathOutput<N, E> output = new ShortestPathOutput<N, E>();
        output.setInput(shortestPathInput);
        output.setPath(path);
        return output;
    }

    private List<PathNode<N, E>> buildPath(TreeNode<N, Set<E>> node) {
        ArrayList path = null;
        if (node != null) {
            path = new ArrayList();
            while (node.getParent() != null) {
                PathNode pathNode = new PathNode();
                N pathNodeSource = node.getParent().getContent();
                N pathNodeDest = node.getContent();
                pathNode.setTarget(pathNodeDest);
                pathNode.setSource(pathNodeSource);
                pathNode.getEdges().addAll(node.getRelationToParent());
                path.add(0, pathNode);
                node = node.getParent();
            }
        }
        return path;
    }

    private TreeNode<N, Set<E>> getTreePaths(Graph<N, E> graph, N source, N destiny, int maxDepth) {
        HashSet visited = new HashSet();
        LinkedList q = new LinkedList();
        LinkedList<Integer> depthQueue = new LinkedList<Integer>();
        q.add(new TreeNode(source, 0));
        visited.add(new TreeNode(source, 0));
        depthQueue.add(0);
        while (!q.isEmpty()) {
            TreeNode current = (TreeNode)q.poll();
            Integer depth = (Integer)depthQueue.poll();
            if (current.getContent().equals(destiny)) {
                return current;
            }
            if (depth > maxDepth) continue;
            this.expand(graph, visited, q, depthQueue, current, depth);
        }
        return null;
    }

    private void expand(Graph<N, E> graph, Set<TreeNode<N, Set<E>>> visited, Queue<TreeNode<N, Set<E>>> q, Queue<Integer> depthQueue, TreeNode<N, Set<E>> current, Integer depth) {
        for (Map.Entry<E, Set<N>> entry : graph.getAdjacentNodesByEdgeMap(current.getContent()).entrySet()) {
            E edge = entry.getKey();
            for (N node : entry.getValue()) {
                TreeNode<N, Set<E>> n = this.getTreeNodeFromCollection(node, current.getContent(), q);
                if (n == null) {
                    n = new TreeNode(node);
                    n.setRelationToParent(new HashSet());
                }
                if (this.visited(n, visited, depth + 1)) continue;
                n.setHeight(depth + 1);
                n.setParent(current);
                n.getRelationToParent().add(edge);
                current.addChild(n);
                q.add(n);
                visited.add(n);
                depthQueue.add(depth + 1);
            }
        }
    }

    private boolean visited(TreeNode<N, Set<E>> node, Collection<TreeNode<N, Set<E>>> s, int currentDepth) {
        for (TreeNode<N, Set<E>> iterator : s) {
            if (!iterator.getContent().equals(node.getContent()) || currentDepth <= iterator.getHeight()) continue;
            return true;
        }
        return false;
    }

    private TreeNode<N, Set<E>> getTreeNodeFromCollection(N owlClass, N parent, Collection<TreeNode<N, Set<E>>> collection) {
        for (TreeNode<N, Set<E>> node : collection) {
            if (!node.getContent().equals(owlClass) || !node.getParent().getContent().equals(parent)) continue;
            return node;
        }
        return null;
    }
}

