/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanavarro.graphlib.algorithms.shortest_path;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class TreeNode<N, E> {
    private TreeNode<N, E> parent;
    private List<TreeNode<N, E>> children;
    private E relationToParent;
    private N content;
    private Integer height;

    public TreeNode() {
        this(null, null, null, null);
    }

    public TreeNode(N content, TreeNode<N, E> parent, List<TreeNode<N, E>> children, Integer height) {
        this.content = content;
        this.parent = parent;
        this.children = children;
        this.height = height;
    }

    public TreeNode(N content) {
        this(content, null, null, null);
        this.height = 0;
    }

    public TreeNode(N content, Integer height) {
        this(content, null, null, height);
    }

    public TreeNode<N, E> getParent() {
        return this.parent;
    }

    public void setParent(TreeNode<N, E> parent) {
        this.parent = parent;
    }

    public List<TreeNode<N, E>> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode<N, E>> children) {
        this.children = children;
    }

    public void addChild(TreeNode<N, E> child) {
        if (this.children == null) {
            this.children = new ArrayList<TreeNode<N, E>>();
        }
        this.children.add(child);
    }

    public N getContent() {
        return this.content;
    }

    public void setContent(N content) {
        this.content = content;
    }

    public E getRelationToParent() {
        return this.relationToParent;
    }

    public void setRelationToParent(E relationToParent) {
        this.relationToParent = relationToParent;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TreeNode)) {
            return false;
        }
        TreeNode castOther = (TreeNode)other;
        return new EqualsBuilder().append(this.content, castOther.content).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.content).toHashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TreeNode [content=");
        builder.append(this.content);
        builder.append("]");
        return builder.toString();
    }
}

