/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanavarro.graphlib.algorithms.subtree;

import com.github.fanavarro.graphlib.Graph;
import com.github.fanavarro.graphlib.SimpleTreeImpl;
import com.github.fanavarro.graphlib.Tree;
import com.github.fanavarro.graphlib.algorithms.Algorithm;
import com.github.fanavarro.graphlib.algorithms.AlgorithmInput;
import com.github.fanavarro.graphlib.algorithms.AlgorithmOutput;
import com.github.fanavarro.graphlib.algorithms.least_common_node.LeastCommonNodeAlgorithm;
import com.github.fanavarro.graphlib.algorithms.least_common_node.LeastCommonNodeInput;
import com.github.fanavarro.graphlib.algorithms.least_common_node.LeastCommonNodeOutput;
import com.github.fanavarro.graphlib.algorithms.subtree.SubtreeInput;
import com.github.fanavarro.graphlib.algorithms.subtree.SubtreeOutput;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class SubtreeAlgorithm<N, E>
implements Algorithm<N, E> {
    @Override
    public AlgorithmOutput<N, E> apply(AlgorithmInput<N, E> input) {
        SubtreeInput subtreeInput = (SubtreeInput)input;
        SubtreeOutput<N, E> output = this.getTreeContainingNodes(subtreeInput);
        return output;
    }

    private SubtreeOutput<N, E> getTreeContainingNodes(SubtreeInput<N, E> subtreeInput) {
        SubtreeOutput<N, E> output = new SubtreeOutput<N, E>();
        output.setInput(subtreeInput);
        HashSet<N> nodesToBeContained = subtreeInput.getNodesToBeContained() != null ? subtreeInput.getNodesToBeContained() : new HashSet<N>();
        HashSet edgesToBeContained = subtreeInput.getEdgesToBeContained() != null ? subtreeInput.getEdgesToBeContained() : new HashSet();
        Graph graph = subtreeInput.getGraph();
        Integer maxDepth = subtreeInput.getMaxDepth() != null ? subtreeInput.getMaxDepth() : Integer.MAX_VALUE;
        boolean computeCommonAncestors = subtreeInput.isComputeCommonAncestor();
        if (nodesToBeContained.isEmpty()) {
            for (Object edge : edgesToBeContained) {
                Set<N> sourceNodes = graph.getSourceNodes(edge);
                nodesToBeContained.addAll(sourceNodes);
            }
        }
        Set<Object> commonAncestors = new HashSet();
        if (computeCommonAncestors) {
            commonAncestors = this.getCommonAncestors(graph, nodesToBeContained);
        }
        HashSet possibleRoots = new HashSet(nodesToBeContained);
        possibleRoots.addAll(commonAncestors);
        for (Object rootNode : possibleRoots) {
            Tree<N, E> subtree = this.getTreeContainingNodes(graph, nodesToBeContained, edgesToBeContained, rootNode, maxDepth);
            if (subtree == null) continue;
            output.addTree(subtree);
        }
        return output;
    }

    private Set<N> getCommonAncestors(Graph<N, E> graph, Set<N> nodes) {
        Set<Object> commonAncestors = new HashSet();
        LeastCommonNodeAlgorithm lcnAlgorithm = new LeastCommonNodeAlgorithm();
        LeastCommonNodeInput input = new LeastCommonNodeInput();
        input.setGraph(graph);
        input.setNodes(nodes);
        input.setReverse(true);
        LeastCommonNodeOutput output = (LeastCommonNodeOutput)graph.applyAlgorithm(lcnAlgorithm, input);
        if (output != null && output.getLeastCommonNodes() != null) {
            commonAncestors = output.getLeastCommonNodes();
        }
        return commonAncestors;
    }

    private Tree<N, E> getTreeContainingNodes(Graph<N, E> graph, Set<N> nodesToBeContained, Set<E> edgesToBeContained, N rootNode, Integer maxDepth) {
        SimpleTreeImpl output = new SimpleTreeImpl();
        HashSet<N> nodesToVisit = new HashSet<N>(nodesToBeContained);
        HashSet<E> edgesToVisit = new HashSet<E>(edgesToBeContained);
        LinkedList<N> queuedNodes = new LinkedList<N>();
        LinkedList<Set<E>> queuedEdges = new LinkedList<Set<E>>();
        LinkedList queuedSourceNodes = new LinkedList();
        LinkedList<Integer> depthQueue = new LinkedList<Integer>();
        depthQueue.add(1);
        queuedNodes.add(rootNode);
        nodesToVisit.remove(rootNode);
        HashSet visitedNodes = new HashSet();
        while (!queuedNodes.isEmpty()) {
            Object currentNode = queuedNodes.poll();
            Set prevEdges = (Set)queuedEdges.poll();
            Object prevNode = queuedSourceNodes.poll();
            Integer depth = (Integer)depthQueue.poll();
            if (prevNode == null && prevEdges == null) {
                output.addNode(currentNode);
            } else {
                output.addNode(prevNode, prevEdges, currentNode);
                edgesToVisit.removeAll(prevEdges);
            }
            nodesToVisit.remove(currentNode);
            visitedNodes.add(currentNode);
            if (nodesToVisit.isEmpty() && edgesToVisit.isEmpty()) {
                this.pruneTree(output, nodesToBeContained, edgesToBeContained);
                return output;
            }
            if (depth >= maxDepth) continue;
            Map<N, Set<E>> adjacentNodesWithEdges = graph.getEdgesByAdjacentNodeMap(currentNode);
            for (Map.Entry<N, Set<E>> entry : adjacentNodesWithEdges.entrySet()) {
                N adjacentNode = entry.getKey();
                Set<E> edges = entry.getValue();
                if (visitedNodes.contains(adjacentNode)) continue;
                queuedSourceNodes.add(currentNode);
                queuedEdges.add(edges);
                queuedNodes.add(adjacentNode);
                depthQueue.add(depth + 1);
            }
        }
        return null;
    }

    private void pruneTree(Tree<N, E> tree, Set<N> nodesToBeContained, Set<E> edgesToBeContained) {
        while (!this.pruneTreeFinishCondition(tree, nodesToBeContained, edgesToBeContained)) {
            for (N leaf : tree.getLeaves()) {
                if (!this.shouldPruneLeaf(tree, nodesToBeContained, edgesToBeContained, leaf)) continue;
                ((SimpleTreeImpl)tree).removeNode(leaf);
            }
        }
        for (N node : tree.getNodes()) {
            Map edgesByAdjacentNodes = tree.getEdgesByAdjacentNodeMap(node);
            for (Map.Entry edgesByAdjacentNode : edgesByAdjacentNodes.entrySet()) {
                N adjacentNode = edgesByAdjacentNode.getKey();
                Set edges = edgesByAdjacentNode.getValue();
                if (!edgesToBeContained.stream().anyMatch(edges::contains)) continue;
                for (Object edge : edges) {
                    if (edgesToBeContained.contains(edge)) continue;
                    ((SimpleTreeImpl)tree).removeLink(node, edge, adjacentNode);
                }
            }
        }
    }

    private boolean shouldPruneLeaf(Tree<N, E> tree, Set<N> nodesToBeContained, Set<E> edgesToBeContained, N leaf) {
        boolean prune = false;
        if (!nodesToBeContained.contains(leaf)) {
            Map leafIncomingNodesWithEdges = tree.getIncomingNodesByEdgeMap(leaf);
            Sets.SetView edgeIntersection = Sets.intersection(leafIncomingNodesWithEdges.keySet(), edgesToBeContained);
            if (edgeIntersection.isEmpty()) {
                prune = true;
            }
            for (N otherLeaf : tree.getLeaves()) {
                if (otherLeaf == leaf || !nodesToBeContained.contains(otherLeaf)) continue;
                for (Object edge : edgeIntersection) {
                    Set<N> incomingNodesThroughEdgeInOtherLeaf = tree.getIncomingNodesByEdgeMap(otherLeaf).get(edge);
                    if (incomingNodesThroughEdgeInOtherLeaf != null && incomingNodesThroughEdgeInOtherLeaf.containsAll((Collection)leafIncomingNodesWithEdges.get(edge))) {
                        prune = true;
                        continue;
                    }
                    if (prune) {
                        // empty if block
                    }
                    prune = false;
                }
            }
        }
        return prune;
    }

    private boolean pruneTreeFinishCondition(Tree<N, E> tree, Set<N> nodesToBeContained, Set<E> edgesToBeContained) {
        for (N leaf : tree.getLeaves()) {
            if (nodesToBeContained.contains(leaf) || tree.getIncomingEdges(leaf).stream().anyMatch(edge -> edgesToBeContained.contains(edge))) continue;
            return false;
        }
        return true;
    }
}

