/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanavarro.graphlib.serializers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fanavarro.graphlib.Graph;
import com.github.fanavarro.graphlib.serializers.Serializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JGFSerializer<N, E>
implements Serializer<N, E> {
    protected static final String ARRAY_SEPARATOR = ", ";
    protected static final String RELATION = "relation";
    protected static final String TARGET = "target";
    protected static final String SOURCE = "source";
    protected static final String ID = "id";
    protected static final String GRAPH = "graph";
    protected static final String EDGES = "edges";
    protected static final String NODES = "nodes";
    protected static final String DIRECTED = "directed";
    protected static final String LABEL = "label";
    protected static final String METADATA = "metadata";
    private ObjectMapper mapper = new ObjectMapper();

    @Override
    public String serialize(Graph<N, E> graph, String graphName) {
        ObjectNode jsonRoot = this.mapper.createObjectNode();
        ObjectNode jsonGraph = this.mapper.createObjectNode();
        jsonGraph.put(LABEL, graphName);
        jsonGraph.put(DIRECTED, true);
        jsonGraph.set(NODES, (JsonNode)this.createNodes(graph));
        jsonGraph.set(EDGES, (JsonNode)this.createEdges(graph));
        jsonRoot.set(GRAPH, (JsonNode)jsonGraph);
        return jsonRoot.toPrettyString();
    }

    private ArrayNode createNodes(Graph<N, E> graph) {
        ArrayNode jsonGraphNodes = this.mapper.createArrayNode();
        for (N node : graph.getNodes()) {
            ObjectNode jsonGraphNode = this.serializeNode(node, graph);
            jsonGraphNodes.add((JsonNode)jsonGraphNode);
        }
        return jsonGraphNodes;
    }

    private ArrayNode createEdges(Graph<N, E> graph) {
        ArrayNode jsonGraphEdges = this.mapper.createArrayNode();
        for (N node : graph.getNodes()) {
            for (Map.Entry<E, Set<N>> entry : graph.getAdjacentNodesByEdgeMap(node).entrySet()) {
                E edge = entry.getKey();
                Set<N> adjacentNodes = entry.getValue();
                if (adjacentNodes.isEmpty()) continue;
                for (ObjectNode edgeJson : this.serializeEdge(node, edge, adjacentNodes, graph)) {
                    jsonGraphEdges.add((JsonNode)edgeJson);
                }
            }
        }
        return jsonGraphEdges;
    }

    protected ObjectNode serializeNode(N node, Graph<N, E> graph) {
        ObjectNode jsonGraphNode = this.mapper.createObjectNode();
        ObjectNode metadata = this.getMetadataNode(node, graph);
        jsonGraphNode.put(ID, node.toString());
        jsonGraphNode.put(LABEL, node.toString());
        if (metadata != null) {
            jsonGraphNode.set(METADATA, (JsonNode)metadata);
        }
        return jsonGraphNode;
    }

    protected List<ObjectNode> serializeEdge(N sourceNode, E edge, Set<N> targetNodes, Graph<N, E> graph) {
        ArrayList<ObjectNode> jsonGraphEdges = new ArrayList<ObjectNode>();
        for (N targetNode : targetNodes) {
            ObjectNode jsonGraphEdge = this.serializeEdge(sourceNode, edge, targetNode, graph);
            jsonGraphEdges.add(jsonGraphEdge);
        }
        return jsonGraphEdges;
    }

    protected ObjectNode serializeEdge(N sourceNode, E edge, N targetNode, Graph<N, E> graph) {
        ObjectNode jsonGraphEdge = this.mapper.createObjectNode();
        ObjectNode metadata = this.getMetadataEdge(edge, graph);
        jsonGraphEdge.put(SOURCE, sourceNode.toString());
        jsonGraphEdge.put(TARGET, targetNode.toString());
        jsonGraphEdge.put(RELATION, edge.toString());
        jsonGraphEdge.put(LABEL, edge.toString());
        if (metadata != null) {
            jsonGraphEdge.set(METADATA, (JsonNode)metadata);
        }
        return jsonGraphEdge;
    }

    protected ObjectNode getMetadataNode(N node, Graph<N, E> graph) {
        return null;
    }

    protected ObjectNode getMetadataEdge(E edge, Graph<N, E> graph) {
        return null;
    }

    protected ObjectMapper getMapper() {
        return this.mapper;
    }
}

