/*
 * Decompiled with CFR 0.152.
 */
package com.github.fanavarro.graphlib.serializers;

import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONSerializerValidator {
    private static String JGF_SCHEMA_RESOURCE = "/jsonValidationSchemas/JGFSchema.json";

    public static void validateJSON(JSONObject schemaJson, JSONObject inputJson) {
        Schema schema = SchemaLoader.load((JSONObject)schemaJson);
        schema.validate((Object)inputJson);
    }

    public static void validateJGF(JSONObject inputJson) {
        JSONObject schemaJson = new JSONObject(new JSONTokener(JSONSerializerValidator.class.getResourceAsStream(JGF_SCHEMA_RESOURCE)));
        JSONSerializerValidator.validateJSON(schemaJson, inputJson);
    }

    public static void validateJGF(String inputString) {
        JSONObject inputJson = new JSONObject(inputString);
        JSONSerializerValidator.validateJGF(inputJson);
    }
}

