package conformance;

/* This file is part of the JFact DL reasoner
 Copyright 2011-2013 by Ignazio Palmisano, Dmitry Tsarkov, University of Manchester
 This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any later version.
 This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA*/
import org.junit.Test;


@SuppressWarnings("javadoc")
public class WebOnt_miscellaneous_wine {
    @Test
    @Changed
    public void testWebOnt_miscellaneous_001() {

        String premise1 = "<!DOCTYPE owl [ "
                + "<!ENTITY vin  \"http://www.w3.org/2002/03owlt/miscellaneous/consistent001#\" > "
                + "<!ENTITY food \"http://www.w3.org/2002/03owlt/miscellaneous/consistent002#\" > "
                + "<!ENTITY owl  \"http://www.w3.org/2002/07/owl#\" > "
                + "<!ENTITY xsd  \"http://www.w3.org/2001/XMLSchema#\" > ]>\n"
                + "<rdf:RDF xmlns     = \"&vin;\" xmlns:vin = \"&vin;\" xml:base  = \"&vin;\" xmlns:food= \"&food;\" xmlns:owl = \"&owl;\" xmlns:rdf = \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:rdfs= \"http://www.w3.org/2000/01/rdf-schema#\">\n"
                + "  <owl:Ontology rdf:about=\"\"><rdfs:comment>An example OWL ontology</rdfs:comment><owl:priorVersion><owl:Ontology rdf:about=\"http://www.example.org/wine-020303\"/></owl:priorVersion><rdfs:comment>Derived from the DAML Wine ontology at  http://ontolingua.stanford.edu/doc/chimaera/ontologies/wines.daml  Substantially changed, in particular the Region based relations.</rdfs:comment><rdfs:label>Wine Ontology</rdfs:label></owl:Ontology>\n"
                + "    <owl:Class  rdf:about=\"#WineDescriptor\" />\n"
                + "  <owl:Class rdf:about=\"#ConsumableThing\" /><owl:ObjectProperty  rdf:about=\"http://www.w3.org/2002/03owlt/miscellaneous/consistent002#madeFromFruit\" />\n"
                + "  <owl:Class rdf:about=\"http://www.w3.org/2002/03owlt/miscellaneous/consistent002#PotableLiquid\" />\n"
                + "  <owl:Class rdf:about=\"#NonConsumableThing\"><owl:complementOf rdf:resource=\"#ConsumableThing\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#EdibleThing\"><rdfs:subClassOf rdf:resource=\"#ConsumableThing\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#PotableLiquid\"><rdfs:subClassOf rdf:resource=\"#ConsumableThing\" /><owl:disjointWith rdf:resource=\"#EdibleThing\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#Wine\"/>\n"
                + "  <owl:Class rdf:about=\"&food;Grape\"/>\n"
                + "  <owl:ObjectProperty rdf:about=\"#madeFromFruit\"><rdfs:domain rdf:resource=\"#ConsumableThing\" /><rdfs:range rdf:resource=\"#Fruit\" /></owl:ObjectProperty>\n"
                + "  <owl:Class rdf:about=\"#Juice\"><rdfs:subClassOf rdf:resource=\"#PotableLiquid\" /><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromFruit\" />\n"
                + "  <owl:minCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:minCardinality></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:ObjectProperty rdf:about=\"#hasDrink\"><rdfs:domain rdf:resource=\"#MealCourse\" /><rdfs:range rdf:resource=\"#PotableLiquid\" /></owl:ObjectProperty>\n"
                + "  <owl:Thing rdf:about=\"#White\"/>\n"
                + "  <owl:Thing rdf:about=\"#Rose\"/>\n"
                + "  <owl:Thing rdf:about=\"#Red\"/>\n"
                + "  <owl:Thing rdf:about=\"#Sweet\"/>\n"
                + "  <owl:Thing rdf:about=\"#OffDry\"/>\n"
                + "  <owl:Thing rdf:about=\"#Dry\"/>\n"
                + "  <owl:Thing rdf:about=\"#Delicate\"/>\n"
                + "  <owl:Thing rdf:about=\"#Moderate\"/>\n"
                + "  <owl:Thing rdf:about=\"#Strong\"/>\n"
                + "  <owl:Thing rdf:about=\"#Light\"/>\n"
                + "  <owl:Thing rdf:about=\"#Medium\"/>\n"
                + "  <owl:Thing rdf:about=\"#Full\"/>\n"
                + "  <owl:ObjectProperty rdf:about=\"#course\"><rdfs:domain rdf:resource=\"#Meal\" /><rdfs:range rdf:resource=\"#MealCourse\" /></owl:ObjectProperty>\n"
                + "  <owl:Class rdf:about=\"#Grape\"><rdfs:subClassOf rdf:resource=\"#SweetFruit\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#Pasta\"><rdfs:subClassOf rdf:resource=\"#EdibleThing\" /><owl:disjointWith rdf:resource=\"#Meat\" /><owl:disjointWith rdf:resource=\"#Fowl\" /><owl:disjointWith rdf:resource=\"#Seafood\" /><owl:disjointWith rdf:resource=\"#Dessert\" /><owl:disjointWith rdf:resource=\"#Fruit\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#PastaWithWhiteSauce\"><rdfs:subClassOf rdf:resource=\"#Pasta\" /><owl:disjointWith rdf:resource=\"#PastaWithRedSauce\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#PastaWithSpicyRedSauceCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#PastaWithSpicyRedSauce\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasBody\" /><owl:hasValue rdf:resource=\"#Full\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasFlavor\" /><owl:hasValue rdf:resource=\"#Strong\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#PastaWithSpicyRedSauce\"><rdfs:subClassOf rdf:resource=\"#PastaWithRedSauce\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#PastaWithRedSauce\"><rdfs:subClassOf rdf:resource=\"#Pasta\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#PastaWithNonSpicyRedSauceCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#PastaWithNonSpicyRedSauce\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasBody\" /><owl:hasValue rdf:resource=\"#Medium\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasFlavor\" /><owl:hasValue rdf:resource=\"#Moderate\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#PastaWithNonSpicyRedSauce\"><rdfs:subClassOf rdf:resource=\"#PastaWithRedSauce\" /><owl:disjointWith rdf:resource=\"#PastaWithSpicyRedSauce\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#PastaWithLightCreamSauce\"><rdfs:subClassOf rdf:resource=\"#PastaWithWhiteSauce\" /><owl:disjointWith rdf:resource=\"#PastaWithHeavyCreamSauce\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#PastaWithLightCreamCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#PastaWithLightCreamSauce\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasBody\" /><owl:hasValue rdf:resource=\"#Light\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasFlavor\" /><owl:hasValue rdf:resource=\"#Delicate\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#PastaWithHeavyCreamSauce\"><rdfs:subClassOf rdf:resource=\"#PastaWithWhiteSauce\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#PastaWithHeavyCreamCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#PastaWithHeavyCreamSauce\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasBody\" /><owl:hasValue rdf:resource=\"#Medium\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasFlavor\" /><owl:hasValue rdf:resource=\"#Moderate\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#OysterShellfishCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#OysterShellfish\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasSugar\" /><owl:hasValue rdf:resource=\"#Sweet\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#OysterShellfish\"><rdfs:subClassOf rdf:resource=\"#Shellfish\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#OtherTomatoBasedFoodCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#OtherTomatoBasedFood\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasBody\" /><owl:hasValue rdf:resource=\"#Medium\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasFlavor\" /><owl:hasValue rdf:resource=\"#Moderate\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#OtherTomatoBasedFood\"><rdfs:subClassOf rdf:resource=\"#EdibleThing\" /><owl:disjointWith rdf:resource=\"#Pasta\" /><owl:disjointWith rdf:resource=\"#Meat\" /><owl:disjointWith rdf:resource=\"#Fowl\" /><owl:disjointWith rdf:resource=\"#Seafood\" /><owl:disjointWith rdf:resource=\"#Dessert\" /><owl:disjointWith rdf:resource=\"#Fruit\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#NonSweetFruitCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#NonSweetFruit\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasFlavor\" /><owl:hasValue rdf:resource=\"#Delicate\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasSugar\" /><owl:hasValue rdf:resource=\"#OffDry\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#SweetFruitCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#SweetFruit\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasFlavor\" /><owl:hasValue rdf:resource=\"#Moderate\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasSugar\" /><owl:hasValue rdf:resource=\"#Sweet\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#NonSweetFruit\"><rdfs:subClassOf rdf:resource=\"#EdibleThing\" /><owl:disjointWith rdf:resource=\"#SweetFruit\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#NonSpicyRedMeatCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#NonSpicyRedMeat\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasBody\" /><owl:hasValue rdf:resource=\"#Medium\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasFlavor\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Strong\" /><owl:Thing rdf:about=\"#Moderate\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#NonSpicyRedMeat\"><rdfs:subClassOf rdf:resource=\"#RedMeat\" /><owl:disjointWith rdf:resource=\"#SpicyRedMeat\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#NonRedMeatCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#NonRedMeat\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasBody\" /><owl:hasValue rdf:resource=\"#Medium\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasFlavor\" /><owl:hasValue rdf:resource=\"#Strong\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#NonRedMeat\"><rdfs:subClassOf rdf:resource=\"#Meat\" /><owl:disjointWith rdf:resource=\"#RedMeat\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#NonOysterShellfishCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#NonOysterShellfish\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#NonOysterShellfish\"><rdfs:subClassOf rdf:resource=\"#Shellfish\" /><owl:disjointWith rdf:resource=\"#OysterShellfish\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#NonBlandFishCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#NonBlandFish\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasFlavor\" /><owl:hasValue rdf:resource=\"#Moderate\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#NonBlandFish\"><rdfs:subClassOf rdf:resource=\"#Fish\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#Meat\"><rdfs:subClassOf rdf:resource=\"#EdibleThing\" /><owl:disjointWith rdf:resource=\"#Fowl\" /><owl:disjointWith rdf:resource=\"#Seafood\" /><owl:disjointWith rdf:resource=\"#Dessert\" /><owl:disjointWith rdf:resource=\"#Fruit\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#MealCourse\"><rdfs:subClassOf rdf:resource=\"#ConsumableThing\" /><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:minCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:minCardinality></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:minCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:minCardinality></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom rdf:resource=\"#Wine\" /></owl:Restriction></rdfs:subClassOf><owl:disjointWith rdf:resource=\"#PotableLiquid\" /><owl:disjointWith rdf:resource=\"#EdibleThing\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#Meal\"><rdfs:subClassOf rdf:resource=\"#ConsumableThing\" /><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#course\" /><owl:minCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:minCardinality></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#course\" /><owl:allValuesFrom rdf:resource=\"#MealCourse\" /></owl:Restriction></rdfs:subClassOf><owl:disjointWith rdf:resource=\"#MealCourse\" /><owl:disjointWith rdf:resource=\"#PotableLiquid\" /><owl:disjointWith rdf:resource=\"#EdibleThing\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#LightMeatFowlCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#LightMeatFowl\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasBody\" /><owl:hasValue rdf:resource=\"#Medium\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasFlavor\" /><owl:hasValue rdf:resource=\"#Moderate\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#LightMeatFowl\"><rdfs:subClassOf rdf:resource=\"#Fowl\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#FruitCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#Fruit\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasBody\" /><owl:hasValue rdf:resource=\"#Medium\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#Fruit\"><owl:unionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#SweetFruit\" /><owl:Class rdf:about=\"#NonSweetFruit\" /></owl:unionOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#Fowl\"><rdfs:subClassOf rdf:resource=\"#EdibleThing\" /><owl:disjointWith rdf:resource=\"#Seafood\" /><owl:disjointWith rdf:resource=\"#Dessert\" /><owl:disjointWith rdf:resource=\"#Fruit\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#FishCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#Fish\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasBody\" /><owl:hasValue rdf:resource=\"#Medium\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#DessertCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#Dessert\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasBody\" /><owl:hasValue rdf:resource=\"#Full\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasFlavor\" /><owl:hasValue rdf:resource=\"#Strong\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasSugar\" /><owl:hasValue rdf:resource=\"#Sweet\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#Dessert\"><rdfs:subClassOf rdf:resource=\"#EdibleThing\" /><owl:disjointWith rdf:resource=\"#Fruit\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#SweetFruit\"><rdfs:subClassOf rdf:resource=\"#EdibleThing\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#SweetDessertCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#SweetDessert\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#SweetDessert\"><rdfs:subClassOf rdf:resource=\"#Dessert\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#DarkMeatFowlCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#DarkMeatFowl\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasBody\" /><owl:hasValue rdf:resource=\"#Light\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasFlavor\" /><owl:hasValue rdf:resource=\"#Delicate\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#DarkMeatFowl\"><rdfs:subClassOf rdf:resource=\"#Fowl\" /><owl:disjointWith rdf:resource=\"#LightMeatFowl\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#CheeseNutsDessertCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#CheeseNutsDessert\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#CheeseNutsDessert\"><rdfs:subClassOf rdf:resource=\"#Dessert\" /><owl:disjointWith rdf:resource=\"#SweetDessert\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#BlandFishCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#BlandFish\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasFlavor\" /><owl:hasValue rdf:resource=\"#Delicate\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#BlandFish\"><rdfs:subClassOf rdf:resource=\"#Fish\" /><owl:disjointWith rdf:resource=\"#NonBlandFish\" /></owl:Class>\n"
                + "  <owl:ObjectProperty rdf:about=\"#hasFood\"><rdfs:domain rdf:resource=\"#MealCourse\" /><rdfs:range rdf:resource=\"#EdibleThing\" /></owl:ObjectProperty>\n"
                + "  <owl:Class rdf:about=\"#Fish\"><rdfs:subClassOf rdf:resource=\"#Seafood\" /><owl:disjointWith rdf:resource=\"#Shellfish\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#SpicyRedMeat\"><rdfs:subClassOf rdf:resource=\"#RedMeat\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#ShellfishCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#Shellfish\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasFlavor\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Moderate\" /><owl:Thing rdf:about=\"#Strong\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasBody\" /><owl:hasValue rdf:resource=\"#Full\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#Shellfish\"><rdfs:subClassOf rdf:resource=\"#Seafood\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#SeafoodCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#Seafood\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#Seafood\"><rdfs:subClassOf rdf:resource=\"#EdibleThing\" /><owl:disjointWith rdf:resource=\"#Dessert\" /><owl:disjointWith rdf:resource=\"#Fruit\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#RedMeatCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#RedMeat\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#RedMeat\"><rdfs:subClassOf rdf:resource=\"#Meat\" /></owl:Class>\n"
                + "  <SweetDessert rdf:about=\"#Cake\" />\n"
                + "  <SweetFruit rdf:about=\"#Bananas\" />\n"
                + "  <SweetFruit rdf:about=\"#MixedFruit\" />\n"
                + "  <NonOysterShellfish rdf:about=\"#Mussels\" />\n"
                + "  <CheeseNutsDessert rdf:about=\"#Nuts\" />\n"
                + "  <OysterShellfish rdf:about=\"#Oysters\" />\n"
                + "  <PastaWithLightCreamSauce rdf:about=\"#PastaWithWhiteClamSauce\" />\n"
                + "  <SweetFruit rdf:about=\"#Peaches\" />\n"
                + "  <SweetDessert rdf:about=\"#Pie\" />\n"
                + "  <OtherTomatoBasedFood rdf:about=\"#Pizza\" />\n"
                + "  <NonRedMeat rdf:about=\"#Pork\" />\n"
                + "  <NonSpicyRedMeat rdf:about=\"#RoastBeef\" />\n"
                + "  <BlandFish rdf:about=\"#Scrod\" />\n"
                + "  <PastaWithNonSpicyRedSauce rdf:about=\"#SpaghettiWithTomatoSauce\" />\n"
                + "  <NonSpicyRedMeat rdf:about=\"#Steak\" />\n"
                + "  <NonBlandFish rdf:about=\"#Swordfish\" />\n"
                + "  <EatingGrape rdf:about=\"#ThompsonSeedless\" />\n"
                + "  <owl:Class rdf:about=\"#EatingGrape\"><rdfs:subClassOf rdf:resource=\"#Grape\" /></owl:Class>\n"
                + "  <NonBlandFish rdf:about=\"#Tuna\" />\n"
                + "  <LightMeatFowl rdf:about=\"#Turkey\" />\n"
                + "  <NonSpicyRedMeat rdf:about=\"#Veal\" />\n"
                + "  <owl:Class rdf:about=\"#SpicyRedMeatCourse\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#MealCourse\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasFood\" /><owl:allValuesFrom rdf:resource=\"#SpicyRedMeat\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasBody\" /><owl:hasValue rdf:resource=\"#Full\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasFlavor\" /><owl:hasValue rdf:resource=\"#Moderate\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasDrink\" /><owl:allValuesFrom><owl:Restriction><owl:onProperty rdf:resource=\"&vin;hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <SpicyRedMeat rdf:about=\"#BeefCurry\" />\n"
                + "  <LightMeatFowl rdf:about=\"#Chicken\" />\n"
                + "  <NonOysterShellfish rdf:about=\"#Clams\" />\n"
                + "  <DarkMeatFowl rdf:about=\"#Duck\" />\n"
                + "  <SpicyRedMeat rdf:about=\"#GarlickyRoast\" />\n"
                + "  <DarkMeatFowl rdf:about=\"#Goose\" />\n"
                + "  <BlandFish rdf:about=\"#Halibut\" />\n"
                + "  <NonOysterShellfish rdf:about=\"#Crab\" />\n"
                + "  <BlandFish rdf:about=\"#Flounder\" />\n"
                + "  <NonOysterShellfish rdf:about=\"#Lobster\" />\n"
                + "  <PastaWithHeavyCreamSauce rdf:about=\"#FettucineAlfRedo\" />\n"
                + "  <PastaWithSpicyRedSauce rdf:about=\"#FraDiavolo\" />\n"
                + "  <CheeseNutsDessert rdf:about=\"#Cheese\" />\n";

        String premise2 = "  <owl:Class rdf:about=\"#Wine\"><rdfs:subClassOf rdf:resource=\"&food;PotableLiquid\" /><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasMaker\" />\n"
                + " <owl:cardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:cardinality></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasMaker\" />\n"
                + " <owl:allValuesFrom rdf:resource=\"#Winery\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" />\n"
                + "  <owl:minCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:minCardinality></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:cardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:cardinality></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:cardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:cardinality></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:cardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:cardinality></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:cardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:cardinality></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\"/> <owl:someValuesFrom rdf:resource=\"&vin;Region\"/></owl:Restriction></rdfs:subClassOf><rdfs:label xml:lang=\"en\">wine</rdfs:label><rdfs:label xml:lang=\"fr\">vin</rdfs:label></owl:Class>"
                + "  <owl:Class rdf:about=\"#Vintage\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasVintageYear\"/>  <owl:cardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:cardinality></owl:Restriction></rdfs:subClassOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#WineGrape\"><rdfs:subClassOf rdf:resource=\"&food;Grape\" /></owl:Class>"
                + "  <owl:Class rdf:about=\"#WhiteWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#WhiteTableWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#TableWine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#WhiteNonSweetWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#WhiteWine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Dry\" /><owl:Thing rdf:about=\"#OffDry\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#WhiteLoire\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Loire\" /><owl:Class rdf:about=\"#WhiteWine\" /></owl:intersectionOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#WhiteLoire\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#CheninBlancGrape\" /><owl:Thing rdf:about=\"#PinotBlancGrape\" /><owl:Thing rdf:about=\"#SauvignonBlancGrape\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#WhiteBurgundy\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Burgundy\" /><owl:Class rdf:about=\"#WhiteWine\" /></owl:intersectionOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#WhiteBurgundy\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#ChardonnayGrape\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></rdfs:subClassOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#WhiteBordeaux\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Bordeaux\" /><owl:Class rdf:about=\"#WhiteWine\" /></owl:intersectionOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#WhiteBordeaux\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#SemillonGrape\" /><owl:Thing rdf:about=\"#SauvignonBlancGrape\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Region\" />\n"
                + "  <owl:ObjectProperty rdf:about=\"#locatedIn\"><rdf:type rdf:resource=\"&owl;TransitiveProperty\" /><rdfs:domain rdf:resource=\"http://www.w3.org/2002/07/owl#Thing\" /><rdfs:range rdf:resource=\"#Region\" /></owl:ObjectProperty>\n"
                + "  <owl:ObjectProperty rdf:about=\"#adjacentRegion\"><rdf:type rdf:resource=\"&owl;SymmetricProperty\" /><rdfs:domain rdf:resource=\"#Region\" /><rdfs:range rdf:resource=\"#Region\" /></owl:ObjectProperty>"
                + "  <owl:Class rdf:about=\"#VintageYear\" />\n"
                + "  <owl:DatatypeProperty rdf:about=\"#yearValue\"><rdfs:domain rdf:resource=\"#VintageYear\" />    \n"
                + "    <rdfs:range  rdf:resource=\"&xsd;positiveInteger\" /></owl:DatatypeProperty>"
                + "  <VintageYear rdf:about=\"#Year1998\"><yearValue rdf:datatype=\"&xsd;positiveInteger\">1998</yearValue></VintageYear>\n"
                + "  <owl:ObjectProperty rdf:about=\"#hasVintageYear\"><rdf:type rdf:resource=\"&owl;FunctionalProperty\" /><rdfs:domain rdf:resource=\"#Vintage\" /><rdfs:range  rdf:resource=\"#VintageYear\" /></owl:ObjectProperty>"
                + "  <owl:ObjectProperty rdf:about=\"#madeFromGrape\"><rdfs:subPropertyOf rdf:resource=\"&food;madeFromFruit\" /><rdfs:domain rdf:resource=\"#Wine\" /><rdfs:range rdf:resource=\"#WineGrape\" /></owl:ObjectProperty>\n"
                + "  <owl:ObjectProperty rdf:about=\"#madeIntoWine\"><owl:inverseOf rdf:resource=\"#madeFromGrape\" /></owl:ObjectProperty>\n"
                + "  <owl:ObjectProperty rdf:about=\"#hasWineDescriptor\"><rdfs:domain rdf:resource=\"#Wine\" /><rdfs:range  rdf:resource=\"#WineDescriptor\" /></owl:ObjectProperty>\n"
                + "  <owl:ObjectProperty rdf:about=\"#hasSugar\"><rdf:type rdf:resource=\"&owl;FunctionalProperty\" /><rdfs:subPropertyOf rdf:resource=\"#hasWineDescriptor\" /><rdfs:range rdf:resource=\"#WineSugar\" /></owl:ObjectProperty>"
                + "  <owl:ObjectProperty rdf:about=\"#hasBody\"><rdf:type rdf:resource=\"&owl;FunctionalProperty\" /><rdfs:subPropertyOf rdf:resource=\"#hasWineDescriptor\" /><rdfs:range rdf:resource=\"#WineBody\" /></owl:ObjectProperty>"
                + "  <owl:ObjectProperty rdf:about=\"#hasFlavor\"><rdf:type rdf:resource=\"&owl;FunctionalProperty\" /><rdfs:subPropertyOf rdf:resource=\"#hasWineDescriptor\" /><rdfs:range rdf:resource=\"#WineFlavor\" /></owl:ObjectProperty>"
                + "  <owl:ObjectProperty rdf:about=\"#hasColor\"><rdf:type rdf:resource=\"&owl;FunctionalProperty\" /><rdfs:subPropertyOf rdf:resource=\"#hasWineDescriptor\" /><rdfs:domain rdf:resource=\"#Wine\" /><rdfs:range rdf:resource=\"#WineColor\" /></owl:ObjectProperty>\n"
                + "  <owl:ObjectProperty rdf:about=\"#hasMaker\"><rdf:type rdf:resource=\"&owl;FunctionalProperty\" /></owl:ObjectProperty>"
                + "  <owl:ObjectProperty rdf:about=\"#producesWine\"><owl:inverseOf rdf:resource=\"#hasMaker\" /></owl:ObjectProperty>\n"
                + "  <owl:Class rdf:about=\"#Zinfandel\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#ZinfandelGrape\" /></owl:Restriction><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Zinfandel\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Full\" /><owl:Thing rdf:about=\"#Medium\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Moderate\" /><owl:Thing rdf:about=\"#Strong\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Winery\" />"
                + "  <owl:Class rdf:about=\"#WineDescriptor\"><rdfs:comment>Made WineDescriptor unionType of tastes and color</rdfs:comment><owl:unionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#WineTaste\" /><owl:Class rdf:about=\"#WineColor\" /></owl:unionOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#WineTaste\"><rdfs:subClassOf rdf:resource=\"#WineDescriptor\" /></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#WineColor\"><rdfs:subClassOf rdf:resource=\"#WineDescriptor\" /><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#White\" /><owl:Thing rdf:about=\"#Rose\" /><owl:Thing rdf:about=\"#Red\" /></owl:oneOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#WineSugar\"><rdfs:subClassOf rdf:resource=\"#WineTaste\" /><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Sweet\" /><owl:Thing rdf:about=\"#OffDry\" /><owl:Thing rdf:about=\"#Dry\" /></owl:oneOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#WineFlavor\"><rdfs:subClassOf rdf:resource=\"#WineTaste\" /><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Delicate\" /><owl:Thing rdf:about=\"#Moderate\" /><owl:Thing rdf:about=\"#Strong\" /></owl:oneOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#WineBody\"><rdfs:subClassOf rdf:resource=\"#WineTaste\" /><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Light\" /><owl:Thing rdf:about=\"#Medium\" /><owl:Thing rdf:about=\"#Full\" /></owl:oneOf></owl:Class>"
                + "  <Region rdf:about=\"#USRegion\" />"
                + "  <owl:Class rdf:about=\"#Tours\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Loire\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#ToursRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#Tours\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#CheninBlancGrape\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></rdfs:subClassOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#TableWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#SweetWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Sweet\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#SweetRiesling\"><rdfs:subClassOf rdf:resource=\"#DessertWine\" /><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:hasValue rdf:resource=\"#Full\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Moderate\" /><owl:Thing rdf:about=\"#Strong\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Riesling\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Sweet\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#StEmilion\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:hasValue rdf:resource=\"#Strong\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#CabernetSauvignonGrape\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Bordeaux\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#StEmilionRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#SemillonOrSauvignonBlanc\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Medium\" /><owl:Thing rdf:about=\"#Full\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#SemillonGrape\" /><owl:Thing rdf:about=\"#SauvignonBlancGrape\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Semillon\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#SemillonOrSauvignonBlanc\" /><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#SemillonGrape\" /></owl:Restriction><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#SauvignonBlanc\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#SemillonOrSauvignonBlanc\" /><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#SauvignonBlancGrape\" /></owl:Restriction><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Sauterne\"><rdfs:subClassOf rdf:resource=\"#LateHarvest\" /><rdfs:subClassOf rdf:resource=\"#Bordeaux\" /><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#SauterneRegion\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:hasValue rdf:resource=\"#Medium\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></rdfs:subClassOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Sancerre\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:hasValue rdf:resource=\"#Medium\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#OffDry\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:hasValue rdf:resource=\"#Delicate\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#SauvignonBlancGrape\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Loire\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#SancerreRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#RoseWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#Rose\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Riesling\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#RieslingGrape\" /></owl:Restriction><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#RedWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#RedTableWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#TableWine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#RedBurgundy\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#PinotNoirGrape\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Burgundy\" /><owl:Class rdf:about=\"#RedWine\" /></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#RedBordeaux\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#CabernetSauvignonGrape\" /><owl:Thing rdf:about=\"#MerlotGrape\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Bordeaux\" /><owl:Class rdf:about=\"#RedWine\" /></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Port\"><rdfs:subClassOf rdf:resource=\"#RedWine\" /><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#PortugalRegion\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:hasValue rdf:resource=\"#Full\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:hasValue rdf:resource=\"#Strong\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Sweet\" /></owl:Restriction></rdfs:subClassOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#PinotNoir\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#PinotNoirGrape\" /></owl:Restriction><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#PinotBlanc\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#PinotBlancGrape\" /></owl:Restriction><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#PetiteSyrah\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Moderate\" /><owl:Thing rdf:about=\"#Strong\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Medium\" /><owl:Thing rdf:about=\"#Full\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#PetiteSyrahGrape\" /></owl:Restriction><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Pauillac\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:hasValue rdf:resource=\"#Full\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:hasValue rdf:resource=\"#Strong\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#CabernetSauvignonGrape\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Medoc\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#PauillacRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Muscadet\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:hasValue rdf:resource=\"#Light\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:hasValue rdf:resource=\"#Delicate\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#PinotBlancGrape\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Loire\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#MuscadetRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Meursault\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:hasValue rdf:resource=\"#Full\" /></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#WhiteBurgundy\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#MeursaultRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Merlot\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Moderate\" /><owl:Thing rdf:about=\"#Delicate\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Light\" /><owl:Thing rdf:about=\"#Medium\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#MerlotGrape\" /></owl:Restriction><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Meritage\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#CabernetSauvignonGrape\" /><owl:Thing rdf:about=\"#CabernetFrancGrape\" /><owl:Thing rdf:about=\"#MalbecGrape\" /><owl:Thing rdf:about=\"#PetiteVerdotGrape\" /><owl:Thing rdf:about=\"#MerlotGrape\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:minCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">2</owl:minCardinality></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <Region rdf:about=\"#MedocRegion\"><locatedIn rdf:resource=\"#BordeauxRegion\" /></Region>"
                + "  <owl:Class rdf:about=\"#Medoc\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Bordeaux\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#MedocRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Margaux\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:hasValue rdf:resource=\"#Delicate\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#MerlotGrape\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Medoc\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#MargauxRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <Region rdf:about=\"#LoireRegion\"><locatedIn rdf:resource=\"#FrenchRegion\" /></Region>"
                + "  <owl:Class rdf:about=\"#Loire\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#LoireRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#LateHarvest\"><rdfs:subClassOf rdf:resource=\"#Wine\" /><owl:disjointWith rdf:resource=\"#EarlyHarvest\" /><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Sweet\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Moderate\" /><owl:Thing rdf:about=\"#Strong\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#ItalianWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#ItalianRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <Region rdf:about=\"#ItalianRegion\" />";
        String premise3 = "  <owl:Class rdf:about=\"#IceWine\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Medium\" /><owl:Thing rdf:about=\"#Full\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Moderate\" /><owl:Thing rdf:about=\"#Strong\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#LateHarvest\" /><owl:Class rdf:about=\"#DessertWine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#GermanWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#GermanyRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Gamay\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#GamayGrape\" /></owl:Restriction><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#FullBodiedWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:hasValue rdf:resource=\"#Full\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <Region rdf:about=\"#FrenchRegion\" />"
                + "  <owl:Class rdf:about=\"#FrenchWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#FrenchRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>\n"
                + "  <owl:Class rdf:about=\"#EarlyHarvest\"><rdfs:subClassOf rdf:resource=\"#Wine\" /><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Dry\" /><owl:Thing rdf:about=\"#OffDry\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#DryWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#DryWhiteWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#DryWine\" /><owl:Class rdf:about=\"#WhiteWine\" /></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#DryRiesling\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:hasValue rdf:resource=\"#Delicate\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Light\" /><owl:Thing rdf:about=\"#Medium\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Riesling\" /><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#DryRedWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#DryWine\" /><owl:Class rdf:about=\"#RedWine\" /></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#DessertWine\"><rdfs:subClassOf rdf:resource=\"#Wine\" /><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#OffDry\" /><owl:Thing rdf:about=\"#Sweet\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#CotesDOr\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:hasValue rdf:resource=\"#Moderate\" /></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#RedBurgundy\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#CotesDOrRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Chianti\"><rdfs:subClassOf rdf:resource=\"#ItalianWine\" /><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#ChiantiRegion\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#SangioveseGrape\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:hasValue rdf:resource=\"#Moderate\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Light\" /><owl:Thing rdf:about=\"#Medium\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#CheninBlanc\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:hasValue rdf:resource=\"#Moderate\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Full\" /><owl:Thing rdf:about=\"#Medium\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Dry\" /><owl:Thing rdf:about=\"#OffDry\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#CheninBlancGrape\" /></owl:Restriction><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Chardonnay\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#White\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Full\" /><owl:Thing rdf:about=\"#Medium\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Strong\" /><owl:Thing rdf:about=\"#Moderate\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#ChardonnayGrape\" /></owl:Restriction><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <Region rdf:about=\"#CaliforniaRegion\"><locatedIn rdf:resource=\"#USRegion\" /></Region>"
                + "  <Region rdf:about=\"#TexasRegion\"><locatedIn rdf:resource=\"#USRegion\" /></Region>"
                + "  <owl:Class rdf:about=\"#CaliforniaWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#CaliforniaRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#TexasWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#TexasRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#CabernetSauvignon\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Moderate\" /><owl:Thing rdf:about=\"#Strong\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:allValuesFrom><owl:Class><owl:oneOf rdf:parseType=\"Collection\"><owl:Thing rdf:about=\"#Medium\" /><owl:Thing rdf:about=\"#Full\" /></owl:oneOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#CabernetSauvignonGrape\" /></owl:Restriction><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#CabernetFranc\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:hasValue rdf:resource=\"#Moderate\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:hasValue rdf:resource=\"#Medium\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#CabernetFrancGrape\" /></owl:Restriction><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Burgundy\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#BourgogneRegion\" /></owl:Restriction></owl:intersectionOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></rdfs:subClassOf></owl:Class>"
                + "  <Region rdf:about=\"#BourgogneRegion\"><locatedIn rdf:resource=\"#FrenchRegion\" /></Region>"
                + "  <Region rdf:about=\"#BordeauxRegion\"><locatedIn rdf:resource=\"#FrenchRegion\" /></Region>"
                + "  <owl:Class rdf:about=\"#Bordeaux\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#BordeauxRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#Beaujolais\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#Red\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:hasValue rdf:resource=\"#Light\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#Dry\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:hasValue rdf:resource=\"#Delicate\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:hasValue rdf:resource=\"#GamayGrape\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#madeFromGrape\" /><owl:maxCardinality rdf:datatype=\"&xsd;nonNegativeInteger\">1</owl:maxCardinality></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#BeaujolaisRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <Region rdf:about=\"#AustralianRegion\" />"
                + "  <owl:Class rdf:about=\"#Anjou\"><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasColor\" /><owl:hasValue rdf:resource=\"#Rose\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasBody\" /><owl:hasValue rdf:resource=\"#Light\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasFlavor\" /><owl:hasValue rdf:resource=\"#Delicate\" /></owl:Restriction></rdfs:subClassOf><rdfs:subClassOf><owl:Restriction><owl:onProperty rdf:resource=\"#hasSugar\" /><owl:hasValue rdf:resource=\"#OffDry\" /></owl:Restriction></rdfs:subClassOf><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Loire\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#AnjouRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#AmericanWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#USRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <owl:Class rdf:about=\"#AlsatianWine\"><owl:intersectionOf rdf:parseType=\"Collection\"><owl:Class rdf:about=\"#Wine\" /><owl:Restriction><owl:onProperty rdf:resource=\"#locatedIn\" /><owl:hasValue rdf:resource=\"#AlsaceRegion\" /></owl:Restriction></owl:intersectionOf></owl:Class>"
                + "  <WineBody rdf:about=\"#Full\" />\n"
                + "  <WineBody rdf:about=\"#Medium\" />\n"
                + "  <WineBody rdf:about=\"#Light\" />\n"
                + "  <WineColor rdf:about=\"#Red\" />\n"
                + "  <WineColor rdf:about=\"#Rose\" />\n"
                + "  <WineColor rdf:about=\"#White\" />\n"
                + "  <WineFlavor rdf:about=\"#Strong\" />\n"
                + "  <WineFlavor rdf:about=\"#Moderate\" />\n"
                + "  <WineFlavor rdf:about=\"#Delicate\" />\n"
                + "  <WineSugar rdf:about=\"#Dry\" />\n"
                + "  <WineSugar rdf:about=\"#OffDry\"><owl:differentFrom rdf:resource=\"#Dry\"/><owl:differentFrom rdf:resource=\"#Sweet\"/></WineSugar>"
                + "  <WineSugar rdf:about=\"#Sweet\"><owl:differentFrom rdf:resource=\"#Dry\"/></WineSugar>"
                + "  <owl:AllDifferent><owl:distinctMembers rdf:parseType=\"Collection\"><vin:WineColor rdf:about=\"#Red\" /><vin:WineColor rdf:about=\"#White\" /><vin:WineColor rdf:about=\"#Rose\" /></owl:distinctMembers></owl:AllDifferent>\n"
                + "  <owl:AllDifferent><owl:distinctMembers rdf:parseType=\"Collection\"><vin:WineBody rdf:about=\"#Light\" /><vin:WineBody rdf:about=\"#Medium\" /><vin:WineBody rdf:about=\"#Full\" /></owl:distinctMembers></owl:AllDifferent>\n"
                + "  <owl:AllDifferent><owl:distinctMembers rdf:parseType=\"Collection\"><vin:WineFlavor rdf:about=\"#Delicate\" /><vin:WineFlavor rdf:about=\"#Moderate\" /><vin:WineFlavor rdf:about=\"#Strong\" /></owl:distinctMembers></owl:AllDifferent>"
                + "  <owl:AllDifferent><owl:distinctMembers rdf:parseType=\"Collection\"><vin:WineSugar rdf:about=\"#Sweet\" /><vin:WineSugar rdf:about=\"#OffDry\" /><vin:WineSugar rdf:about=\"#Dry\" /></owl:distinctMembers></owl:AllDifferent>\n"
                + "  <Region rdf:about=\"#AlsaceRegion\">   <locatedIn rdf:resource=\"#FrenchRegion\" /></Region>\n"
                + "  <Region rdf:about=\"#AnjouRegion\"><locatedIn rdf:resource=\"#LoireRegion\" /></Region>"
                + "  <Region rdf:about=\"#ArroyoGrandeRegion\"><locatedIn rdf:resource=\"#CaliforniaRegion\" /></Region>"
                + "  <Winery rdf:about=\"#Beringer\" />\n"
                + "  <Winery rdf:about=\"#Bancroft\" />"
                + "  <Chardonnay rdf:about=\"#BancroftChardonnay\"><locatedIn rdf:resource=\"#NapaRegion\" /><hasMaker  rdf:resource=\"#Bancroft\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></Chardonnay>"
                + "  <Region rdf:about=\"#BeaujolaisRegion\"><locatedIn rdf:resource=\"#FrenchRegion\" /></Region>"
                + "  <WineGrape rdf:about=\"#CabernetFrancGrape\" />"
                + "  <WineGrape rdf:about=\"#CabernetSauvignonGrape\" />"
                + "  <Region rdf:about=\"#CentralCoastRegion\"><locatedIn rdf:resource=\"#CaliforniaRegion\" /></Region>"
                + "  <WineGrape rdf:about=\"#ChardonnayGrape\" />"
                + "  <Winery rdf:about=\"#ChateauChevalBlanc\" />"
                + "  <StEmilion rdf:about=\"#ChateauChevalBlancStEmilion\"><hasMaker  rdf:resource=\"#ChateauChevalBlanc\" /></StEmilion>"
                + "  <Winery rdf:about=\"#ChateauDYchem\" />"
                + "  <Sauterne rdf:about=\"#ChateauDYchemSauterne\"><madeFromGrape rdf:resource=\"#SauvignonBlancGrape\" /><madeFromGrape rdf:resource=\"#SemillonGrape\" /><hasFlavor rdf:resource=\"#Strong\" /><hasMaker  rdf:resource=\"#ChateauDYchem\" /></Sauterne> "
                + "  <Winery rdf:about=\"#ChateauDeMeursault\" />"
                + "  <Meursault rdf:about=\"#ChateauDeMeursaultMeursault\"><hasFlavor rdf:resource=\"#Moderate\" /><hasMaker  rdf:resource=\"#ChateauDeMeursault\" /></Meursault>"
                + "  <Winery rdf:about=\"#ChateauLafiteRothschild\" />"
                + "  <Pauillac rdf:about=\"#ChateauLafiteRothschildPauillac\"><hasMaker  rdf:resource=\"#ChateauLafiteRothschild\" /></Pauillac>"
                + "  <Margaux rdf:about=\"#ChateauMargaux\"><hasMaker  rdf:resource=\"#ChateauMargauxWinery\" /></Margaux>"
                + "  <Winery rdf:about=\"#ChateauMargauxWinery\" />"
                + "  <Winery rdf:about=\"#ChateauMorgon\" />"
                + "  <Beaujolais rdf:about=\"#ChateauMorgonBeaujolais\"><hasMaker  rdf:resource=\"#ChateauMorgon\" /></Beaujolais>"
                + "  <WineGrape rdf:about=\"#CheninBlancGrape\" />\n"
                + "  <WineGrape rdf:about=\"#ZinfandelGrape\" />\n"
                + "  <Chianti rdf:about=\"#ChiantiClassico\"><hasBody   rdf:resource=\"#Medium\" /><hasMaker  rdf:resource=\"#McGuinnesso\" /></Chianti>"
                + "  <Region rdf:about=\"#ChiantiRegion\"><locatedIn rdf:resource=\"#ItalianRegion\" /></Region>"
                + "  <Winery rdf:about=\"#ClosDeLaPoussie\" />"
                + "  <Sancerre rdf:about=\"#ClosDeLaPoussieSancerre\"><hasMaker  rdf:resource=\"#ClosDeLaPoussie\" /></Sancerre>"
                + "  <Winery rdf:about=\"#ClosDeVougeot\" />"
                + "  <CotesDOr rdf:about=\"#ClosDeVougeotCotesDOr\"><hasMaker  rdf:resource=\"#ClosDeVougeot\" /></CotesDOr>"
                + "  <Winery rdf:about=\"#CongressSprings\" />"
                + "  <Semillon rdf:about=\"#CongressSpringsSemillon\"><hasMaker  rdf:resource=\"#CongressSprings\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></Semillon>\n"
                + "  <Winery rdf:about=\"#Corbans\" />"
                + "  <Riesling rdf:about=\"#CorbansDryWhiteRiesling\"><locatedIn rdf:resource=\"#NewZealandRegion\" /><hasMaker  rdf:resource=\"#Corbans\" /><hasSugar  rdf:resource=\"#OffDry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></Riesling>"
                + "  <SauvignonBlanc rdf:about=\"#CorbansPrivateBinSauvignonBlanc\"><locatedIn rdf:resource=\"#NewZealandRegion\" /><hasMaker  rdf:resource=\"#Corbans\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Strong\" /><hasBody   rdf:resource=\"#Full\" /></SauvignonBlanc>"
                + "  <SauvignonBlanc rdf:about=\"#CorbansSauvignonBlanc\"><locatedIn rdf:resource=\"#NewZealandRegion\" /><hasMaker  rdf:resource=\"#Corbans\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Strong\" /><hasBody   rdf:resource=\"#Medium\" /></SauvignonBlanc>"
                + "  <Winery rdf:about=\"#CortonMontrachet\" />"
                + "  <WhiteBurgundy rdf:about=\"#CortonMontrachetWhiteBurgundy\"><hasMaker  rdf:resource=\"#CortonMontrachet\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Strong\" /><hasBody   rdf:resource=\"#Full\" /></WhiteBurgundy>"
                + "  <Region rdf:about=\"#CotesDOrRegion\"><locatedIn rdf:resource=\"#BourgogneRegion\" /></Region>"
                + "  <Winery rdf:about=\"#Cotturi\" />"
                + "  <Zinfandel rdf:about=\"#CotturiZinfandel\"><locatedIn rdf:resource=\"#SonomaRegion\" /><hasMaker  rdf:resource=\"#Cotturi\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Strong\" /><hasBody   rdf:resource=\"#Full\" /></Zinfandel>"
                + "  <Winery rdf:about=\"#DAnjou\" />"
                + "  <Region rdf:about=\"#EdnaValleyRegion\"><locatedIn rdf:resource=\"#CaliforniaRegion\" /></Region>"
                + "  <Winery rdf:about=\"#Elyse\" />"
                + "  <Zinfandel rdf:about=\"#ElyseZinfandel\"><locatedIn rdf:resource=\"#NapaRegion\" /><hasMaker  rdf:resource=\"#Elyse\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Full\" /></Zinfandel>"
                + "  <Winery rdf:about=\"#Forman\" />"
                + "  <CabernetSauvignon rdf:about=\"#FormanCabernetSauvignon\"><locatedIn rdf:resource=\"#NapaRegion\" /><hasMaker  rdf:resource=\"#Forman\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Strong\" /><hasBody   rdf:resource=\"#Medium\" /></CabernetSauvignon>"
                + "  <Chardonnay rdf:about=\"#FormanChardonnay\"><locatedIn rdf:resource=\"#NapaRegion\" /><hasMaker  rdf:resource=\"#Forman\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Full\" /></Chardonnay>"
                + "  <Winery rdf:about=\"#Foxen\" />"
                + "  <CheninBlanc rdf:about=\"#FoxenCheninBlanc\"><locatedIn rdf:resource=\"#SantaBarbaraRegion\" /><hasMaker  rdf:resource=\"#Foxen\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Full\" /></CheninBlanc>"
                + "  <WineGrape rdf:about=\"#GamayGrape\" />"
                + "  <Winery rdf:about=\"#GaryFarrell\" />"
                + "  <Merlot rdf:about=\"#GaryFarrellMerlot\"><locatedIn rdf:resource=\"#SonomaRegion\" /><hasMaker  rdf:resource=\"#GaryFarrell\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></Merlot>"
                + "  <Region rdf:about=\"#GermanyRegion\" />"
                + "  <Winery rdf:about=\"#Handley\" />"
                + "  <Winery rdf:about=\"#KalinCellars\" />"
                + "  <Semillon rdf:about=\"#KalinCellarsSemillon\"><hasMaker  rdf:resource=\"#KalinCellars\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Strong\" /><hasBody   rdf:resource=\"#Full\" /></Semillon>"
                + "  <Winery rdf:about=\"#KathrynKennedy\" />"
                + "  <Meritage rdf:about=\"#KathrynKennedyLateral\"><hasMaker  rdf:resource=\"#KathrynKennedy\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Delicate\" /><hasBody   rdf:resource=\"#Medium\" /></Meritage>"
                + "  <Winery rdf:about=\"#LaneTanner\" />"
                + "  <PinotNoir rdf:about=\"#LaneTannerPinotNoir\"><locatedIn rdf:resource=\"#SantaBarbaraRegion\" /><hasMaker  rdf:resource=\"#LaneTanner\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Delicate\" /><hasBody   rdf:resource=\"#Light\" /></PinotNoir>"
                + "  <Winery rdf:about=\"#Longridge\" />";
        String premise4 = "  <Merlot rdf:about=\"#LongridgeMerlot\"><locatedIn rdf:resource=\"#NewZealandRegion\" /><hasMaker  rdf:resource=\"#Longridge\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Light\" /></Merlot>"
                + "  <WineGrape rdf:about=\"#MalbecGrape\" />"
                + "  <Region rdf:about=\"#MargauxRegion\"><locatedIn rdf:resource=\"#MedocRegion\" /></Region>"
                + "  <Winery rdf:about=\"#Marietta\" />"
                + "  <CabernetSauvignon rdf:about=\"#MariettaCabernetSauvignon\"><locatedIn rdf:resource=\"#SonomaRegion\" /><hasMaker  rdf:resource=\"#Marietta\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></CabernetSauvignon>"
                + "  <RedTableWine rdf:about=\"#MariettaOldVinesRed\"><locatedIn rdf:resource=\"#SonomaRegion\" /><hasMaker  rdf:resource=\"#Marietta\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></RedTableWine>"
                + "  <PetiteSyrah rdf:about=\"#MariettaPetiteSyrah\"><locatedIn rdf:resource=\"#SonomaRegion\" /><hasMaker  rdf:resource=\"#Marietta\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></PetiteSyrah>"
                + "  <Zinfandel rdf:about=\"#MariettaZinfandel\"><locatedIn rdf:resource=\"#SonomaRegion\" /><hasMaker  rdf:resource=\"#Marietta\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></Zinfandel>"
                + "  <Winery rdf:about=\"#McGuinnesso\" />"
                + "  <Region rdf:about=\"#MendocinoRegion\"><locatedIn rdf:resource=\"#CaliforniaRegion\" /><adjacentRegion rdf:resource=\"#SonomaRegion\" /></Region>"
                + "  <WineGrape rdf:about=\"#MerlotGrape\" />"
                + "  <Region rdf:about=\"#MeursaultRegion\"><locatedIn rdf:resource=\"#BourgogneRegion\" /></Region>"
                + "  <Winery rdf:about=\"#MountEdenVineyard\" />"
                + "  <Chardonnay rdf:about=\"#MountEdenVineyardEdnaValleyChardonnay\"><locatedIn rdf:resource=\"#EdnaValleyRegion\" /><hasMaker  rdf:resource=\"#MountEdenVineyard\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></Chardonnay>"
                + "  <PinotNoir rdf:about=\"#MountEdenVineyardEstatePinotNoir\"><locatedIn rdf:resource=\"#EdnaValleyRegion\" /><hasMaker  rdf:resource=\"#MountEdenVineyard\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Strong\" /><hasBody   rdf:resource=\"#Full\" /></PinotNoir>"
                + "  <Winery rdf:about=\"#Mountadam\" />"
                + "  <Chardonnay rdf:about=\"#MountadamChardonnay\"><locatedIn rdf:resource=\"#SouthAustraliaRegion\" /><hasMaker  rdf:resource=\"#Mountadam\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Strong\" /><hasBody   rdf:resource=\"#Full\" /></Chardonnay>"
                + "  <PinotNoir rdf:about=\"#MountadamPinotNoir\"><locatedIn rdf:resource=\"#SouthAustraliaRegion\" /><hasMaker  rdf:resource=\"#Mountadam\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></PinotNoir>"
                + "  <DryRiesling rdf:about=\"#MountadamRiesling\"><locatedIn rdf:resource=\"#SouthAustraliaRegion\" /><hasMaker  rdf:resource=\"#Mountadam\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Delicate\" /><hasBody   rdf:resource=\"#Medium\" /></DryRiesling>"
                + "  <Region rdf:about=\"#MuscadetRegion\"><locatedIn rdf:resource=\"#LoireRegion\" /></Region>"
                + "  <Region rdf:about=\"#NapaRegion\"><locatedIn rdf:resource=\"#CaliforniaRegion\" /></Region>"
                + "  <Region rdf:about=\"#NewZealandRegion\" />"
                + "  <Winery rdf:about=\"#PageMillWinery\" />  \n"
                + "  <CabernetSauvignon rdf:about=\"#PageMillWineryCabernetSauvignon\"><locatedIn rdf:resource=\"#NapaRegion\" /><hasMaker  rdf:resource=\"#PageMillWinery\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></CabernetSauvignon>"
                + "  <Region rdf:about=\"#PauillacRegion\"><locatedIn rdf:resource=\"#MedocRegion\" /></Region>"
                + "  <Winery rdf:about=\"#PeterMccoy\" />"
                + "  <Chardonnay rdf:about=\"#PeterMccoyChardonnay\"><locatedIn rdf:resource=\"#SonomaRegion\" /><hasMaker  rdf:resource=\"#PeterMccoy\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></Chardonnay>"
                + "  <WineGrape rdf:about=\"#PetiteSyrahGrape\" />"
                + "  <WineGrape rdf:about=\"#PetiteVerdotGrape\" />"
                + "  <WineGrape rdf:about=\"#PinotBlancGrape\" />"
                + "  <WineGrape rdf:about=\"#PinotNoirGrape\" />"
                + "  <Region rdf:about=\"#PortugalRegion\" />"
                + "  <Winery rdf:about=\"#PulignyMontrachet\" />"
                + "  <WhiteBurgundy rdf:about=\"#PulignyMontrachetWhiteBurgundy\"><hasMaker  rdf:resource=\"#PulignyMontrachet\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></WhiteBurgundy>"
                + "  <WineGrape rdf:about=\"#RieslingGrape\" />"
                + "  <Anjou rdf:about=\"#RoseDAnjou\"><hasMaker  rdf:resource=\"#DAnjou\" /></Anjou>"
                + "  <Region rdf:about=\"#SancerreRegion\"><locatedIn rdf:resource=\"#LoireRegion\" /></Region>"
                + "  <WineGrape rdf:about=\"#SangioveseGrape\" />"
                + "  <Region rdf:about=\"#SantaBarbaraRegion\"><locatedIn rdf:resource=\"#CaliforniaRegion\" /></Region>"
                + "  <Winery rdf:about=\"#SantaCruzMountainVineyard\" />"
                + "  <CabernetSauvignon rdf:about=\"#SantaCruzMountainVineyardCabernetSauvignon\"><locatedIn rdf:resource=\"#SantaCruzMountainsRegion\" /><hasMaker  rdf:resource=\"#SantaCruzMountainVineyard\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Strong\" /><hasBody   rdf:resource=\"#Full\" /></CabernetSauvignon>"
                + "  <Region rdf:about=\"#CentralTexasRegion\"><locatedIn rdf:resource=\"#TexasRegion\" /></Region>\n"
                + "  <Winery rdf:about=\"#StGenevieve\" />\n"
                + "  <WhiteWine rdf:about=\"#StGenevieveTexasWhite\"><locatedIn rdf:resource=\"#CentralTexasRegion\" /><hasMaker  rdf:resource=\"#StGenevieve\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /></WhiteWine>\n"
                + "  <Region rdf:about=\"#SantaCruzMountainsRegion\"><locatedIn rdf:resource=\"#CaliforniaRegion\" /></Region>"
                + "  <Winery rdf:about=\"#SaucelitoCanyon\" />"
                + "  <Zinfandel rdf:about=\"#SaucelitoCanyonZinfandel\"><locatedIn rdf:resource=\"#ArroyoGrandeRegion\" /><hasMaker  rdf:resource=\"#SaucelitoCanyon\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></Zinfandel>"
                + "  <Zinfandel rdf:about=\"#SaucelitoCanyonZinfandel1998\"><locatedIn rdf:resource=\"#ArroyoGrandeRegion\" /><hasVintageYear rdf:resource=\"#Year1998\" /><hasMaker  rdf:resource=\"#SaucelitoCanyon\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></Zinfandel>\n"
                + "  <Region rdf:about=\"#SauterneRegion\"><locatedIn rdf:resource=\"#BordeauxRegion\" /></Region>"
                + "  <WineGrape rdf:about=\"#SauvignonBlancGrape\" />"
                + "  <Winery rdf:about=\"#SchlossRothermel\" />"
                + "  <SweetRiesling rdf:about=\"#SchlossRothermelTrochenbierenausleseRiesling\"><locatedIn rdf:resource=\"#GermanyRegion\" /><hasMaker  rdf:resource=\"#SchlossRothermel\" /><hasSugar  rdf:resource=\"#Sweet\" /><hasFlavor rdf:resource=\"#Strong\" /><hasBody   rdf:resource=\"#Full\" /></SweetRiesling>"
                + "  <Winery rdf:about=\"#SchlossVolrad\" />"
                + "  <SweetRiesling rdf:about=\"#SchlossVolradTrochenbierenausleseRiesling\"><locatedIn rdf:resource =\"#GermanyRegion\" /><hasMaker  rdf:resource=\"#SchlossVolrad\" /><hasSugar  rdf:resource=\"#Sweet\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Full\" /></SweetRiesling>"
                + "  <Winery rdf:about=\"#SeanThackrey\" />"
                + "  <PetiteSyrah rdf:about=\"#SeanThackreySiriusPetiteSyrah\"><locatedIn rdf:resource=\"#NapaRegion\" /><hasMaker  rdf:resource=\"#SeanThackrey\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Strong\" /><hasBody   rdf:resource=\"#Full\" /></PetiteSyrah>"
                + "  <Winery rdf:about=\"#Selaks\" />"
                + "  <IceWine rdf:about=\"#SelaksIceWine\"><locatedIn rdf:resource=\"#NewZealandRegion\" /><hasMaker  rdf:resource=\"#Selaks\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /><hasColor rdf:resource=\"#White\" /></IceWine>"
                + "  <SauvignonBlanc rdf:about=\"#SelaksSauvignonBlanc\"><locatedIn rdf:resource=\"#NewZealandRegion\" /><hasMaker  rdf:resource=\"#Selaks\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></SauvignonBlanc>"
                + "  <WineGrape rdf:about=\"#SemillonGrape\" />"
                + "  <Winery rdf:about=\"#SevreEtMaine\" />"
                + "  <Muscadet rdf:about=\"#SevreEtMaineMuscadet\"><hasMaker  rdf:resource=\"#SevreEtMaine\" /></Muscadet>"
                + "  <Region rdf:about=\"#SonomaRegion\"><locatedIn rdf:resource=\"#CaliforniaRegion\" /></Region>"
                + "  <Region rdf:about=\"#SouthAustraliaRegion\"><locatedIn rdf:resource=\"#AustralianRegion\" /></Region>"
                + "  <Region rdf:about=\"#StEmilionRegion\"><locatedIn rdf:resource=\"#BordeauxRegion\" /></Region>"
                + "  <Winery rdf:about=\"#Stonleigh\" />"
                + "  <SauvignonBlanc rdf:about=\"#StonleighSauvignonBlanc\"><locatedIn rdf:resource=\"#NewZealandRegion\" /><hasMaker  rdf:resource=\"#Stonleigh\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Delicate\" /><hasBody   rdf:resource=\"#Medium\" /></SauvignonBlanc>"
                + "  <Winery rdf:about=\"#Taylor\" />"
                + "  <Port rdf:about=\"#TaylorPort\"><hasMaker  rdf:resource=\"#Taylor\" /></Port>"
                + "  <Region rdf:about=\"#ToursRegion\"><locatedIn rdf:resource=\"#LoireRegion\" /></Region>"
                + "  <Winery rdf:about=\"#Ventana\" />"
                + "  <CheninBlanc rdf:about=\"#VentanaCheninBlanc\"><locatedIn rdf:resource=\"#CentralCoastRegion\" /><hasMaker  rdf:resource=\"#Ventana\" /><hasSugar  rdf:resource=\"#OffDry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></CheninBlanc>"
                + "  <Winery rdf:about=\"#WhitehallLane\" />"
                + "  <CabernetFranc rdf:about=\"#WhitehallLaneCabernetFranc\"><locatedIn rdf:resource=\"#NapaRegion\" /><hasMaker  rdf:resource=\"#WhitehallLane\" /><hasSugar  rdf:resource=\"#Dry\" /><hasFlavor rdf:resource=\"#Moderate\" /><hasBody   rdf:resource=\"#Medium\" /></CabernetFranc>"
                + "  <DessertWine rdf:about=\"#WhitehallLanePrimavera\"><locatedIn rdf:resource=\"#NapaRegion\" /><hasSugar  rdf:resource=\"#Sweet\" /><hasFlavor rdf:resource=\"#Delicate\" /><hasBody   rdf:resource=\"#Light\" /></DessertWine>"
                + "  <owl:AllDifferent><owl:distinctMembers rdf:parseType=\"Collection\"><vin:Winery rdf:about=\"#Bancroft\" /><vin:Winery rdf:about=\"#ChateauChevalBlanc\" /><vin:Winery rdf:about=\"#ChateauDYchem\" /><vin:Winery rdf:about=\"#ChateauDeMeursault\" /><vin:Winery rdf:about=\"#ChateauLafiteRothschild\" /><vin:Winery rdf:about=\"#ChateauMargauxWinery\" /><vin:Winery rdf:about=\"#ChateauMorgon\" /><vin:Winery rdf:about=\"#ClosDeLaPoussie\" /><vin:Winery rdf:about=\"#ClosDeVougeot\" /><vin:Winery rdf:about=\"#CongressSprings\" /><vin:Winery rdf:about=\"#Corbans\" /><vin:Winery rdf:about=\"#CortonMontrachet\" /><vin:Winery rdf:about=\"#Cotturi\" /><vin:Winery rdf:about=\"#DAnjou\" /><vin:Winery rdf:about=\"#Elyse\" /><vin:Winery rdf:about=\"#Forman\" /><vin:Winery rdf:about=\"#Foxen\" /><vin:Winery rdf:about=\"#GaryFarrell\" /><vin:Winery rdf:about=\"#KalinCellars\" /><vin:Winery rdf:about=\"#KathrynKennedy\" /><vin:Winery rdf:about=\"#LaneTanner\" /><vin:Winery rdf:about=\"#Longridge\" /><vin:Winery rdf:about=\"#Marietta\" /><vin:Winery rdf:about=\"#McGuinnesso\" /><vin:Winery rdf:about=\"#MountEdenVineyard\" /><vin:Winery rdf:about=\"#Mountadam\" /><vin:Winery rdf:about=\"#PageMillWinery\" /><vin:Winery rdf:about=\"#PeterMccoy\" /><vin:Winery rdf:about=\"#PulignyMontrachet\" /><vin:Winery rdf:about=\"#SantaCruzMountainVineyard\" /><vin:Winery rdf:about=\"#SaucelitoCanyon\" /><vin:Winery rdf:about=\"#SchlossRothermel\" /><vin:Winery rdf:about=\"#SchlossVolrad\" /><vin:Winery rdf:about=\"#SeanThackrey\" /><vin:Winery rdf:about=\"#Selaks\" /><vin:Winery rdf:about=\"#SevreEtMaine\" /><vin:Winery rdf:about=\"#StGenevieve\" /><vin:Winery rdf:about=\"#Stonleigh\" /><vin:Winery rdf:about=\"#Taylor\" /><vin:Winery rdf:about=\"#Ventana\" /><vin:Winery rdf:about=\"#WhitehallLane\" /></owl:distinctMembers></owl:AllDifferent></rdf:RDF>";
        String conclusion = "";
        String id = "WebOnt_miscellaneous_001";
        TestClasses tc = TestClasses.valueOf("CONSISTENCY");
        String d = "Wine example taken from the guide. Note that this is the same as the ontology http://www.w3.org/2002/03owlt/miscellaneous/consistent002 imported in other tests.";
        JUnitRunner r = new JUnitRunner(premise1 + premise2 + premise3 + premise4,
                conclusion, id, tc, d);
        r.setReasonerFactory(Factory.factory());
        r.run();
    }
}
