package uk.ac.manchester.cs.schneidt.decomp;

import java.util.HashSet;
import java.util.Set;

import org.semanticweb.owlapi.model.OWLLogicalAxiom;

public class Atom {
	private final OWLLogicalAxiom generatingAxiom;
	private final Set<Atom> containers = new HashSet<Atom>();
	private final Set<Atom> contained = new HashSet<Atom>();
	private final Set<OWLLogicalAxiom> content = new HashSet<OWLLogicalAxiom>();
	private final Set<OWLLogicalAxiom> module = new HashSet<OWLLogicalAxiom>();

	public Atom(OWLLogicalAxiom ax) {
		generatingAxiom = ax;
	}

	public OWLLogicalAxiom getGeneratingAxiom() {
		return this.generatingAxiom;
	}

	/** represents the >= elements */
	public Set<Atom> getContainers() {
		return this.containers;
	}

	/** represents the <= elements */
	public Set<Atom> getContained() {
		return this.contained;
	}

	public Set<OWLLogicalAxiom> getContent() {
		return this.content;
	}

	public Set<OWLLogicalAxiom> getModule() {
		return this.module;
	}
	
	public int cardinality() {
		return content.size();
	}
}
