package uk.ac.manchester.cs.schneidt.decomp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.OWLOntologyCreationIOException;
import org.semanticweb.owlapi.io.UnparsableOntologyException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.AutoIRIMapper;

import uk.ac.manchester.cs.owlapi.modularity.ModuleType;
import uk.ac.manchester.cs.owlapi.modularity.SyntacticLocalityModuleExtractor;

public class Decomposition {
	public static final String baseFolder = "/Users/macbook/Desktop/PhD-CDV";

	public static void main(String[] args) {
		Decomposition worker = new Decomposition();
		String ontologyName = "people";
		worker.run(ontologyName, "/meat/meat-ontologies/People/people.owl",
				ontologyName + ".dot", false, null);
		//		run("/meat/meat-ontologies/Koala/koala.owl", "koala.dot", false,null);
		//		run("/meat/meat-ontologies/Estrella/mereology.owl", "mereology.dot", false,null);
		//		run("/meat/meat-ontologies/University/university.owl", "university.dot", false,null);
		//		run("/meat/meat-ontologies/Tambis/miniTambis-repaired.owl",".dot", false,null);
		//		run("/meat/meat-ontologies/Tambis/Tambis-patched-repaired.owl",".dot", false,null);
		//		run("/meat/meat-ontologies/Galen/horrocks-galen.owl",".dot", false,null);
		//		run("/meat/meat-ontologies/OWL-S/Profile.owl",".dot", true, 				"/meat/meat-ontologies/OWL-S/");
		//		run("/meat/meat-ontologies/Periodic/periodic_full_06012009.owl",".dot", false,null);
	}

	private Map<OWLLogicalAxiom, Atom> atoms = new HashMap<OWLLogicalAxiom, Atom>();

	public void run(String ontologyname, String fileName, String resultName,
			boolean considerImports, String importsFolder) {
		try {
			OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
			if (considerImports) {
				AutoIRIMapper autoIRIMapper = new AutoIRIMapper(new File(
						URI.create("file://" + baseFolder + importsFolder)),
						true);
				manager.addIRIMapper(autoIRIMapper);
			}
			File file = new File(baseFolder + fileName);
			// Now load the local copy
			OWLOntology localKoala = manager
					.loadOntologyFromOntologyDocument(file);
			System.out.println("Loaded ontology: " + localKoala);
			//OWLDataFactory df = manager.getOWLDataFactory();
			//			OWLClass emptyCls = df.getOWLClass(IRI.create(localKoala
			//					.getOntologyID().getOntologyIRI().toString()
			//					+ ""));
			Set<OWLLogicalAxiom> axioms = localKoala.getLogicalAxioms();
			if (considerImports) {
				for (OWLOntology importedOnt : localKoala.getImportsClosure()) {
					axioms.addAll(importedOnt.getLogicalAxioms());
				}
			}
			int i = 1;
			System.out.println("Saving modules...");
			int cardOfMaxModule = 0;
			// attempt to create the HashMap for getting the genuine modules of the ontology
			SyntacticLocalityModuleExtractor sme1 = new SyntacticLocalityModuleExtractor(
					manager, localKoala, new HashSet<OWLAxiom>(axioms),
					ModuleType.STAR);
			buildEmptySigModule(ontologyname, manager, sme1);
			cardOfMaxModule = atomCreation(ontologyname, manager, localKoala,
					axioms, i, cardOfMaxModule);
			this.computeTransClosure();
			System.out.println("The largest module contains " + cardOfMaxModule
					+ " axioms");
			//MultiMap<OWLLogicalAxiom, OWLLogicalAxiom> atomAsSet = new MultiMap<OWLLogicalAxiom, OWLLogicalAxiom>();
			int counter = 0;
			int cardinality = 0;
			Map<OWLLogicalAxiom, Integer> axiomIDHashMap = new HashMap<OWLLogicalAxiom, Integer>();
			for (OWLLogicalAxiom axiom : atoms.keySet()) {
				counter++;
				axiomIDHashMap.put(axiom, counter);
				cardinality = cardinality + atoms.get(axiom).cardinality();
				String string2 = "file:///" + baseFolder
						+ "/ontologies-my_experiments/" + ontologyname
						+ "/atoms/atom" + counter + ".owl";
				IRI atomIRI = IRI.create(string2);
				OWLOntology atom2 = manager.createOntology(atomIRI);
				manager.addAxioms(atom2, atoms.get(axiom).getContent());
				manager.saveOntology(atom2);
			}
			int cardOfMaxAtom = 0;
			System.out.println("There are " + atoms.keySet().size() + " atoms");
			cardOfMaxAtom = maxCardinality();
			System.out.println("The maximal size of an atom is "
					+ cardOfMaxAtom);
			//			Map<OWLLogicalAxiom, Set<OWLLogicalAxiom>> transClosureOfAtDec = transClosure(
			//					genuineModules, generatingAxioms);
			Set<OWLLogicalAxiom> unrelatedAtoms = print(resultName,
					axiomIDHashMap);
			System.out.println("There are " + unrelatedAtoms.size()
					+ " atoms that don't depend on others");
		} catch (OWLOntologyCreationIOException e) {
			e.printStackTrace();
		} catch (UnparsableOntologyException e) {
			e.printStackTrace();
		} catch (UnloadableImportException e) {
			e.printStackTrace();
		} catch (OWLOntologyCreationException e) {
			e.printStackTrace();
		} catch (OWLOntologyStorageException e) {
			e.printStackTrace();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
	}

	public int atomCreation(String ontologyname, OWLOntologyManager manager,
			OWLOntology localKoala, Set<OWLLogicalAxiom> axioms, int i,
			int cardOfMaxModule) throws OWLOntologyCreationException,
			OWLOntologyStorageException {
		SyntacticLocalityModuleExtractor sme = new SyntacticLocalityModuleExtractor(
				manager, localKoala, new HashSet<OWLAxiom>(axioms),
				ModuleType.STAR);
		Map<Set<OWLEntity>, OWLLogicalAxiom> signatureMap = new HashMap<Set<OWLEntity>, OWLLogicalAxiom>();
		for (OWLLogicalAxiom ax : axioms) {
			signatureMap.put(ax.getSignature(), ax);
		}
		Map<OWLLogicalAxiom, Set<OWLLogicalAxiom>> genuineModules = new HashMap<OWLLogicalAxiom, Set<OWLLogicalAxiom>>();
		for (Set<OWLEntity> sig : signatureMap.keySet()) {
			String string = "file:///" + baseFolder
					+ "/ontologies-my_experiments/" + ontologyname
					+ "/modules/module" + i + ".owl";
			IRI moduleIRI = IRI.create(string);
			OWLOntology mod = sme.extractAsOntology(sig, moduleIRI);
			genuineModules.put(signatureMap.get(sig), mod.getLogicalAxioms());
			int size = mod.getLogicalAxioms().size();
			if (size >= cardOfMaxModule) {
				cardOfMaxModule = size;
			}
			// And we save the module.
			// System.out.println("Saving the module as " + mod.getOntologyID().getOntologyIRI() + " .");
			manager.saveOntology(mod);
			i++;
		}
		// contains unique modules -> mapped to generator axiom
		MultiMap<Set<OWLLogicalAxiom>, OWLLogicalAxiom> reverseMap = new MultiMap<Set<OWLLogicalAxiom>, OWLLogicalAxiom>();
		for (Map.Entry<OWLLogicalAxiom, Set<OWLLogicalAxiom>> e : genuineModules
				.entrySet()) {
			reverseMap.put(e.getValue(), e.getKey());
		}
		pickGeneratingAxioms(reverseMap);
		return cardOfMaxModule;
	}

	public int maxCardinality() {
		int max = 0;
		for (Atom a : atoms.values()) {
			if (max < a.cardinality()) {
				max = a.cardinality();
			}
		}
		return max;
	}

	public Set<OWLLogicalAxiom> print(String resultName,
			Map<OWLLogicalAxiom, Integer> axiomIDHashMap)
			throws FileNotFoundException {
		MultiMap<OWLLogicalAxiom, OWLLogicalAxiom> directChildren = computeAxiomsToRemove();
		PrintStream out = new PrintStream(resultName);
		out.println("digraph People {\n");
		for (OWLLogicalAxiom axiom : atoms.keySet()) {
			int L = atoms.get(axiom).cardinality();
			double result = (Math.log(L + 1));
			String string = String.format("%.3f", result);
			out.println("node [shape=circle,fixedsize=false,width = " + string
					+ "]; " + axiomIDHashMap.get(axiom) + "; ");
		}
		out.println("\n");
		for (OWLLogicalAxiom axiom : atoms.keySet()) {
			for (OWLLogicalAxiom axiom2 : directChildren.get(axiom)) {
				out.println(axiomIDHashMap.get(axiom) + "->"
						+ axiomIDHashMap.get(axiom2) + ";");
			}
		}
		Set<OWLLogicalAxiom> unrelatedAtoms = new HashSet<OWLLogicalAxiom>();
		for (OWLLogicalAxiom axiom : atoms.keySet()) {
			int number = directChildren.get(axiom).size();
			if (number == 0) {
				unrelatedAtoms.add(axiom);
			}
		}
		out.println("\noverlap=false\nfontsize=2;\n}\n");
		out.close();
		return unrelatedAtoms;
	}

	private void pickGeneratingAxioms(
			MultiMap<Set<OWLLogicalAxiom>, OWLLogicalAxiom> reverseMap) {
		for (Set<OWLLogicalAxiom> key : reverseMap.keySet()) {
			Set<OWLLogicalAxiom> content = reverseMap.get(key);
			OWLLogicalAxiom generator = content.iterator().next();
			Atom atom = new Atom(generator);
			atom.getContent().addAll(content);
			atoms.put(generator, atom);
		}
	}

	public void buildEmptySigModule(String ontologyname,
			OWLOntologyManager manager, SyntacticLocalityModuleExtractor sme1)
			throws OWLOntologyCreationException, OWLOntologyStorageException {
		String string0 = "file:///" + baseFolder
				+ "/ontologies-my_experiments/" + ontologyname
				+ "/modules/module0.owl";
		IRI module0IRI = IRI.create(string0);
		Set<OWLEntity> sig0 = Collections.emptySet();
		OWLOntology mod0 = sme1.extractAsOntology(sig0, module0IRI);
		manager.saveOntology(mod0);
	}

	

	public void computeTransClosure() {
		for (Atom atom1 : atoms.values()) {
			for (Atom atom2 : atoms.values()) {
				if (atom1.getModule().contains(atom2.getGeneratingAxiom())) {
					atom1.getContained().add(atom2);
					atom2.getContainers().add(atom1);
				}
			}
		}
	}

	public MultiMap<OWLLogicalAxiom, OWLLogicalAxiom> computeAxiomsToRemove() {
		MultiMap<OWLLogicalAxiom, OWLLogicalAxiom> directChildren = new MultiMap<OWLLogicalAxiom, OWLLogicalAxiom>();
		for (Atom a : atoms.values()) {
			Set<Atom> contained = a.getContained();
			for (Atom child : contained) {
				Set<Atom> intersection = new HashSet<Atom>(contained);
				intersection.retainAll(child.getContainers());
				if (intersection.size() == 1 && intersection.contains(a)) {
					// child is a direct child
					directChildren.put(a.getGeneratingAxiom(),
							child.getGeneratingAxiom());
				}
			}
		}
		return directChildren;
	}
}
