package uk.ac.manchester.cs.schneidt.decomp;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.AutoIRIMapper;

import uk.ac.manchester.cs.owlapi.modularity.ModuleType;
import uk.ac.manchester.cs.owlapi.modularity.SyntacticLocalityModuleExtractor;

/**
 * Created by IntelliJ IDEA.
 * User: macbook
 * Date: 18/02/2011
 * Time: 18:06
 * To change this template use File | Settings | File Templates.
 */
public class Decomposition2 {

    public static final String baseFolder = "/Users/macbook/Desktop/PhD-CDV";

	public static void main(String[] args) {
		Decomposition worker = new Decomposition();
		String ontologyName = "people";
		worker.run(ontologyName, "/meat/meat-ontologies/People/people.owl",
				ontologyName + ".dot", false, null);
		//		run("/meat/meat-ontologies/Koala/koala.owl", "koala.dot", false,null);
		//		run("/meat/meat-ontologies/Estrella/mereology.owl", "mereology.dot", false,null);
		//		run("/meat/meat-ontologies/University/university.owl", "university.dot", false,null);
		//		run("/meat/meat-ontologies/Tambis/miniTambis-repaired.owl",".dot", false,null);
		//		run("/meat/meat-ontologies/Tambis/Tambis-patched-repaired.owl",".dot", false,null);
		//		run("/meat/meat-ontologies/Galen/horrocks-galen.owl",".dot", false,null);
		//		run("/meat/meat-ontologies/OWL-S/Profile.owl",".dot", true, 				"/meat/meat-ontologies/OWL-S/");
		//		run("/meat/meat-ontologies/Periodic/periodic_full_06012009.owl",".dot", false,null);
	}
    public void run(String ontologyname, String fileName, String resultName, boolean considerImports, String importsFolder) throws OWLOntologyCreationException, OWLOntologyStorageException {

        // create the manager for the ontology
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        // consider Imports
		if (considerImports) {
			AutoIRIMapper autoIRIMapper = new AutoIRIMapper(new File(
				URI.create("file://" + baseFolder + importsFolder)),true);
				manager.addIRIMapper(autoIRIMapper);
			}
        // create the file for loading the ontology
		File file = new File(baseFolder + fileName);
		// Now load the local copy
		OWLOntology localKoala = manager.loadOntologyFromOntologyDocument(file);
		System.out.println("Loaded ontology: " + localKoala);
		//OWLDataFactory df = manager.getOWLDataFactory();
		//			OWLClass emptyCls = df.getOWLClass(IRI.create(localKoala
		//					.getOntologyID().getOntologyIRI().toString()
		//					+ ""));

        // axioms is the set of all logical axioms
		Set<OWLLogicalAxiom> axioms = localKoala.getLogicalAxioms();
		if (considerImports) {
			for (OWLOntology importedOnt : localKoala.getImportsClosure()) {
				axioms.addAll(importedOnt.getLogicalAxioms());
			}
		}

        // we want to remove the syntactyc tautologies in the end, so we create a set with all axioms. Those that won't be touched in any extraction, are the tautologies
        Set<OWLLogicalAxiom> synctTautologies = new HashSet<OWLLogicalAxiom>();
            for (OWLLogicalAxiom ax : axioms){
                synctTautologies.add(ax);
            }

        // we define the extractor
        SyntacticLocalityModuleExtractor sme = new SyntacticLocalityModuleExtractor(manager, localKoala, /*axiomsForSLME,*/ ModuleType.STAR);


        // we compute also the set of global axioms
		String string0 = "file:///" + baseFolder
				+ "/ontologies-my_experiments/" + ontologyname
				+ "/modules/module0.owl";
		IRI module0IRI = IRI.create(string0);
		Set<OWLEntity> sig0 = Collections.emptySet();
		OWLOntology mod0 = sme.extractAsOntology(sig0, module0IRI);
		manager.saveOntology(mod0);

        // initializing
        Map<OWLLogicalAxiom, OWLOntology> genuineModules = new HashMap<OWLLogicalAxiom, OWLOntology>();
        int i = 1;
        int cardOfMaxModule = 0;
        // delete global axioms from the set of axioms
        axioms.removeAll(mod0.getLogicalAxioms());
        System.out.println("There are " +mod0.getAxiomCount()+ " global axioms");
        System.out.println("Saving modules...");

        // compute the genuine modules
        for (OWLLogicalAxiom axiom : axioms){
            Set<OWLEntity> sig = axiom.getSignature();
            //System.out.println(sig + " ");
            //for (OWLEntity ent : sig){
            //    System.out.println("  " + ent);
            //}
            String str = "" + i;
            String string = resultName +"/modules/module" + str + ".owl";
            IRI moduleIRI = IRI.create(string);
            OWLOntology mod = sme.extractAsOntology(sig, moduleIRI);
            genuineModules.put(axiom, mod);
            mod.getLogicalAxioms().removeAll(mod0.getLogicalAxioms());
            if (mod.getLogicalAxioms().size() >= cardOfMaxModule){
                cardOfMaxModule = mod.getLogicalAxioms().size();
            }
            // And we save the module.
            // System.out.println("Saving the module as " + mod.getOntologyID().getOntologyIRI() + " .");
            manager.saveOntology(mod);
            synctTautologies.removeAll(mod.getLogicalAxioms());
            i++;
        }
        System.out.println("The largest module contains " + cardOfMaxModule + " axioms");

        // we remove also the syntactic tautologies from the set of axioms
        axioms.removeAll(synctTautologies);
        System.out.println("There are " +synctTautologies.size()+ " syntactic tautologies");

        // define the map of atoms
        Map<OWLLogicalAxiom, Set<OWLLogicalAxiom>> atomOfAxiom = new HashMap<OWLLogicalAxiom, Set<OWLLogicalAxiom>>();
        for (OWLLogicalAxiom axiom : axioms){
            Set<OWLLogicalAxiom> temp = new HashSet<OWLLogicalAxiom>();
            temp.add(axiom);
            atomOfAxiom.put(axiom, temp);
        }

        // initializing
        Set<OWLLogicalAxiom> generatingAxioms = new HashSet<OWLLogicalAxiom>();
        //Map<OWLLogicalAxiom, Set<OWLLogicalAxiom>> atomOfAxiom = new HashMap<OWLLogicalAxiom, Set<OWLLogicalAxiom>>();

        for (OWLLogicalAxiom axiom : axioms){
                        boolean newAxiom = true;

                        OWLOntology modOfAxiom = genuineModules.get(axiom);
                        Set<OWLLogicalAxiom> setOfAxiom = modOfAxiom.getLogicalAxioms();
                        for (OWLLogicalAxiom beta: generatingAxioms){
                            OWLOntology modOfBeta = genuineModules.get(beta);
                            Set<OWLLogicalAxiom> setOfBeta = modOfBeta.getLogicalAxioms();

                            if (setOfAxiom.equals(setOfBeta)){
                                // System.out.println(setOfAxiom);
                                // System.out.println(setOfBeta);
                                Set<OWLLogicalAxiom> betaAxs = atomOfAxiom.get(beta);
                                betaAxs.add(axiom);
                                atomOfAxiom.put(beta, betaAxs);
                                //System.out.println(betaAxs.size());
                                //System.out.println();

                                newAxiom = false;
                            }
                        }
                        if (newAxiom){
                            //Set<OWLLogicalAxiom> atom;
                            //atom = atomOfAxiom.get(axiom);
                            //System.out.print(atomOfAxiom.get(axiom).toString());
                            generatingAxioms.add(axiom);
                            //atom.add(axiom);
                        }
                    }

                    // Set<OWLLogicalAxiom> setOfGeneratingAxioms = generatingAxioms;
                    int counter = 0;
                    int cardinality = 0;
                    Map<OWLLogicalAxiom, Integer> axiomIDHashMap = new HashMap<OWLLogicalAxiom, Integer>();
                    Map<OWLLogicalAxiom, OWLOntology> atomasOWLOntology = new HashMap<OWLLogicalAxiom, OWLOntology>();
                    Map<OWLLogicalAxiom, Set<OWLLogicalAxiom>> atomAsSet = new HashMap<OWLLogicalAxiom, Set<OWLLogicalAxiom>>();
                    for (OWLLogicalAxiom axiom: generatingAxioms){
                        counter++;
                        axiomIDHashMap.put(axiom, counter);
                        // System.out.println("Axiom " + counter + " is " + axiom);
                        // System.out.println("The generating axiom for this atom is " + counter + axiom );
                        Set<OWLLogicalAxiom> atom = atomOfAxiom.get(axiom);
                        atomAsSet.put(axiom, atom);
                        //System.out.println("The size of its atom is " + atom.size());
                        cardinality = cardinality + atom.size();
                        String str = "" + counter;
                        String string2 = "file:////Users/macbook/Desktop/PhD-CDV/ontologies-my_experiments/family/atoms/atom" + str + ".owl";
                        OWLOntologyManager man = OWLManager.createOWLOntologyManager();
                        IRI atomIRI = IRI.create(string2);
                        OWLOntology atom2;
                        atom2 = man.createOntology(atomIRI);
                        atomasOWLOntology.put(axiom, atom2);
                        for (OWLLogicalAxiom axiom3 : atom){
                            AddAxiom addAxiom = new AddAxiom(atom2, axiom3);
                            man.applyChange(addAxiom);
                            //System.out.println();
                        }
                        //(Set<OWLLogicalAxiom> atom, atomIRI);
                        // OWLOntology atom2 = AddAxiom(OWLOntology atom2, OWLAxiom axiom);
                        man.saveOntology(atom2);
                        //for (OWLLogicalAxiom beta: atom){
                        //    System.out.println(beta);
                        //}
                        //System.out.println(counter);
                    }

                    int cardOfMaxAtom = 0;
                    System.out.println("There are " + generatingAxioms.size() + " atoms");
                    for (OWLLogicalAxiom axiom : generatingAxioms){
                        //System.out.println("The axiom number " + axiomIDHashMap.get(axiom) + " is " + axiom);
                        if (atomOfAxiom.get(axiom).size() >= cardOfMaxAtom){
                            cardOfMaxAtom = atomOfAxiom.get(axiom).size();
                        }
                    }
                    System.out.println("The maximal size of an atom is " + cardOfMaxAtom);

                    Map<OWLLogicalAxiom, Set<OWLLogicalAxiom>> transClosureOfAtDec = new HashMap<OWLLogicalAxiom, Set<OWLLogicalAxiom>>();
                    for (OWLLogicalAxiom axiom: generatingAxioms){
                        OWLOntology moduleHere = genuineModules.get(axiom);
                        Set<OWLLogicalAxiom> genuineModuleAsSet = moduleHere.getLogicalAxioms();
                        Set<OWLLogicalAxiom> setToBeIncluded = new HashSet<OWLLogicalAxiom>();
                        for (OWLLogicalAxiom axiom2: generatingAxioms){
                            //OWLOntology module2Here = genuineModules.get(axiom2);
                            //Set<OWLLogicalAxiom> genuineModule2AsSet = module2Here.getLogicalAxioms();
                            if (genuineModuleAsSet.contains(axiom2)){
                                //System.out.println(genuineModuleAsSet.contains(axiom2));
                                setToBeIncluded.add(axiom2);
                            }
                        }
                        transClosureOfAtDec.put(axiom, setToBeIncluded);
                    }

                    Map<OWLLogicalAxiom, Set<OWLLogicalAxiom>> axiomsToBeRemoved = new HashMap<OWLLogicalAxiom, Set<OWLLogicalAxiom>>();
                    for (OWLLogicalAxiom axiom: generatingAxioms){
                        Set<OWLLogicalAxiom> setToBeRemembered = new HashSet<OWLLogicalAxiom>();
                        Set<OWLLogicalAxiom> dependencies = transClosureOfAtDec.get(axiom);
                        dependencies.remove(axiom);
                        Set<OWLLogicalAxiom> setToBeAdded = new HashSet<OWLLogicalAxiom>();
                        setToBeAdded.add(axiom);
                        axiomsToBeRemoved.put(axiom, setToBeAdded);
                        for (OWLLogicalAxiom axiom2: dependencies){
                            Set<OWLLogicalAxiom> dependencies2 = transClosureOfAtDec.get(axiom2);
                            dependencies2.remove(axiom2);
                            for (OWLLogicalAxiom axiom3 : dependencies2){
                                setToBeRemembered.add(axiom3);
                            }
                        axiomsToBeRemoved.put(axiom, setToBeRemembered);

                        }
                    }


                    Map<OWLLogicalAxiom, Set<OWLLogicalAxiom>> reducedAtDec = new HashMap<OWLLogicalAxiom, Set<OWLLogicalAxiom>>();
                    for (OWLLogicalAxiom axiom : generatingAxioms){
                        Set<OWLLogicalAxiom> setAgain = axiomsToBeRemoved.get(axiom);
                        reducedAtDec.put(axiom, new HashSet<OWLLogicalAxiom>());
                        reducedAtDec.put(axiom, transClosureOfAtDec.get(axiom));
                        for (OWLLogicalAxiom axiom2 : setAgain){
                            reducedAtDec.get(axiom).remove(axiom2);
                        }
                    }


                    Map<OWLLogicalAxiom, Integer> cardOfAtoms = new HashMap<OWLLogicalAxiom, Integer>();
                    for (OWLLogicalAxiom axiom : generatingAxioms){
                        int cardOfAtom;
                        cardOfAtoms.put(axiom, atomOfAxiom.get(axiom).size());
                        cardOfAtom = cardOfAtoms.get(axiom);
                        //System.out.println("Cardinality of atom " + axiomIDHashMap.get(axiom) + " is " + cardOfAtom);
                        //System.out.println("and its axioms are:");
                        //for (OWLLogicalAxiom axiom2 : transClosureOfAtDec.get(axiom)){
                        //     System.out.println(axiomIDHashMap.get(axiom2) + " " + axiom2 );
                        //}
                    }

                    System.out.println();
                    System.out.println( "digraph Family {");
                    System.out.println();

                    for (OWLLogicalAxiom axiom : generatingAxioms){
                        int L = cardOfAtoms.get(axiom);
                        double result = (Math.log(L+1));
                        String string =  String.format("%.3f", result);
                        System.out.println("node [shape=circle,fixedsize=false,width = " + string +"]; "+ axiomIDHashMap.get(axiom) + "; ");
                    }
/*
            System.out.println();
            public Set<OWLLogicalAxiom> print(String resultName,
                    Map<OWLLogicalAxiom, Integer> axiomIDHashMap)
                    throws FileNotFoundException {
                MultiMap<OWLLogicalAxiom, OWLLogicalAxiom> directChildren = computeAxiomsToRemove();
                PrintStream out = new PrintStream(resultName);
                out.println("digraph People {\n");
                for (OWLLogicalAxiom axiom : atoms.keySet()) {
                    int L = atoms.get(axiom).cardinality();
                    double result = (Math.log(L + 1));
                    String string = String.format("%.3f", result);
                    out.println("node [shape=circle,fixedsize=false,width = " + string
                            + "]; " + axiomIDHashMap.get(axiom) + "; ");
                }
                out.println("\n");
                for (OWLLogicalAxiom axiom : atoms.keySet()) {
                    for (OWLLogicalAxiom axiom2 : directChildren.get(axiom)) {
                        out.println(axiomIDHashMap.get(axiom) + "->"
                                + axiomIDHashMap.get(axiom2) + ";");
                    }
                }
                Set<OWLLogicalAxiom> unrelatedAtoms = new HashSet<OWLLogicalAxiom>();
                for (OWLLogicalAxiom axiom : atoms.keySet()) {
                    int number = directChildren.get(axiom).size();
                    if (number == 0) {
                        unrelatedAtoms.add(axiom);
                    }
                }
                out.println("\noverlap=false\nfontsize=2;\n}\n");
                out.close();
                return unrelatedAtoms;
            }

*/

                    System.out.println();

                    for (OWLLogicalAxiom axiom : generatingAxioms){
                        for (OWLLogicalAxiom axiom2 : reducedAtDec.get(axiom)){
                            System.out.println(axiomIDHashMap.get(axiom)+"->"+axiomIDHashMap.get(axiom2)+";");
                        }
                    }

                    Set<OWLLogicalAxiom> unrelatedAtoms = new HashSet<OWLLogicalAxiom>();
                    for (OWLLogicalAxiom axiom : generatingAxioms){
                        int number = reducedAtDec.get(axiom).size();
                        if (number == 0){
                           unrelatedAtoms.add(axiom);
                        }

                    }

                    System.out.println();
                    System.out.println("overlap=false");
                    System.out.println("fontsize=2;");
                    System.out.println("}");
                    System.out.println();


                    System.out.println("There are " + unrelatedAtoms.size() + " atoms that don't depend on others");
                    //for (OWLLogicalAxiom axiom: unrelatedAtoms){
                        //System.out.println(axiomIDHashMap.get(axiom) + "  ");

                    //}
                    System.out.println();



                    /*System.out.print("decomp-graph = { ");
                    for (OWLLogicalAxiom axiom : generatingAxioms){
                        Set<OWLLogicalAxiom> transClos = transClosureOfAtDec.get(axiom);
                        transClos.remove(axiom);
                        System.out.print(" " + axiomIDHashMap.get(axiom) +": [");
                        int app = 1;
                        for (OWLLogicalAxiom axiom2: transClos){
                            System.out.print("" + axiomIDHashMap.get(axiom2) + " ");
                            if (transClos.size()==app){
                                System.out.print("");
                            }
                            else{
                              //
                              System.out.print(", ");

                            }
                            app++;
                        }
                        System.out.println("],");

                    }



           /*         HashMap<Integer, Set<Integer>> transClosureOfAtDecIDs = new HashMap<Integer, Set<Integer>>();
                    for (OWLLogicalAxiom axiom : generatingAxioms){
                        transClosureOfAtDecIDs.put(axiomIDHashMap.get(axiom), new HashSet<Integer>());
                    }
                    for (OWLLogicalAxiom axiom : generatingAxioms){
                        for (OWLLogicalAxiom axiom2 : transClosureOfAtDec.get(axiom)){
                            transClosureOfAtDecIDs.get(axiomIDHashMap.get(axiom)).add(axiomIDHashMap.get(axiom2));
                        }
                    }
                    System.out.println();


                    HashMap<Integer, Integer> maxMatching = new HashMap<Integer, Integer>();
                    for (int uomo=0; uomo <= generatingAxioms.size()+1; uomo++){
                        maxMatching.put(uomo, 0);
                    }

                    String str = "0:0, ";
                    String[] lines = str.split(", ");
                    String[] p = new String[2];
                    for (String l : lines){
                        p = l.split(": ");
                        maxMatching.put(Integer.valueOf(p[0]), Integer.valueOf(p[1]));
                    }

                    HashMap<Integer,Integer> inverseMatching = new HashMap<Integer,Integer>();

                    // chains and antichains

                    for (int kappa = 1; kappa <= generatingAxioms.size(); kappa++){
                        inverseMatching.put(kappa, 0);
                    }

                    for (int kappa = 1; kappa <= generatingAxioms.size(); kappa++){
                        System.out.println(kappa + " " + maxMatching.get(kappa));
                        if (maxMatching.get(kappa) != 0){
                            inverseMatching.put(maxMatching.get(kappa), kappa);
                        }
                    }

                    System.out.println();


                    for (int kappa = 1; kappa <= generatingAxioms.size(); kappa++){
                    System.out.println(kappa + " " + inverseMatching.get(kappa));
                    }

                    System.out.println();


                    Set<Integer> unrelatedAtomID = new HashSet<Integer>();
                    for (OWLLogicalAxiom axiom : unrelatedAtoms){
                        unrelatedAtomID.add(axiomIDHashMap.get(axiom));
                        System.out.println(axiomIDHashMap.get(axiom));
                    }

                    System.out.println();
                    int size = generatingAxioms.size();

                    HashMap<Integer, Set<Integer>> chain = new HashMap<Integer, Set<Integer>>();

                    int cardOfAntiChain = 0;
                    Set<Integer> setOfID = new HashSet<Integer>();
                        for (int app = 1; app <= size; app++) {
                        setOfID.add(app);
                    }


                    for (int app : setOfID){
                        Set<Integer> chainApp = new HashSet<Integer>();
                        System.out.print(app + " ");
                        chainApp.add(app);
                        int app2 = maxMatching.get(app);
                        while (app2 != 0){
                            chainApp.add(app2);
                            System.out.print(app2 + " ");
                            app2 = maxMatching.get(app2);
                        }
                        app2 = inverseMatching.get(app);
                            while ((app2 != 0)){
                                chainApp.add(app2);
                                System.out.print(app2 + " ");
                                app2 = inverseMatching.get(app2);
                            }
                        System.out.print(" ");

                        for (int app3 : setOfID){

                        }
                        chain.put(app, new HashSet<Integer>());
                        chain.put(app, chainApp);
                    }

                    Set<Integer> maxAntichain = new HashSet<Integer>();
                    Set<Integer> setOfID2 = new HashSet<Integer>();

                    for (int app : setOfID){
                        Set<Integer> chainApp = chain.get(app);
                        boolean neu = true;
                        for (int app2 : setOfID2){
                            if (chainApp.equals(chain.get(app2))){
                                neu = false;
                            }
                            //setOfID2.add(app);
                        }
                        setOfID2.add(app);
                        if (neu){
                            cardOfAntiChain++;
                            maxAntichain.add(app);
                        }

                    }

                    System.out.println();
                    System.out.println(cardOfAntiChain);
                    long upperBound = 1;
                    for (int app : maxAntichain){
                        upperBound = upperBound * (chain.get(app).size()+1);
                        if (upperBound != 0){System.out.println(upperBound);}
                    }
                    System.out.println("An upper bound for the number of modules is " + upperBound);

                    for (int kappa = 1; kappa <= generatingAxioms.size(); kappa++){
                        if (maxMatching.get(kappa) != 0){
                            inverseMatching.put(maxMatching.get(kappa), kappa);
                        }
                    }

                    HashMap<OWLLogicalAxiom, Set<OWLLogicalAxiom>> invTransClosureOfAtDec = new HashMap<OWLLogicalAxiom, Set<OWLLogicalAxiom>>();
                    for (OWLLogicalAxiom axiom : generatingAxioms){
                         Set<OWLLogicalAxiom> app = invTransClosureOfAtDec.get(axiom);
                        if (app == null){
                            app = new HashSet<OWLLogicalAxiom>();
                        }
                        invTransClosureOfAtDec.put(axiom, app);
                    }

                    for (OWLLogicalAxiom axiom : generatingAxioms){
                        Set<OWLLogicalAxiom> closeapp = transClosureOfAtDec.get(axiom);
                        for (OWLLogicalAxiom axiom2 : closeapp){
                             invTransClosureOfAtDec.get(axiom2).add(axiom);
                        }
                    }

                    long lowerBound = 1;
                    for (OWLLogicalAxiom axiom : generatingAxioms){
                         if (transClosureOfAtDec.get(axiom).isEmpty()){
                            lowerBound = lowerBound * 2;
                         }
                    }
                    System.out.println("The ontology contains at least " + lowerBound + " modules");



                    /*Set<Integer> setSet = setOfID;
                    int cardin = size;
                    for (int app : setSet){
                        while (cardin!=0){
                            if (inverseMatching.get(app) == 0){
                                int app2 = app;
                                while (maxMatching.get(app2)!=0){
                                    setOfID.remove(app2);
                                    app2=inverseMatching.get(app2);
                                    chain.get(app).add(app2);
                                }

                            }
                            else{
                                cardOfAntiChain++;
                            }
                        }
                    }
                        /*Queue<Integer> qq = new LinkedList<Integer>(setOfID);
                        int atom = qq.peek();
                        // System.out.println("the atom is " + atom);
                        int app = inverseMatching.get(atom);

                        for (;app != 0;){
                            setOfID.remove(atom);
                            System.out.println("Here the atom is " + atom);
                            chain.get(atom).add(inverseMatching.get(app));
                            atom = app;
                            app = inverseMatching.get(atom);
                        }
                        System.out.println("the atom is " + atom);
                        setOfID.remove(atom);
                    }

                    for (int app = 1; app <= size; app++) {
                        setOfID.add(app);
                    }

                    for (int app : setOfID){
                        int card1 = setOfID.size();
                        Set<Integer> setSet = chain.get(app);
                        int card2 = setSet.size();
                        System.out.println(card1 + " " + card2);
                        if (card1-card2 != 0){// (!setOfID.equals(setOfID.remove(chain.get(app)))){
                            setOfID.remove(setSet);
                            cardOfAntiChain++;
                        }
                    }

                    System.out.println("The cardinality of antichains is " + cardOfAntiChain);



                    /*index = 0;
                    for (int Ur=0; Ur < generatingAxioms.size(); Ur++){
                        int Uc = 0;
                        int Dr = prefMatrixUomo[Ur][Uc];

                        for (;Dr != 0;){
                            //System.out.println(var);
                            int app = prefMatrixDonna[Dr][0];
                            if (app == 0){
                                prefMatrixDonna[Dr][0] = Ur+1;
                                System.out.print(Ur+1 + " " + Dr + " ");
                                prefMatrixDonna[Dr][1] = 0;
                            }
                            //int kappa = 0;
                            int Dc = 0;
                            int lunghDonnaDr = 1;
                            int basta = prefMatrixDonna[Dr][0];
                            for (; basta != 0;){
                                lunghDonnaDr ++;
                                basta = prefMatrixDonna[Dr][lunghDonnaDr];
                            }
                            System.out.println(lunghDonnaDr + " e basta");
                            int app2 = prefMatrixDonna[Dr][Dc];
                            for (int vai=0; vai<=basta; vai++){
                                int app3 = prefMatrixDonna[Dr][Dc+1];
                                prefMatrixDonna[Dr][Dc+1] = app2;
                                app2 = app3;
                                //System.out.print(app2 + " ");
                                Dc++;
                            }
                            //System.out.print(Dr + " ");
                            prefMatrixDonna[Dr][Dc]=0;
                            //prefMatrixDonna[k][0] = app;
                            Uc++;
                            Dr = prefMatrixUomo[Ur][Uc];

                        }
                    }
                    System.out.println(); */

                    /*for (int app1 = 1; app1 <= generatingAxioms.size(); app1++){
                        int app2 = prefMatrixDonna[app1][0];
                        System.out.print(app1 + " ");
                        int kappa = 0;
                        for (;app2 != 0;){
                            System.out.print(prefMatrixDonna[app1][kappa] + " ");
                            kappa = kappa + 1;
                            app2 = prefMatrixDonna[app1][kappa];
                        }
                        System.out.println();
                    }*/


                   /* int uomo = 0;
                    while (k <= generatingAxioms.size()){
                        uomo = arrayOfGenAxs[k];
                        while (uomo != 0){
                            int donna = prefMatrixUomo[uomo][0];
                            stableMarriage.put(uomo, donna);
                            //if (prefMatrixUomo[][]);
                        }
                    }

                    /*int m = 0;
                    Set<OWLLogicalAxiom> appoggio = generatingAxioms;
                    while (appoggio != Collections.EMPTY_SET){
                        m = prefMatrixUomo[k][];

                    } */



/*            int size = 0;
            for (OWLLogicalAxiom axiom: generatingAxioms){
                System.out.print(axiomIDHashMap.get(axiom) + " -> ");
                for (int var1 = 0; var1 <= transClosureOfAtDec.get(axiom).size(); var1++){
                    System.out.print(prefMatrixUomo[size][var1]);//[var1];
                }
                size++;
                System.out.println();
            }*/


                    //System.out.println(prefMatrixUomo.get());



                    //int k = 0;
                    //HashMap<String, Set<String>> stableMarriage = new HashMap<String, Set<String>>();





              /*      HashMap<OWLLogicalAxiom, Set<OWLLogicalAxiom>> axiomsToBeRemoved = new HashMap<OWLLogicalAxiom, Set<OWLLogicalAxiom>>();
                    HashMap<OWLLogicalAxiom, Set<OWLLogicalAxiom>> reducedAtDec = new HashMap<OWLLogicalAxiom, Set<OWLLogicalAxiom>>();
                    for (OWLLogicalAxiom axiom: generatingAxioms){
                        Set<OWLLogicalAxiom> dependencies = transClosureOfAtDec.get(axiom);
                        dependencies.remove(axiom);
                        reducedAtDec.put(axiom, dependencies);
                        //System.out.println("transitive closure of " + axiom + " is " + dependencies);
                        Set<OWLLogicalAxiom> setToBeRemoved = new HashSet<OWLLogicalAxiom>();
                        for (OWLLogicalAxiom axiom2: dependencies){
                            Set<OWLLogicalAxiom> dependencies2 = transClosureOfAtDec.get(axiom2);
                            dependencies2.remove(axiom2);
                            for (OWLLogicalAxiom axiom3 : dependencies2){
                                dependencies.remove(axiom3);
                            }
                            //setToBeRemoved.add((OWLLogicalAxiom) dependencies2);
                        }
                        //dependencies.remove(setToBeRemoved);
                        axiomsToBeRemoved.put(axiom, dependencies);
                        //System.out.println("The atom generated by " + axiom + "is dependent on atoms generated by " + dependencies);
                    }

                    for (OWLLogicalAxiom axiom : generatingAxioms){
                        for (OWLLogicalAxiom axiom2 : axiomsToBeRemoved.get(axiom)){
                            reducedAtDec.remove(axiom2);
                        }
                    }



        /*
                        /*AxiomID mydata = new AxiomID();

                        mydata.setID(i);
                        axiomIDHashMap.put(axiom, mydata);
                        System.out.println("axiom ID = " + mydata.getID());*/

                        /*HashMap<OWLLogicalAxiom, ModuleCards> cardinalityOfModule = new HashMap<OWLLogicalAxiom, ModuleCards>();
                        ModuleCards mydata2 = new ModuleCards();
                        mydata2.setCard(card);
                        cardinalityOfModule.put(axiom, mydata2);
                        System.out.println("cardinality of this module = " + mydata2.getCard());
                        System.out.println();

                        //create variable Atom
                        HashMap<OWLLogicalAxiom, AlphaAtom> atomOfAlpha = new HashMap<OWLLogicalAxiom, AlphaAtom>();
                        AlphaAtom myAtom = new AlphaAtom();
                        //myAtom.getAtom();

                        // in theory, this axiom is new
                        boolean newAxiom = true;

                        // create variable generatingAxioms
                        Set<OWLLogicalAxiom> generatingAxioms;
                        generatingAxioms = new HashSet<OWLLogicalAxiom>();

                        for (OWLLogicalAxiom beta : generatingAxioms){

                            // compares the module generated by alpha with the modules generated by the generating axioms beta we already discovered
                            // for each such beta, we extract again the module modbeta to compare it with mod
                            Set<OWLEntity> sigbeta = beta.getSignature();
                            AxiomID mydatabeta = new AxiomID();
                            String strbeta = "" + axiomIDHashMap.put(beta, mydatabeta);
                            String stringbeta = "file:////Users/macbook/Desktop/PhD-CDV/ontologies-my_experiments/koala/modules/module" + strbeta + ".owl";
                            IRI moduleIRIbeta = IRI.create(stringbeta);
                            OWLOntology modbeta =  sme.extractAsOntology(sigbeta, moduleIRIbeta);
                            if (mod.equals(modbeta)){

                                // if mod equals some modbeta, then mod is old!
                                newAxiom = false;

                                // since mod is old, its generating axiom is actually contained in the atom of beta
                                atomOfAlpha.put(beta, myAtom);
                                myAtom.add(axiom);
                            }
                        }
                        if  (newAxiom = true){
                            // if the axiom generates a new module, we compute its cardinality
                            int card = 0;
                            for (OWLAxiom alpha: mod.getLogicalAxioms()){
                                card ++;
                                System.out.println("  " + alpha);
                            }
                            HashMap<OWLLogicalAxiom, ModuleCards> cardinalityOfModule = new HashMap<OWLLogicalAxiom, ModuleCards>();
                            ModuleCards mydata2 = new ModuleCards();
                            mydata2.setCard(card);
                            cardinalityOfModule.put(axiom, mydata2);
                            System.out.println("cardinality of this module = " + mydata2.getCard());
                            System.out.println();

                            // create the atom for the new axiom
                            atomOfAlpha.put(axiom, myAtom);
                            myAtom.add(axiom);

                            // in case the module is new, is being saved here
                            manager.saveOntology(mod);

                        }
                        i++;

                        for (OWLLogicalAxiom alpha : generatingAxioms){

                            //for each generatin axiom we want to print the relative atom
                            //Set<OWLLogicalAxiom> myAtom;
                            //myAtom = HashMap<alpha, AlphaAtom>;
                            System.out.println("The generating axiom is " + alpha);

                            //for (OWLLogicalAxiom beta : myAtom){
                            //    System.out.println();
                            //}
                        }

                    }



             /*       // Output for debugging purposes
                    System.out.println();
                    System.out.println("Extracting the module for the seed signature consisting of the following entities:");
                    for (OWLEntity ent : sig) {
                        System.out.println("  " + ent);
                    }
                    System.out.println();
                    System.out.println("Some statistics of the original ontology:");
                    System.out.println("  " + localKoala.getSignature(true).size() + " entities");
                    System.out.println("  " + localKoala.getLogicalAxiomCount() + " logical axioms");
                    System.out.println("  " + (localKoala.getAxiomCount() - localKoala.getLogicalAxiomCount()) + " other axioms");
                    System.out.println();

                    // We now extract a locality-based module.
                    // For most reuse purposes, the module type should be STAR -- this yields the smallest possible locality-based module.
                    // These modules guarantee that all entailments of the original ontology that can be formulated using only
                    // terms from the seed signature or the module will also be entailments of the module.
                    // In easier words, the module preserves all knowledge of the ontology about the terms in the seed signature or the module.
                    SyntacticLocalityModuleExtractor sme = new SyntacticLocalityModuleExtractor(manager, localKoala, ModuleType.STAR);
                    IRI moduleIRI = IRI.create("file:/tmp/KoalaGlobalAxiomsModule.owl");
                    OWLOntology mod = sme.extractAsOntology(sig, moduleIRI);

                    // Output for debugging purposes
                    System.out.println("Some statistics of the module:");
                    System.out.println("  " + mod.getSignature(true).size() + " entities");
                    System.out.println("  " + mod.getLogicalAxiomCount() + " logical axioms");
                    System.out.println("  " + (mod.getAxiomCount() - mod.getLogicalAxiomCount()) + " other axioms");
                    System.out.println();

                    // And we save the module.
                    System.out.println("Saving the module as " + mod.getOntologyID().getOntologyIRI() + " .");
                    manager.saveOntology(mod);
             */

/*           int[][] prefMatrixUomo;
            prefMatrixUomo = new int[generatingAxioms.size()+1][];
            prefMatrixUomo[0]= new int[1];
            prefMatrixUomo[0][0]= 0;
            //int index1 = 0;
            int index = 1;
            for (OWLLogicalAxiom axiom : generatingAxioms){
                //for (OWLLogicalAxiom axiom2 : transClosureOfAtDec.get(axiom))
                prefMatrixUomo[index] = new int[transClosureOfAtDec.get(axiom).size()+2];
                Set<OWLLogicalAxiom> set2 = transClosureOfAtDec.get(axiom);
                set2.remove(axiom);
                System.out.print(axiomIDHashMap.get(axiom) + " ");
                int index2 = 0;
                for (OWLLogicalAxiom axiom2 : set2){
                    if (index2 == transClosureOfAtDec.get(axiom).size()){
                        prefMatrixUomo[index][index2] = 0;
                    }
                    else{
                        int app = axiomIDHashMap.get(axiom2);
                        prefMatrixUomo[index][index2] = app;
                        System.out.print(app + " ");
                        index2++;
                    }
                }
                System.out.println(prefMatrixUomo[index][index2]);
                index++;
            }
            System.out.println();
            System.out.println();    */

/*            HashMap<Integer, Set<Integer>> setPrefDonna = new HashMap<Integer, Set<Integer>>();
            for (int var = 1; var<=generatingAxioms.size();var++){
                setPrefDonna.put(var, new HashSet<Integer>());
            }
            for (int uomo = 1; uomo <= generatingAxioms.size(); uomo++){
                int donna = prefMatrixUomo[uomo][0];
                int var = 0;
                for (;donna != 0;){
                    setPrefDonna.get(donna).add(uomo);
                    donna = prefMatrixUomo[uomo][var+1];
                    var++;
                }
            }

            // initialize the first column of prefMatrixDonna
            int[][] prefMatrixDonna = new int[generatingAxioms.size()+1][generatingAxioms.size()+1];
            for (int donna = 1; donna <= generatingAxioms.size(); donna++){
                prefMatrixDonna[donna][0] = 0;
            }
            for (int donna= 1; donna <= generatingAxioms.size(); donna++){
                int kappa = 0;
                System.out.print(donna + " ");
                for (int j : setPrefDonna.get(donna)){
                    prefMatrixDonna[donna][kappa] = j;
                    System.out.print(j + " ");
                    kappa++;
                }
                prefMatrixDonna[donna][kappa] = 0;
                 System.out.println(0);
            }
            System.out.println();
            System.out.println();


            // Stable matching
            HashMap<Integer, Integer> stableMarriageUomo = new HashMap<Integer, Integer>();
            for (int uomo=0; uomo <= generatingAxioms.size()+1; uomo++){
                stableMarriageUomo.put(uomo, 0);
            }
            HashMap<Integer, Integer> stableMarriageDonna = new HashMap<Integer, Integer>(); // poni mu(w) = omega per ogni donna
            for (int donna=0; donna <= generatingAxioms.size()+1; donna++){
                stableMarriageDonna.put(donna, 0);
            }
            int k = 0; // poni k = 0
            //int indexDonna = 0;
            while (k < generatingAxioms.size()){// fintanto che k < |uomini|
                int donna = (k+1);     //poni m = (k+1) esimo elemento di M
                while (donna != 0){  //fintanto che m != omega
                    System.out.print("donna = " + donna + " ");
                    int uomo = prefMatrixDonna[donna][0];     // w = scelta migliore nella lista di preferenza di m
                    System.out.print("uomo = " + uomo + " ");
                    boolean flag = false;
                    int j = 0;
                    int fidanzata = stableMarriageUomo.get(uomo);
                    System.out.println("fidanzata = " + fidanzata + " ");
                    while (prefMatrixUomo[uomo][j] != fidanzata){ // scorre la lista di preferenza della donna finché non trova il fidanzato
                        System.out.println("migliore scelta dell'uomo = " + prefMatrixUomo[uomo][j]);
                        if (prefMatrixUomo[uomo][j] == donna){     // se ci trova l'uomo se lo segna
                            flag = true;
                        }
                        if (flag == false){
                           //stableMarriageUomo.put(uomo, donna);

                         }
                        j++;
                    }

                    if (flag == true){                                 // se ci ha trovato uomo molla il fidanzato per mettersi con lui
                        //System.out.println(donna + " si fidanza con " + uomo + " e lascia " + fidanzato);
                        System.out.println("memorizzo che " + uomo +" si fidanza con " + donna + " e lascia " + fidanzata);
                        stableMarriageUomo.put(uomo, donna);
                        stableMarriageDonna.put(donna, uomo);
                        stableMarriageDonna.put(fidanzata, 0);
                        donna = fidanzata;                               // e il fidanzato torna single
                        System.out.println("quindi ora la single è = " + donna);
                    }

                    // if (fidanzato == 0) uomo = fidanzato;
                    //else {donna = prefMatrixUomo[uomo][indexDonna+1];
                    //System.out.println(donna + " è la donna successiva di " + uomo);}
                    // System.out.print("uomo = " + uomo + " ");
                    //indexDonna++;

                    if (donna != 0){
                        int app = 0;
                        System.out.println("cancello " + uomo + " dalla lista di " + donna);
                        for (;prefMatrixDonna[donna][app] != uomo; app++){
                            System.out.println(" vediamo se entra nel ciclo: app = " + app + " ");
                        }
                        System.out.println(uomo + " è in posizione " + app + " nell'attuale lista di preferenza di " + donna);
                        int uomo2 = prefMatrixDonna[donna][app];
                        int kappa = app;
                        for (;uomo2 != 0;){
                            uomo2 = prefMatrixDonna[donna][kappa+1];
                            System.out.println(uomo2 + " ");
                            prefMatrixDonna[donna][kappa]= uomo2;
                            kappa++;
                        }
                        System.out.print("questa è la lista di preferenza di " + donna + ": ");
                        int uomoapp = 0;
                        for(;prefMatrixDonna[donna][uomoapp] != 0; uomoapp++){
                           System.out.print(prefMatrixDonna[donna][uomoapp] + " ");
                        }
                        System.out.println(prefMatrixDonna[donna][uomoapp] + " ");

                    }
                    if (uomo == 0) donna = 0;
                }
                k = k+1;
                System.out.println();

            }

            System.out.println("Stable marriage");
            for (int kappa = 0; kappa <= generatingAxioms.size(); kappa++){
                System.out.println(kappa + " " + stableMarriageUomo.get(kappa));
            }

            System.out.println();

            System.out.println("Its inverse");
            for (int kappa = 0; kappa <= generatingAxioms.size(); kappa++){
                 System.out.println(kappa + " " + stableMarriageDonna.get(kappa));
             }                                                                                */
                               // maximal matching... but it doesn't work!

                    // here I compute the set of vertexes V that are exposed in the matching
         /*           Set<Integer> exposedV = new HashSet<Integer>();
                    for (int appV = 0; appV <=generatingAxioms.size(); appV++){
                        if (stableMarriageUomo.get(appV)==0){
                            exposedV.add(appV);
                        }
                    }

                    // here I compute the set of vertexes U that are exposed in the matching
                    Set<Integer> exposedU = new HashSet<Integer>();
                    for (int appU = 0; appU <=generatingAxioms.size(); appU++){
                        if (stableMarriageDonna.get(appU)==0){
                            exposedU.add(appU);
                        }
                    } */

            //        int[] pred = new int[generatingAxioms.size()+1];
            //       HashMap<Integer,Integer> maxMatching = MMB2.MMB2(transClosureOfAtDecIDs, exposedV, exposedU, stableMarriageUomo, stableMarriageDonna, generatingAxioms.size());
            //        HashMap<Integer,Integer> inverseMatching = new HashMap<Integer,Integer>();

    }
}
