package uk.ac.manchester.cs.schneidt.decomp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Created by IntelliJ IDEA.
 * User: macbook
 * Date: 22/02/2011
 * Time: 16:32
 */
public class MaximalAntichain {
    static String inputPathName;

    private static String evaluateParameters(String[] args) {
        String inputPathName = "";
        try {
            inputPathName = args[0];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Please provide two arguments: ");
            System.out.println("  * The name of the path for the input and output files");
        }
        return inputPathName;
    }

    public static void main(String[] args) throws IOException {
        String inputPathName = evaluateParameters(args);

        FileReader file = null;
        try {
            file = new FileReader(inputPathName + "/decomp.bipart.txt");

        BufferedReader in = new BufferedReader(file);
        String matching = in.readLine();
        System.out.println(matching);
        in.close();

        file = new FileReader(inputPathName + "/atomSize.txt");
        BufferedReader in2 = new BufferedReader(file);
        int numberOfAtoms = Integer.valueOf(in2.readLine());
        System.out.println(numberOfAtoms);
        in2.close();

        file = new FileReader(inputPathName + "/ontologySize.txt");
        BufferedReader in3 = new BufferedReader(file);
        int numberOfAxioms = Integer.valueOf(in3.readLine());
        System.out.println(numberOfAxioms);
        in3.close();

        Map<Integer, Integer> map = new HashMap<Integer, Integer>(numberOfAtoms);
        for (int i =1; i <=numberOfAtoms; i++){
            map.put(i,0);
        }

        matching = matching.substring(1,matching.length()-1);
        String[] arrayOfStrings = matching.split(", ");
        String[] p = new String[2];
        for (String l : arrayOfStrings){
            p = l.split(": ");
            map.put(Integer.valueOf(p[0]), Integer.valueOf(p[1]));
        }
        System.out.print(map.toString());
        System.out.println();


        int maxAntichainSize = 0;
        Set<Integer> set = new HashSet<Integer>();
        for (int i=1; i<=numberOfAtoms; i++){
            set.add(i);
        }
        for (int i=1; i<=numberOfAtoms;i++){
            int app = i;
            while (map.get(app) != 0){
                app = map.get(app);
            }
            if (set.contains(app)){
                maxAntichainSize++;
                set.remove(app);
            }
        }
        System.out.print(numberOfAxioms + ", " + maxAntichainSize);

        File fileResults = new File(inputPathName + "/filerisultati.txt");
        BufferedWriter out = new BufferedWriter(new FileWriter(fileResults, true));
        out.write(numberOfAxioms + "\t" + maxAntichainSize);
        out.newLine();
        out.flush();
        out.close();

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

}
