package uk.ac.manchester.cs.schneidt.decomp;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

 class MultiMap<K, V> {
	private Map<K, Set<V>> map = new HashMap<K, Set<V>>();

	public void put(K key, V value) {
		if (!map.containsKey(key)) {
			map.put(key, new HashSet<V>());
		}
		map.get(key).add(value);
	}
	public void putBulk(K key, Collection<V> value) {
		if (!map.containsKey(key)) {
			map.put(key, new HashSet<V>());
		}
		map.get(key).addAll(value);
	}


	public Set<V> get(K key) {
		if (!map.containsKey(key)) {
			return Collections.emptySet();
		}
		return map.get(key);
	}

	public int getCardinality(K key) {
		if (map.containsKey(key)) {
			return map.get(key).size();
		}
		return 0;
	}

	public int getMaxCardinality() {
		int max = 0;
		for (Set<V> set : map.values()) {
			if (max < set.size()) {
				max = set.size();
			}
		}
		return max;
	}

	public Set<K> keySet() {
		return map.keySet();
	}
}
