package de.lmu.ifi.dbs.elki.math.statistics.distribution;

/*
 This file is part of ELKI:
 Environment for Developing KDD-Applications Supported by Index-Structures

 Copyright (C) 2012
 Ludwig-Maximilians-Universität München
 Lehr- und Forschungseinheit für Datenbanksysteme
 ELKI Development Team

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU Affero General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import static org.junit.Assert.assertEquals;

import java.util.Random;

import org.junit.Test;

import de.lmu.ifi.dbs.elki.JUnit4Test;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;

/**
 * Unit test for the Gamma distribution in ELKI.
 * 
 * The reference values were computed using GNU R and SciPy.
 * 
 * @author Erich Schubert
 */
public class TestGammaDistribution extends AbstractDistributionTest implements JUnit4Test {
  public static final double[] P_CDFPDF = { //
  0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 1e-05, 1e-10, 0.1234567, 3.14159265359, 2.71828182846, 0.314159265359, 0.271828182846 //
  };

  public static final double[] SCIPY_GAMMA_CDF_1_1 = { //
  9.51625819640404407850908796717703808099031448364258e-02, // 0.100000
  1.81269246922018151257915974383649881929159164428711e-01, // 0.200000
  2.59181779318282068391710026844521053135395050048828e-01, // 0.300000
  3.29679953964360561435853469447465613484382629394531e-01, // 0.400000
  3.93469340287366520225731392201851122081279754638672e-01, // 0.500000
  4.51188363905973610634703163668746128678321838378906e-01, // 0.600000
  5.03414696208590473069932613725541159510612487792969e-01, // 0.700000
  5.50671035882778325820652298716595396399497985839844e-01, // 0.800000
  5.93430340259400890268182138242991641163825988769531e-01, // 0.900000
  6.32120558828557776998025019565830007195472717285156e-01, // 1.000000
  6.67128916301920504849931603530421853065490722656250e-01, // 1.100000
  6.98805788087797807861534238327294588088989257812500e-01, // 1.200000
  7.27468206965987351786395720409927889704704284667969e-01, // 1.300000
  7.53403036058393538176858328370144590735435485839844e-01, // 1.400000
  7.76869839851570209710018843907164409756660461425781e-01, // 1.500000
  7.98103482005344533334323386952746659517288208007812e-01, // 1.600000
  8.17316475947265308477085454796906560659408569335938e-01, // 1.700000
  8.34701111778413440411839019361650571227073669433594e-01, // 1.800000
  8.50431380777364909206994525447953492403030395507812e-01, // 1.900000
  8.64664716763387297682186272140825167298316955566406e-01, // 2.000000
  9.99995000016666799329441428501041855270159430801868e-06, // 0.000010
  9.99999999950001362800370980511287678088594432779246e-11, // 0.000000
  1.16140088450309555967443486679258057847619056701660e-01, // 0.123457
  9.56786081736227700389463279861956834793090820312500e-01, // 3.141593
  9.34011964154687457373427150741918012499809265136719e-01, // 2.718282
  2.69597308951354475148320943844737485051155090332031e-01, // 0.314159
  2.38014828033141445651210688083665445446968078613281e-01, // 0.271828
  };

  public static final double[] SCIPY_GAMMA_PDF_1_1 = { //
  9.04837418035959517581545696884859353303909301757812e-01, // 0.100000
  8.18730753077981820986508409987436607480049133300781e-01, // 0.200000
  7.40818220681717876097138741897651925683021545410156e-01, // 0.300000
  6.70320046035639327541844068036880344152450561523438e-01, // 0.400000
  6.06530659712633424263117376540321856737136840820312e-01, // 0.500000
  5.48811636094026389365296836331253871321678161621094e-01, // 0.600000
  4.96585303791409526930067386274458840489387512207031e-01, // 0.700000
  4.49328964117221563157045238767750561237335205078125e-01, // 0.800000
  4.06569659740599109731817861757008358836174011230469e-01, // 0.900000
  3.67879441171442334024277442949824035167694091796875e-01, // 1.000000
  3.32871083698079550661219627727405168116092681884766e-01, // 1.100000
  3.01194211912202136627314530414878390729427337646484e-01, // 1.200000
  2.72531793034012592702453048332245089113712310791016e-01, // 1.300000
  2.46596963941606489578717287258768919855356216430664e-01, // 1.400000
  2.23130160148429818045556771721749100834131240844727e-01, // 1.500000
  2.01896517994655383398949766160512808710336685180664e-01, // 1.600000
  1.82683524052734663767338929574179928749799728393555e-01, // 1.700000
  1.65298888221586531832585365009435918182134628295898e-01, // 1.800000
  1.49568619222635063037429858923132997006177902221680e-01, // 1.900000
  1.35335283236612702317813727859174832701683044433594e-01, // 2.000000
  9.99990000049999827602675850357627496123313903808594e-01, // 0.000010
  9.99999999899999991725962900090962648391723632812500e-01, // 0.000000
  8.83859911549690457910344321135198697447776794433594e-01, // 0.123457
  4.32139182637722579771732966946728993207216262817383e-02, // 3.141593
  6.59880358453125426265728492580819875001907348632812e-02, // 2.718282
  7.30402691048645635873981518670916557312011718750000e-01, // 0.314159
  7.61985171966858665371091774431988596916198730468750e-01, // 0.271828
  };

  public static final double[] GNUR_GAMMA_CDF_1_1 = { //
  9.51625819640404269073030718573136255145072937011719e-02, // 0.100000
  1.81269246922018151257915974383649881929159164428711e-01, // 0.200000
  2.59181779318282123902861258102348074316978454589844e-01, // 0.300000
  3.29679953964360727969307163220946677029132843017578e-01, // 0.400000
  3.93469340287366575736882623459678143262863159179688e-01, // 0.500000
  4.51188363905973610634703163668746128678321838378906e-01, // 0.600000
  5.03414696208590473069932613725541159510612487792969e-01, // 0.700000
  5.50671035882778325820652298716595396399497985839844e-01, // 0.800000
  5.93430340259400890268182138242991641163825988769531e-01, // 0.900000
  6.32120558828557665975722557050175964832305908203125e-01, // 1.000000
  6.67128916301920504849931603530421853065490722656250e-01, // 1.100000
  6.98805788087797807861534238327294588088989257812500e-01, // 1.200000
  7.27468206965987462808698182925581932067871093750000e-01, // 1.300000
  7.53403036058393538176858328370144590735435485839844e-01, // 1.400000
  7.76869839851570209710018843907164409756660461425781e-01, // 1.500000
  7.98103482005344644356625849468400701880455017089844e-01, // 1.600000
  8.17316475947265308477085454796906560659408569335938e-01, // 1.700000
  8.34701111778413440411839019361650571227073669433594e-01, // 1.800000
  8.50431380777364909206994525447953492403030395507812e-01, // 1.900000
  8.64664716763387297682186272140825167298316955566406e-01, // 2.000000
  9.99995000016666799329441428501041855270159430801868e-06, // 0.000010
  9.99999999950000070330663866405545691512513073462287e-11, // 0.000000
  1.16140088450309583723019102308171568438410758972168e-01, // 0.123457
  9.56786081736236693195962743629934266209602355957031e-01, // 3.141593
  9.34011964154750407018923397117760032415390014648438e-01, // 2.718282
  2.69597308951369518670304614715860225260257720947266e-01, // 0.314159
  2.38014828033214137503748020208149682730436325073242e-01, // 0.271828
  };

  public static final double[] GNUR_GAMMA_PDF_1_1 = { //
  9.04837418035959517581545696884859353303909301757812e-01, // 0.100000
  8.18730753077981820986508409987436607480049133300781e-01, // 0.200000
  7.40818220681717876097138741897651925683021545410156e-01, // 0.300000
  6.70320046035639327541844068036880344152450561523438e-01, // 0.400000
  6.06530659712633424263117376540321856737136840820312e-01, // 0.500000
  5.48811636094026389365296836331253871321678161621094e-01, // 0.600000
  4.96585303791409526930067386274458840489387512207031e-01, // 0.700000
  4.49328964117221563157045238767750561237335205078125e-01, // 0.800000
  4.06569659740599109731817861757008358836174011230469e-01, // 0.900000
  3.67879441171442334024277442949824035167694091796875e-01, // 1.000000
  3.32871083698079550661219627727405168116092681884766e-01, // 1.100000
  3.01194211912202136627314530414878390729427337646484e-01, // 1.200000
  2.72531793034012592702453048332245089113712310791016e-01, // 1.300000
  2.46596963941606489578717287258768919855356216430664e-01, // 1.400000
  2.23130160148429818045556771721749100834131240844727e-01, // 1.500000
  2.01896517994655383398949766160512808710336685180664e-01, // 1.600000
  1.82683524052734663767338929574179928749799728393555e-01, // 1.700000
  1.65298888221586531832585365009435918182134628295898e-01, // 1.800000
  1.49568619222635063037429858923132997006177902221680e-01, // 1.900000
  1.35335283236612702317813727859174832701683044433594e-01, // 2.000000
  9.99990000049999827602675850357627496123313903808594e-01, // 0.000010
  9.99999999899999991725962900090962648391723632812500e-01, // 0.000000
  8.83859911549690457910344321135198697447776794433594e-01, // 0.123457
  4.32139182637633137429311602772941114380955696105957e-02, // 3.141593
  6.59880358452495374699253716244129464030265808105469e-02, // 2.718282
  7.30402691048630536840846616541966795921325683593750e-01, // 0.314159
  7.61985171966785834740676364162936806678771972656250e-01, // 0.271828
  };

  public static final double[] SCIPY_GAMMA_CDF_2_1 = { //
  4.67884016044447376136972138738201465457677841186523e-03, // 0.100000
  1.75230963064217717950477037902601296082139015197754e-02, // 0.200000
  3.69363131137667791148437856918462784960865974426270e-02, // 0.300000
  6.15519355501049983403483167876402148976922035217285e-02, // 0.400000
  9.02040104310498636053239351895172148942947387695312e-02, // 0.500000
  1.21901382249557641013204545288317603990435600280762e-01, // 0.600000
  1.55804983554603787565540073956071864813566207885742e-01, // 0.700000
  1.91207864589001103050591723331308458000421524047852e-01, // 0.800000
  2.27517646492861713714006555164814926683902740478516e-01, // 0.900000
  2.64241117657115276440293882842524908483028411865234e-01, // 1.000000
  3.00970724234032926958093412395101040601730346679688e-01, // 1.100000
  3.37372733793155299419908033087267540395259857177734e-01, // 1.200000
  3.73176876021771020131012619458488188683986663818359e-01, // 1.300000
  4.08167286540144502726690234339912422001361846923828e-01, // 1.400000
  4.42174599628925357741593415994429960846900939941406e-01, // 1.500000
  4.75069053213895919896003761095926165580749511718750e-01, // 1.600000
  5.06754485057616443910433190467301756143569946289062e-01, // 1.700000
  5.37163112979557655357609746715752407908439636230469e-01, // 1.800000
  5.66251004254358369927047078817849978804588317871094e-01, // 1.900000
  5.93994150290161671001953891391167417168617248535156e-01, // 2.000000
  4.99996666679166626271834837367592264956162040334675e-11, // 0.000010
  4.99999999966665360199746137423608777641557195129907e-21, // 0.000000
  7.02166050809290703815790379849204327911138534545898e-03, // 0.123457
  8.21025553585930989441976635134778916835784912109375e-01, // 3.141593
  7.54637885420670229130735151557018980383872985839844e-01, // 2.718282
  4.01345361152903382095935569395805941894650459289551e-02, // 0.314159
  3.08857833818661116354054030352926929481327533721924e-02, // 0.271828
  };

  public static final double[] SCIPY_GAMMA_PDF_2_1 = { //
  9.04837418035959739626150621916167438030242919921875e-02, // 0.100000
  1.63746150615596386401762174500618129968643188476562e-01, // 0.200000
  2.22245466204515323971335760688816662877798080444336e-01, // 0.300000
  2.68128018414255708812277134711621329188346862792969e-01, // 0.400000
  3.03265329856316712131558688270160928368568420410156e-01, // 0.500000
  3.29286981656415900232559579308144748210906982421875e-01, // 0.600000
  3.47609712653986657748816924140555784106254577636719e-01, // 0.700000
  3.59463171293777250525636191014200448989868164062500e-01, // 0.800000
  3.65912693766539232065326814336003735661506652832031e-01, // 0.900000
  3.67879441171442334024277442949824035167694091796875e-01, // 1.000000
  3.66158192067887522380686959877493791282176971435547e-01, // 1.100000
  3.61433054294642563952777436497854068875312805175781e-01, // 1.200000
  3.54291330944216387166534332209266722202301025390625e-01, // 1.300000
  3.45235749518249090961319325288059189915657043457031e-01, // 1.400000
  3.34695240222644740946122965397080406546592712402344e-01, // 1.500000
  3.23034428791448668949470857114647515118122100830078e-01, // 1.600000
  3.10561990889648920077803495587431825697422027587891e-01, // 1.700000
  2.97537998798855785054229272645898163318634033203125e-01, // 1.800000
  2.84180376523006650302249909145757555961608886718750e-01, // 1.900000
  2.70670566473225404635627455718349665403366088867188e-01, // 2.000000
  9.99990000050000075939183458162418105530377943068743e-06, // 0.000010
  9.99999999900001396698837531419091790435560440641893e-11, // 0.000000
  1.09118427942216628112603871159080881625413894653320e-01, // 0.123457
  1.35760528150296710947486644727177917957305908203125e-01, // 3.141593
  1.79374078734017200487116383555985521525144577026367e-01, // 2.718282
  2.29462772836064060610894443925644736737012863159180e-01, // 0.314159
  2.07129044651275240340737582300789654254913330078125e-01, // 0.271828
  };

  public static final double[] GNUR_GAMMA_CDF_2_1 = { //
  4.67884016044447115928450742217137303669005632400513e-03, // 0.100000
  1.75230963064217613867068479294175631366670131683350e-02, // 0.200000
  3.69363131137667860537376895990746561437845230102539e-02, // 0.300000
  6.15519355501050191570300285093253478407859802246094e-02, // 0.400000
  9.02040104310498774831117430039739701896905899047852e-02, // 0.500000
  1.21901382249557682646567968731687869876623153686523e-01, // 0.600000
  1.55804983554603898587842536471725907176733016967773e-01, // 0.700000
  1.91207864589001158561742954589135479182004928588867e-01, // 0.800000
  2.27517646492861658202855323906987905502319335937500e-01, // 0.900000
  2.64241117657115276440293882842524908483028411865234e-01, // 1.000000
  3.00970724234032926958093412395101040601730346679688e-01, // 1.100000
  3.37372733793155243908756801829440519213676452636719e-01, // 1.200000
  3.73176876021770964619861388200661167502403259277344e-01, // 1.300000
  4.08167286540144225170934078050777316093444824218750e-01, // 1.400000
  4.42174599628925357741593415994429960846900939941406e-01, // 1.500000
  4.75069053213895919896003761095926165580749511718750e-01, // 1.600000
  5.06754485057616221865828265435993671417236328125000e-01, // 1.700000
  5.37163112979557766379912209231406450271606445312500e-01, // 1.800000
  5.66251004254358258904744616302195936441421508789062e-01, // 1.900000
  5.93994150290161893046558816422475501894950866699219e-01, // 2.000000
  4.99996666679166820142290904483453562942574244232219e-11, // 0.000010
  4.99999999966665585894661495302810307638972341801077e-21, // 0.000000
  7.02166050809290617079616581008849607314914464950562e-03, // 0.123457
  8.21025553585959189106802114110905677080154418945312e-01, // 3.141593
  7.54637885420841425521132350695552304387092590332031e-01, // 2.718282
  4.01345361152950913519177333910192828625440597534180e-02, // 0.314159
  3.08857833818859291163949620795392547734081745147705e-02, // 0.271828
  };

  public static final double[] GNUR_GAMMA_PDF_2_1 = { //
  9.04837418035959323292516387482464779168367385864258e-02, // 0.100000
  1.63746150615596414157337790129531640559434890747070e-01, // 0.200000
  2.22245466204515351726911376317730173468589782714844e-01, // 0.300000
  2.68128018414255764323428365969448350369930267333984e-01, // 0.400000
  3.03265329856316712131558688270160928368568420410156e-01, // 0.500000
  3.29286981656415955743710810565971769392490386962891e-01, // 0.600000
  3.47609712653986657748816924140555784106254577636719e-01, // 0.700000
  3.59463171293777306036787422272027470171451568603516e-01, // 0.800000
  3.65912693766539232065326814336003735661506652832031e-01, // 0.900000
  3.67879441171442334024277442949824035167694091796875e-01, // 1.000000
  3.66158192067887522380686959877493791282176971435547e-01, // 1.100000
  3.61433054294642563952777436497854068875312805175781e-01, // 1.200000
  3.54291330944216442677685563467093743383884429931641e-01, // 1.300000
  3.45235749518249146472470556545886211097240447998047e-01, // 1.400000
  3.34695240222644796457274196654907427728176116943359e-01, // 1.500000
  3.23034428791448668949470857114647515118122100830078e-01, // 1.600000
  3.10561990889648975588954726845258846879005432128906e-01, // 1.700000
  2.97537998798855729543078041388071142137050628662109e-01, // 1.800000
  2.84180376523006705813401140403584577143192291259766e-01, // 1.900000
  2.70670566473225404635627455718349665403366088867188e-01, // 2.000000
  9.99990000049999567719415105582214664536877535283566e-06, // 0.000010
  9.99999999900002689168544645524833777011641799958852e-11, // 0.000000
  1.09118427942216628112603871159080881625413894653320e-01, // 0.123457
  1.35760528150277559600311860776855610311031341552734e-01, // 3.141593
  1.79374078733908981497791046422207728028297424316406e-01, // 2.718282
  2.29462772836074496707325920397124718874692916870117e-01, // 0.314159
  2.07129044651328225734587817896681372076272964477539e-01, // 0.271828
  };

  public static final double[] SCIPY_GAMMA_CDF_4_1 = { //
  3.84683392534506373979050902756071650401281658560038e-06, // 0.100000
  5.68402407581566679176977852083751940881484188139439e-05, // 0.200000
  2.65811190021739791530808183495082630543038249015808e-04, // 0.300000
  7.76251376207015455870041886754506776924245059490204e-04, // 0.400000
  1.75162255629082394027540292569256052956916391849518e-03, // 0.500000
  3.35806885324799794106942485427680367138236761093140e-03, // 0.600000
  5.75345759229957919023146217796238488517701625823975e-03, // 0.700000
  9.07985780015398494247058636119618313387036323547363e-03, // 0.800000
  1.34587206394362543515619279332895530387759208679199e-02, // 0.900000
  1.89881568761538083167650370342016685754060745239258e-02, // 1.000000
  2.57418165296708391365232415637365193106234073638916e-02, // 1.100000
  3.37689681856556886407894069179747020825743675231934e-02, // 1.200000
  4.30954526920760624952855266656115418300032615661621e-02, // 1.300000
  5.37252503680754125992002911971212597563862800598145e-02, // 1.400000
  6.56424543784500796883563111805415246635675430297852e-02, // 1.500000
  7.88134872297189398304695373553840909153223037719727e-02, // 1.600000
  9.31894338562339608067475182906491681933403015136719e-02, // 1.700000
  1.08708394709205430350706933495530392974615097045898e-01, // 1.800000
  1.25297786682826373105825723541784100234508514404297e-01, // 1.900000
  1.42876539501452959335381365235662087798118591308594e-01, // 2.000000
  4.16663333347220766666711883927879838582564067271435e-22, // 0.000010
  4.16666666633332144820066532191263979309384757370912e-42, // 0.000000
  8.77087751463964086925343549561162603822594974189997e-06, // 0.123457
  3.84456296955979215379528568519162945449352264404297e-01, // 3.141593
  2.89942380984430481127844814182026311755180358886719e-01, // 2.718282
  3.16096723469245968057839135667563823517411947250366e-04, // 0.314159
  1.83213919706970028346976198108109201712068170309067e-04, // 0.271828
  };

  public static final double[] SCIPY_GAMMA_PDF_4_1 = { //
  1.50806236339326763494506078444601371302269399166107e-04, // 0.100000
  1.09164100410397580526167260472902853507548570632935e-03, // 0.200000
  3.33368199306773070958453963896772620500996708869934e-03, // 0.300000
  7.15008049104682522761899932106643973384052515029907e-03, // 0.400000
  1.26360554106798653184462466469994978979229927062988e-02, // 0.500000
  1.97572188993849519322854035863201715983450412750244e-02, // 0.600000
  2.83881265334089138985262934511411003768444061279297e-02, // 0.700000
  3.83427382713362394084377626768400659784674644470215e-02, // 0.800000
  4.93982136584827924430385337473126128315925598144531e-02, // 0.900000
  6.13132401952403913170108751273801317438483238220215e-02, // 1.000000
  7.38419020670239845127724720441619865596294403076172e-02, // 1.100000
  8.67439330307142181242241463223763275891542434692383e-02, // 1.200000
  9.97920582159542851607980651351681444793939590454102e-02, // 1.300000
  1.12777011509294713964557388408138649538159370422363e-01, // 1.400000
  1.25510715083491819488159535467275418341159820556641e-01, // 1.500000
  1.37828022951018119846011700246890541166067123413086e-01, // 1.600000
  1.49587358945180909364225385616009589284658432006836e-01, // 1.700000
  1.60670519351382129480398930354567710310220718383789e-01, // 1.800000
  1.70981859874675595767357094700855668634176254272461e-01, // 1.900000
  1.80447044315483556831125611097377259284257888793945e-01, // 2.000000
  1.66665000008333050761503298375805932114390142846638e-16, // 0.000010
  1.66666666650000169406744350520921226284591055366191e-31, // 0.000000
  2.77189119111339720303438527437833727162797003984451e-04, // 0.123457
  2.23317117687730742892071589267288800328969955444336e-01, // 3.141593
  2.20900855076609420324373900257342029362916946411133e-01, // 2.718282
  3.77451132111497611454353773297043517231941223144531e-03, // 0.314159
  2.55081355107697037992720012766767467837780714035034e-03, // 0.271828
  };

  public static final double[] GNUR_GAMMA_CDF_4_1 = { //
  3.84683392534506289275756177326037743569031590595841e-06, // 0.100000
  5.68402407581567289040699875179996070073684677481651e-05, // 0.200000
  2.65811190021739466270156437843752428307197988033295e-04, // 0.300000
  7.76251376207014588508303898350959570962004363536835e-04, // 0.400000
  1.75162255629082459079670641699522093404084444046021e-03, // 0.500000
  3.35806885324799880843116284268035087734460830688477e-03, // 0.600000
  5.75345759229958439440189010838366812095046043395996e-03, // 0.700000
  9.07985780015399361608796624523165519349277019500732e-03, // 0.800000
  1.34587206394362543515619279332895530387759208679199e-02, // 0.900000
  1.89881568761538083167650370342016685754060745239258e-02, // 1.000000
  2.57418165296708252587354337492797640152275562286377e-02, // 1.100000
  3.37689681856556678241076951962895691394805908203125e-02, // 1.200000
  4.30954526920761110675428540162101853638887405395508e-02, // 1.300000
  5.37252503680754125992002911971212597563862800598145e-02, // 1.400000
  6.56424543784501351995075424383685458451509475708008e-02, // 1.500000
  7.88134872297189398304695373553840909153223037719727e-02, // 1.600000
  9.31894338562340163178987495484761893749237060546875e-02, // 1.700000
  1.08708394709205402595131317866616882383823394775391e-01, // 1.800000
  1.25297786682826484128128186057438142597675323486328e-01, // 1.900000
  1.42876539501453014846532596493489108979701995849609e-01, // 2.000000
  4.16663333347220531567841719470378244835256622822300e-22, // 0.000010
  4.16666666633328958636244267286709921548589221947301e-42, // 0.000000
  8.77087751463965272771469705581637299474095925688744e-06, // 0.123457
  3.84456296956025345146201743773417547345161437988281e-01, // 3.141593
  2.89942380984641312480221131409052759408950805664062e-01, // 2.718282
  3.16096723469323813773823594885925558628514409065247e-04, // 0.314159
  1.83213919707213540154916442403987275611143559217453e-04, // 0.271828
  };

  public static final double[] GNUR_GAMMA_PDF_4_1 = { //
  1.50806236339326655074288829894157970556989312171936e-04, // 0.100000
  1.09164100410397688946384509023346254252828657627106e-03, // 0.200000
  3.33368199306772810749932567375708458712324500083923e-03, // 0.300000
  7.15008049104682436025726133266289252787828445434570e-03, // 0.400000
  1.26360554106798635837227706701924034859985113143921e-02, // 0.500000
  1.97572188993849727489671153080053045414388179779053e-02, // 0.600000
  2.83881265334089312457610532192120444960892200469971e-02, // 0.700000
  3.83427382713362532862255704912968212738633155822754e-02, // 0.800000
  4.93982136584827855041446298400842351838946342468262e-02, // 0.900000
  6.13132401952403913170108751273801317438483238220215e-02, // 1.000000
  7.38419020670239845127724720441619865596294403076172e-02, // 1.100000
  8.67439330307141764908607228790060617029666900634766e-02, // 1.200000
  9.97920582159543684275249120219086762517690658569336e-02, // 1.300000
  1.12777011509294713964557388408138649538159370422363e-01, // 1.400000
  1.25510715083491819488159535467275418341159820556641e-01, // 1.500000
  1.37828022951018064334860468989063519984483718872070e-01, // 1.600000
  1.49587358945180937119801001244923099875450134277344e-01, // 1.700000
  1.60670519351382129480398930354567710310220718383789e-01, // 1.800000
  1.70981859874675679034083941587596200406551361083984e-01, // 1.900000
  1.80447044315483640097852457984117791056632995605469e-01, // 2.000000
  1.66665000008333075413406586532424851230907807933708e-16, // 0.000010
  1.66666666649999030851742086607051100754304632309334e-31, // 0.000000
  2.77189119111339503463004030336946925672236829996109e-04, // 0.123457
  2.23317117687728605712749185840948484838008880615234e-01, // 3.141593
  2.20900855076631263962383400212274864315986633300781e-01, // 2.718282
  3.77451132111564354940091980950001016026362776756287e-03, // 0.314159
  2.55081355107941764107093440827611630083993077278137e-03, // 0.271828
  };

  public static final double[] SCIPY_GAMMA_CDF_4_10 = { //
  1.89881568761538083167650370342016685754060745239258e-02, // 0.100000
  1.42876539501452959335381365235662087798118591308594e-01, // 0.200000
  3.52768111217768576270970015684724785387516021728516e-01, // 0.300000
  5.66529879633290933682587819930631667375564575195312e-01, // 0.400000
  7.34974084702638363886251227086177095770835876464844e-01, // 0.500000
  8.48796117223352020175752841169014573097229003906250e-01, // 0.600000
  9.18234583755278332972693533520214259624481201171875e-01, // 0.700000
  9.57619888008315989225138764595612883567810058593750e-01, // 0.800000
  9.78773513697091090968172011343995109200477600097656e-01, // 0.900000
  9.89663949324074310176513336045900359749794006347656e-01, // 1.000000
  9.95084132734071036274769994633970782160758972167969e-01, // 1.100000
  9.97708208792208561810355149646056815981864929199219e-01, // 1.200000
  9.98949700268889517751347284502116963267326354980469e-01, // 1.300000
  9.99525751453871236229531405115267261862754821777344e-01, // 1.400000
  9.99788621496533247423599277681205421686172485351562e-01, // 1.500000
  9.99906858387057395631813960790168493986129760742188e-01, // 1.600000
  9.99959373411186347446744093758752569556236267089844e-01, // 1.700000
  9.99982439833354330716019831015728414058685302734375e-01, // 1.800000
  9.99992471709186814265990506100933998823165893554688e-01, // 1.900000
  9.99996796280219535368871675018453970551490783691406e-01, // 2.000000
  4.16633334722182824321055502020601847065999725794631e-18, // 0.000010
  4.16666666333333208899682539512773183295181978120839e-38, // 0.000000
  3.68452685531321239009727719349029939621686935424805e-02, // 0.123457
  9.99999999870692435344210480252513661980628967285156e-01, // 3.141593
  9.99999994136864356342186965775908902287483215332031e-01, // 2.718282
  3.84456296955979215379528568519162945449352264404297e-01, // 0.314159
  2.89942380984430259083239889150718227028846740722656e-01, // 0.271828
  };

  public static final double[] SCIPY_GAMMA_PDF_4_10 = { //
  6.13132401952403927047896559088258072733879089355469e-01, // 0.100000
  1.80447044315483551280010487971594557166099548339844e+00, // 0.200000
  2.24041807655387747999498060380574315786361694335938e+00, // 0.300000
  1.95366814813164535458156478853197768330574035644531e+00, // 0.400000
  1.40373895814280502669646466529229655861854553222656e+00, // 0.500000
  8.92350783599890173825031070009572431445121765136719e-01, // 0.600000
  5.21292523641998628569638185581425204873085021972656e-01, // 0.700000
  2.86261442476809790935732280559022910892963409423828e-01, // 0.800000
  1.49942911965315728295422559313010424375534057617188e-01, // 0.900000
  7.56665496041414309402739490906242281198501586914062e-02, // 1.000000
  3.70499395863616506896498492551472736522555351257324e-02, // 1.100000
  1.76953315775852937363765704503748565912246704101562e-02, // 1.200000
  8.27657284522896781464584847753940266557037830352783e-03, // 1.300000
  3.80285800870032181936197801519483618903905153274536e-03, // 1.400000
  1.72070055282277012062563947836224542697891592979431e-03, // 1.500000
  7.68240126083475261160871117027681975741870701313019e-04, // 1.600000
  3.38991900206525934025059143550606677308678627014160e-04, // 1.700000
  1.48035403118606612247326603792885180155280977487564e-04, // 1.800000
  6.40493012751137394053535523141817975556477904319763e-05, // 1.900000
  2.74820482991807852311567234027123163286887574940920e-05, // 2.000000
  1.66650000833305830210934716499431774874677436582004e-12, // 0.000010
  1.66666666500001019823879501718183287893096342876298e-27, // 0.000000
  9.12487883209794348182697376614669337868690490722656e-01, // 0.123457
  1.17363980155635999975867359517269286617313639453641e-09, // 3.141593
  5.24063860510259035108958120419836435033289490093011e-08, // 2.718282
  2.23317117687730748443186712393071502447128295898438e+00, // 0.314159
  2.20900855076609303750956314615905284881591796875000e+00, // 0.271828
  };

  public static final double[] GNUR_GAMMA_CDF_4_10 = { //
  1.89881568761538083167650370342016685754060745239258e-02, // 0.100000
  1.42876539501453014846532596493489108979701995849609e-01, // 0.200000
  3.52768111217768742804423709458205848932266235351562e-01, // 0.300000
  5.66529879633290933682587819930631667375564575195312e-01, // 0.400000
  7.34974084702638252863948764570523053407669067382812e-01, // 0.500000
  8.48796117223352020175752841169014573097229003906250e-01, // 0.600000
  9.18234583755278332972693533520214259624481201171875e-01, // 0.700000
  9.57619888008315989225138764595612883567810058593750e-01, // 0.800000
  9.78773513697091090968172011343995109200477600097656e-01, // 0.900000
  9.89663949324074310176513336045900359749794006347656e-01, // 1.000000
  9.95084132734071036274769994633970782160758972167969e-01, // 1.100000
  9.97708208792208561810355149646056815981864929199219e-01, // 1.200000
  9.98949700268889517751347284502116963267326354980469e-01, // 1.300000
  9.99525751453871236229531405115267261862754821777344e-01, // 1.400000
  9.99788621496533247423599277681205421686172485351562e-01, // 1.500000
  9.99906858387057395631813960790168493986129760742188e-01, // 1.600000
  9.99959373411186347446744093758752569556236267089844e-01, // 1.700000
  9.99982439833354330716019831015728414058685302734375e-01, // 1.800000
  9.99992471709186814265990506100933998823165893554688e-01, // 1.900000
  9.99996796280219535368871675018453970551490783691406e-01, // 2.000000
  4.16633334722182670246659951041733602587764319000446e-18, // 0.000010
  4.16666666333330128955973644209196576036362409030393e-38, // 0.000000
  3.68452685531321239009727719349029939621686935424805e-02, // 0.123457
  9.99999999870692435344210480252513661980628967285156e-01, // 3.141593
  9.99999994136864356342186965775908902287483215332031e-01, // 2.718282
  3.84456296956025345146201743773417547345161437988281e-01, // 0.314159
  2.89942380984641312480221131409052759408950805664062e-01, // 0.271828
  };

  public static final double[] GNUR_GAMMA_PDF_4_10 = { //
  6.13132401952403927047896559088258072733879089355469e-01, // 0.100000
  1.80447044315483640097852457984117791056632995605469e+00, // 0.200000
  2.24041807655387747999498060380574315786361694335938e+00, // 0.300000
  1.95366814813164602071537956362590193748474121093750e+00, // 0.400000
  1.40373895814280613691948929044883698225021362304688e+00, // 0.500000
  8.92350783599889285646611369884340092539787292480469e-01, // 0.600000
  5.21292523641998628569638185581425204873085021972656e-01, // 0.700000
  2.86261442476810124002639668105985037982463836669922e-01, // 0.800000
  1.49942911965315672784271328055183403193950653076172e-01, // 0.900000
  7.56665496041414725736373725339944940060377120971680e-02, // 1.000000
  3.70499395863616229340742336262337630614638328552246e-02, // 1.100000
  1.76953315775852486335661950533904018811881542205811e-02, // 1.200000
  8.27657284522894699796413675585426972247660160064697e-03, // 1.300000
  3.80285800870031921727676404998419457115232944488525e-03, // 1.400000
  1.72070055282276881958303249575692461803555488586426e-03, // 1.500000
  7.68240126083476779043912596733889586175791919231415e-04, // 1.600000
  3.38991900206525934025059143550606677308678627014160e-04, // 1.700000
  1.48035403118606883297869725168993682018481194972992e-04, // 1.800000
  6.40493012751137529578807083829872226488078013062477e-05, // 1.900000
  2.74820482991807886192885124199136726019787602126598e-05, // 2.000000
  1.66650000833305870600613063815236211955179979060659e-12, // 0.000010
  1.66666666499998652189994178507260255159592416234002e-27, // 0.000000
  9.12487883209794348182697376614669337868690490722656e-01, // 0.123457
  1.17363980155416280125657961541131568683482555570663e-09, // 3.141593
  5.24063860505807479924442746684748462016045778000262e-08, // 2.718282
  2.23317117687728572406058447086252272129058837890625e+00, // 0.314159
  2.20900855076631241757922907709144055843353271484375e+00, // 0.271828
  };

  public static final double[] SCIPY_GAMMA_CDF_01_10 = { //
  9.75872656273672145488262685830704867839813232421875e-01, // 0.100000
  9.94326176020188468029914474755059927701950073242188e-01, // 0.200000
  9.98434728252885594912413580459542572498321533203125e-01, // 0.300000
  9.99535388712767813856885368295479565858840942382812e-01, // 0.400000
  9.99856061034153253963552288041682913899421691894531e-01, // 0.500000
  9.99954127338806841862606233917176723480224609375000e-01, // 0.600000
  9.99985082831851612716889121657004579901695251464844e-01, // 0.700000
  9.99995075192051996459952079021604731678962707519531e-01, // 0.800000
  9.99998354830390345782120675721671432256698608398438e-01, // 0.900000
  9.99999445201428249774266987515147775411605834960938e-01, // 1.000000
  9.99999811450770770271390119887655600905418395996094e-01, // 1.100000
  9.99999935505229697874085559305967763066291809082031e-01, // 1.200000
  9.99999977817657148548846635094378143548965454101562e-01, // 1.300000
  9.99999992334555942719021004450041800737380981445312e-01, // 1.400000
  9.99999997340225710296124361775582656264305114746094e-01, // 1.500000
  9.99999999073787781966871079930569976568222045898438e-01, // 1.600000
  9.99999999676440931573040415969444438815116882324219e-01, // 1.700000
  9.99999999886649670877147855208022519946098327636719e-01, // 1.800000
  9.99999999960190066872200986836105585098266601562500e-01, // 1.900000
  9.99999999985986431916273886599810793995857238769531e-01, // 2.000000
  4.18461375237962951434411706941318698227405548095703e-01, // 0.000010
  1.32330308815105796016453609809104818850755691528320e-01, // 0.000000
  9.83240178351675986334612389327958226203918457031250e-01, // 0.123457
  9.99999999999999888977697537484345957636833190917969e-01, // 3.141593
  9.99999999999991784349617773841600865125656127929688e-01, // 2.718282
  9.98686603432971331528733571758493781089782714843750e-01, // 0.314159
  9.97771302397556292262947863491717725992202758789062e-01, // 0.271828
  };

  public static final double[] SCIPY_GAMMA_PDF_01_10 = { //
  3.86691694403023700221666558718425221741199493408203e-01, // 0.100000
  7.62330623530854123437450198252918198704719543457031e-02, // 0.200000
  1.94700358454044236689028934961243066936731338500977e-02, // 0.300000
  5.52875577773295160538546966222384071443229913711548e-03, // 0.400000
  1.66384900992015260373646512448431167285889387130737e-03, // 0.500000
  5.19465021361826249403359501144450405263341963291168e-04, // 0.600000
  1.66344986720691771688723781252861044777091592550278e-04, // 0.700000
  5.42653342633515591237128306012493794696638360619545e-05, // 0.800000
  1.79552199849926109312056587974382182437693700194359e-05, // 0.900000
  6.00778672619989704319900733486825572526868199929595e-06, // 1.000000
  2.02846074898835833691911056941847846246673725545406e-06, // 1.100000
  6.90021180431038364101552478463430517763299576472491e-07, // 1.200000
  2.36201169837157485606116071215343499289929241058417e-07, // 1.300000
  8.12870470963516557411429738419506030311367794638500e-08, // 1.400000
  2.81034711509505172708305416806248699934656087862095e-08, // 1.500000
  9.75527757384449392403810659207472055776122488168767e-09, // 1.600000
  3.39820132151311703127167328079318020517263221336179e-09, // 1.700000
  1.18744471030516355255038446822732009500178662619874e-09, // 1.800000
  4.16088707178314669861834363610679499156930205572280e-10, // 1.900000
  1.46164764735815876829497270010841617621233368140565e-10, // 2.000000
  4.18423334941553275712067261338233947753906250000000e+03, // 0.000010
  1.32330308694805443286895751953125000000000000000000e+08, // 0.000000
  2.53005809030332373676941415396868251264095306396484e-01, // 0.123457
  1.07265707643817319806681139845227667938280975701293e-15, // 3.141593
  8.42260257482259737446868026839438676448175435940158e-14, // 2.718282
  1.62124289852739640604983861749133211560547351837158e-02, // 0.314159
  2.82006743783194402386271804061834700405597686767578e-02, // 0.271828
  };

  public static final double[] GNUR_GAMMA_CDF_01_10 = { //
  9.75872656273672256510565148346358910202980041503906e-01, // 0.100000
  9.94326176020188468029914474755059927701950073242188e-01, // 0.200000
  9.98434728252885594912413580459542572498321533203125e-01, // 0.300000
  9.99535388712767813856885368295479565858840942382812e-01, // 0.400000
  9.99856061034153253963552288041682913899421691894531e-01, // 0.500000
  9.99954127338806841862606233917176723480224609375000e-01, // 0.600000
  9.99985082831851612716889121657004579901695251464844e-01, // 0.700000
  9.99995075192051996459952079021604731678962707519531e-01, // 0.800000
  9.99998354830390345782120675721671432256698608398438e-01, // 0.900000
  9.99999445201428249774266987515147775411605834960938e-01, // 1.000000
  9.99999811450770770271390119887655600905418395996094e-01, // 1.100000
  9.99999935505229697874085559305967763066291809082031e-01, // 1.200000
  9.99999977817657148548846635094378143548965454101562e-01, // 1.300000
  9.99999992334555942719021004450041800737380981445312e-01, // 1.400000
  9.99999997340225710296124361775582656264305114746094e-01, // 1.500000
  9.99999999073787781966871079930569976568222045898438e-01, // 1.600000
  9.99999999676440931573040415969444438815116882324219e-01, // 1.700000
  9.99999999886649670877147855208022519946098327636719e-01, // 1.800000
  9.99999999960190066872200986836105585098266601562500e-01, // 1.900000
  9.99999999985986431916273886599810793995857238769531e-01, // 2.000000
  4.18461375237963006945562938199145719408988952636719e-01, // 0.000010
  1.32330308815105768260877994180191308259963989257812e-01, // 0.000000
  9.83240178351675764290007464296650141477584838867188e-01, // 0.123457
  9.99999999999999888977697537484345957636833190917969e-01, // 3.141593
  9.99999999999991784349617773841600865125656127929688e-01, // 2.718282
  9.98686603432971664595640959305455908179283142089844e-01, // 0.314159
  9.97771302397558956798206963867414742708206176757812e-01, // 0.271828
  };

  public static final double[] GNUR_GAMMA_PDF_01_10 = { //
  3.86691694403023811243969021234079264104366302490234e-01, // 0.100000
  7.62330623530854400993206354542053304612636566162109e-02, // 0.200000
  1.94700358454044201994559415425101178698241710662842e-02, // 0.300000
  5.52875577773295420747068362743448233231902122497559e-03, // 0.400000
  1.66384900992015282057689962158519847434945404529572e-03, // 0.500000
  5.19465021361826032562925004043563603772781789302826e-04, // 0.600000
  1.66344986720691988529158278353747846267651766538620e-04, // 0.700000
  5.42653342633515862287671427388602296559838578104973e-05, // 0.800000
  1.79552199849926244837328148662436433369293808937073e-05, // 0.900000
  6.00778672619989450210016557196723852030117996037006e-06, // 1.000000
  2.02846074898835876043558419656864799662798759527504e-06, // 1.100000
  6.90021180431039528771854953126396736706738010980189e-07, // 1.200000
  2.36201169837157459136336469518457903404851094819605e-07, // 1.300000
  8.12870470963517086807021772357217948012930719414726e-08, // 1.400000
  2.81034711509505834452795459228388597061609743832378e-08, // 1.500000
  9.75527757384449888712178191024076978621337730146479e-09, // 1.600000
  3.39820132151312695743902391712527866207693705291604e-09, // 1.700000
  1.18744471030516479332130329776883240211482473114302e-09, // 1.800000
  4.16088707178313997777586664275693666137367898727462e-10, // 1.900000
  1.46164764735815825130708985446611938158190113767887e-10, // 2.000000
  4.18423334941553457611007615923881530761718750000000e+03, // 0.000010
  1.32330308694805443286895751953125000000000000000000e+08, // 0.000000
  2.53005809030332484699243877912522293627262115478516e-01, // 0.123457
  1.07265707643589812321615400040546925420053420152655e-15, // 3.141593
  8.42260257473954736054446049913952863989448707759955e-14, // 2.718282
  1.62124289852696411295962519716340466402471065521240e-02, // 0.314159
  2.82006743782835765654848358963135979138314723968506e-02, // 0.271828
  };

  public static final double[] SCIPY_GAMMA_CDF_01_20 = { //
  9.94326176020188468029914474755059927701950073242188e-01, // 0.100000
  9.99535388712767813856885368295479565858840942382812e-01, // 0.200000
  9.99954127338806841862606233917176723480224609375000e-01, // 0.300000
  9.99995075192051996459952079021604731678962707519531e-01, // 0.400000
  9.99999445201428249774266987515147775411605834960938e-01, // 0.500000
  9.99999935505229697874085559305967763066291809082031e-01, // 0.600000
  9.99999992334555942719021004450041800737380981445312e-01, // 0.700000
  9.99999999073787781966871079930569976568222045898438e-01, // 0.800000
  9.99999999886649670877147855208022519946098327636719e-01, // 0.900000
  9.99999999985986431916273886599810793995857238769531e-01, // 1.000000
  9.99999999998253064070752316183643415570259094238281e-01, // 1.100000
  9.99999999999780730952636531583266332745552062988281e-01, // 1.200000
  9.99999999999972355446686833602143451571464538574219e-01, // 1.300000
  9.99999999999996447286321199499070644378662109375000e-01, // 1.400000
  9.99999999999999555910790149937383830547332763671875e-01, // 1.500000
  9.99999999999999888977697537484345957636833190917969e-01, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  4.48491720125246684514053185921511612832546234130859e-01, // 0.000010
  1.41828113264369309876045122109644580632448196411133e-01, // 0.000000
  9.96936964362935218453287689044373109936714172363281e-01, // 0.123457
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  9.99966686426665196663066126347985118627548217773438e-01, // 0.314159
  9.99912881838271760948089195153443142771720886230469e-01, // 0.271828
  };

  public static final double[] SCIPY_GAMMA_PDF_01_20 = { //
  1.52466124706170824687490039650583639740943908691406e-01, // 0.100000
  1.10575115554659032107709393244476814288645982742310e-02, // 0.200000
  1.03893004272365249880671900228890081052668392658234e-03, // 0.300000
  1.08530668526703118247425661202498758939327672123909e-04, // 0.400000
  1.20155734523997940863980146697365114505373639985919e-05, // 0.500000
  1.38004236086207672820310495692686103552659915294498e-06, // 0.600000
  1.62574094192703311482285947683901206062273558927700e-07, // 0.700000
  1.95105551476889878480762131841494411155224497633753e-08, // 0.800000
  2.37488942061032710510076893645464019000357325239747e-09, // 0.900000
  2.92329529471631753658994540021683235242466736281131e-10, // 1.000000
  3.63103392931038151766683113755789609131130468711035e-11, // 1.100000
  4.54393006390842164952338174282894757080586423114710e-12, // 1.200000
  5.72211759915234715705708461587397688436276710355344e-13, // 1.300000
  7.24438629339447104119041928796962738566333345202608e-14, // 1.400000
  9.21394754227480053810143174892231491926485650173495e-15, // 1.500000
  1.17660562505859836487690040130500292983677893422084e-15, // 1.600000
  1.50780754320226546403459477832592082942578975198605e-16, // 1.700000
  1.93827646502898085931666826628168232690749572821615e-17, // 1.800000
  2.49858295196862659910572709810793896012441320426695e-18, // 1.900000
  3.22891084281901708463501316045877085134772951439524e-19, // 2.000000
  4.48410183235842850990593433380126953125000000000000e+03, // 0.000010
  1.41828113006499916315078735351562500000000000000000e+08, // 0.000000
  7.88983383252931935736285140592372044920921325683594e-02, // 0.123457
  2.61096087098872756423344011324704568131684902965870e-29, // 3.141593
  1.41319250269510810248688074925111402327654344402472e-25, // 2.718282
  7.50887254129001474947657790437460789689794182777405e-04, // 0.314159
  1.99447085860641592364173035889507445972412824630737e-03, // 0.271828
  };

  public static final double[] GNUR_GAMMA_CDF_01_20 = { //
  9.94326176020188468029914474755059927701950073242188e-01, // 0.100000
  9.99535388712767813856885368295479565858840942382812e-01, // 0.200000
  9.99954127338806841862606233917176723480224609375000e-01, // 0.300000
  9.99995075192051996459952079021604731678962707519531e-01, // 0.400000
  9.99999445201428249774266987515147775411605834960938e-01, // 0.500000
  9.99999935505229697874085559305967763066291809082031e-01, // 0.600000
  9.99999992334555942719021004450041800737380981445312e-01, // 0.700000
  9.99999999073787781966871079930569976568222045898438e-01, // 0.800000
  9.99999999886649670877147855208022519946098327636719e-01, // 0.900000
  9.99999999985986431916273886599810793995857238769531e-01, // 1.000000
  9.99999999998253064070752316183643415570259094238281e-01, // 1.100000
  9.99999999999780730952636531583266332745552062988281e-01, // 1.200000
  9.99999999999972355446686833602143451571464538574219e-01, // 1.300000
  9.99999999999996447286321199499070644378662109375000e-01, // 1.400000
  9.99999999999999555910790149937383830547332763671875e-01, // 1.500000
  9.99999999999999888977697537484345957636833190917969e-01, // 1.600000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.700000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.800000
  1.00000000000000000000000000000000000000000000000000e+00, // 1.900000
  1.00000000000000000000000000000000000000000000000000e+00, // 2.000000
  4.48491720125246851047506879694992676377296447753906e-01, // 0.000010
  1.41828113264369393142771968996385112404823303222656e-01, // 0.000000
  9.96936964362935329475590151560027152299880981445312e-01, // 0.123457
  1.00000000000000000000000000000000000000000000000000e+00, // 3.141593
  1.00000000000000000000000000000000000000000000000000e+00, // 2.718282
  9.99966686426665196663066126347985118627548217773438e-01, // 0.314159
  9.99912881838271982992694120184751227498054504394531e-01, // 0.271828
  };

  public static final double[] GNUR_GAMMA_PDF_01_20 = { //
  1.52466124706170880198641270908410660922527313232422e-01, // 0.100000
  1.10575115554659084149413672548689646646380424499512e-02, // 0.200000
  1.03893004272365206512585000808712720754556357860565e-03, // 0.300000
  1.08530668526703172457534285477720459311967715620995e-04, // 0.400000
  1.20155734523997890042003311439344770406023599207401e-05, // 0.500000
  1.38004236086207905754370990625279347341347602196038e-06, // 0.600000
  1.62574094192703417361404354471443589602586143882945e-07, // 0.700000
  1.95105551476889977742435638204815395724267546029296e-08, // 0.800000
  2.37488942061032958664260659553766480422964946228603e-09, // 0.900000
  2.92329529471631650261417970893223876316380227535774e-10, // 1.000000
  3.63103392931038281013653825166363807788738604642731e-11, // 1.100000
  4.54393006390842084172981479651285882919581338157400e-12, // 1.200000
  5.72211759915235624473471276192997522747583916125080e-13, // 1.300000
  7.24438629339446220594828081263740677430340228482031e-14, // 1.400000
  9.21394754227482262620677793725286644766468441974938e-15, // 1.500000
  1.17660562505860112589006867484632187088675742397265e-15, // 1.600000
  1.50780754320227852954333750133394796118015224813298e-16, // 1.700000
  1.93827646502899996454171658766134464220868617069515e-17, // 1.800000
  2.49858295196864470284720433812495768631707350258375e-18, // 1.900000
  3.22891084281903345503954045196352182716024148627745e-19, // 2.000000
  4.48410183235842760041123256087303161621093750000000e+03, // 0.000010
  1.41828113006500124931335449218750000000000000000000e+08, // 0.000000
  7.88983383252932352069919375026074703782796859741211e-02, // 0.123457
  2.61096087097776828920364858389876537699185525357919e-29, // 3.141593
  1.41319250266768533456788338854519414081259096541228e-25, // 2.718282
  7.50887254128645965055299793533549745916388928890228e-04, // 0.314159
  1.99447085860197633258583671533870074199512600898743e-03, // 0.271828
  };

  public static final double[] SCIPY_GAMMA_CDF_01_4 = { //
  9.27573833553704485410662528011016547679901123046875e-01, // 0.100000
  9.66394653856728291785316287132445722818374633789062e-01, // 0.200000
  9.82338840734720442071647994453087449073791503906250e-01, // 0.300000
  9.90161634314574046200618795410264283418655395507812e-01, // 0.400000
  9.94326176020188468029914474755059927701950073242188e-01, // 0.500000
  9.96650923670122979025620679749408736824989318847656e-01, // 0.600000
  9.97989690314743826959897887718398123979568481445312e-01, // 0.700000
  9.98777830395332189006296630395809188485145568847656e-01, // 0.800000
  9.99249499182313538625521687208674848079681396484375e-01, // 0.900000
  9.99535388712767813856885368295479565858840942382812e-01, // 1.000000
  9.99710441300151630983350514725316315889358520507812e-01, // 1.100000
  9.99818519608100975126774301315890625119209289550781e-01, // 1.200000
  9.99885709402319799998792859696550294756889343261719e-01, // 1.300000
  9.99927723862083506212172778759850189089775085449219e-01, // 1.400000
  9.99954127338806841862606233917176723480224609375000e-01, // 1.500000
  9.99970792125264407168572233786107972264289855957031e-01, // 1.600000
  9.99981350059541806984952927450649440288543701171875e-01, // 1.700000
  9.99988061331210875692931949743069708347320556640625e-01, // 1.800000
  9.99992340071521379485375291551463305950164794921875e-01, // 1.900000
  9.99995075192051996459952079021604731678962707519531e-01, // 2.000000
  3.81824459744078470446737583188223652541637420654297e-01, // 0.000010
  1.20743934975320044156177345939795486629009246826172e-01, // 0.000000
  9.40661616417386547972512289561564102768898010253906e-01, // 0.123457
  9.99999964784593187161476635083090513944625854492188e-01, // 3.141593
  9.99999783864769620223000856640283018350601196289062e-01, // 2.718282
  9.83788069985481405943517074774717912077903747558594e-01, // 0.314159
  9.78987050620883314522302498517092317342758178710938e-01, // 0.271828
  };

  public static final double[] SCIPY_GAMMA_PDF_01_4 = { //
  6.42906079231301164078615784092107787728309631347656e-01, // 0.100000
  2.30941904807187847747940168119384907186031341552734e-01, // 0.200000
  1.07473852696625640779082289100188063457608222961426e-01, // 0.300000
  5.56083695858133400524714318180485861375927925109863e-02, // 0.400000
  3.04932249412341663252767887115624034777283668518066e-02, // 0.500000
  1.73469227014204988024381748346058884635567665100098e-02, // 0.600000
  1.01216785315276381479465683810303744394332170486450e-02, // 0.700000
  6.01647331475561961827702717187094094697386026382446e-03, // 0.800000
  3.62732886466578426098994469839453813619911670684814e-03, // 0.900000
  2.21150231109318090236270926141060044756159186363220e-03, // 1.000000
  1.36055526775470518076327497425381807261146605014801e-03, // 1.100000
  8.43312796876826494159307134879099976387806236743927e-04, // 1.200000
  5.25999101373744552823108477923597092740237712860107e-04, // 1.300000
  3.29838232387005033784815877240248482848983258008957e-04, // 1.400000
  2.07786008544730114869572568103706089459592476487160e-04, // 1.500000
  1.31423387335168583012201537485452718101441860198975e-04, // 1.600000
  8.34178167284065351675878541293229773145867511630058e-05, // 1.700000
  5.31128738330742547154618427018846205100999213755131e-05, // 1.800000
  3.39116578546243936046616918034146692662034183740616e-05, // 1.900000
  2.17061337053406243271114900439400230425235349684954e-05, // 2.000000
  3.81810575458691437233937904238700866699218750000000e+03, // 0.000010
  1.20743934931413173675537109375000000000000000000000e+08, // 0.000000
  4.84212362445597399585039966041222214698791503906250e-01, // 0.123457
  1.50288248944523529597303750440784320119291805895045e-07, // 3.141593
  9.30810123491585766181913991212937276031880173832178e-07, // 2.718282
  9.74271275055620944449685794097604230046272277832031e-02, // 0.314159
  1.31457803694503660985049009468639269471168518066406e-01, // 0.271828
  };

  public static final double[] GNUR_GAMMA_CDF_01_4 = { //
  9.27573833553704485410662528011016547679901123046875e-01, // 0.100000
  9.66394653856728513829921212163753807544708251953125e-01, // 0.200000
  9.82338840734720664116252919484395533800125122070312e-01, // 0.300000
  9.90161634314574046200618795410264283418655395507812e-01, // 0.400000
  9.94326176020188468029914474755059927701950073242188e-01, // 0.500000
  9.96650923670122979025620679749408736824989318847656e-01, // 0.600000
  9.97989690314743826959897887718398123979568481445312e-01, // 0.700000
  9.98777830395332189006296630395809188485145568847656e-01, // 0.800000
  9.99249499182313538625521687208674848079681396484375e-01, // 0.900000
  9.99535388712767813856885368295479565858840942382812e-01, // 1.000000
  9.99710441300151630983350514725316315889358520507812e-01, // 1.100000
  9.99818519608100975126774301315890625119209289550781e-01, // 1.200000
  9.99885709402319799998792859696550294756889343261719e-01, // 1.300000
  9.99927723862083506212172778759850189089775085449219e-01, // 1.400000
  9.99954127338806841862606233917176723480224609375000e-01, // 1.500000
  9.99970792125264407168572233786107972264289855957031e-01, // 1.600000
  9.99981350059541806984952927450649440288543701171875e-01, // 1.700000
  9.99988061331210875692931949743069708347320556640625e-01, // 1.800000
  9.99992340071521379485375291551463305950164794921875e-01, // 1.900000
  9.99995075192051996459952079021604731678962707519531e-01, // 2.000000
  3.81824459744078470446737583188223652541637420654297e-01, // 0.000010
  1.20743934975320044156177345939795486629009246826172e-01, // 0.000000
  9.40661616417386770017117214592872187495231628417969e-01, // 0.123457
  9.99999964784593187161476635083090513944625854492188e-01, // 3.141593
  9.99999783864769620223000856640283018350601196289062e-01, // 2.718282
  9.83788069985483404344961400056490674614906311035156e-01, // 0.314159
  9.78987050620895637997875837754691019654273986816406e-01, // 0.271828
  };

  public static final double[] GNUR_GAMMA_PDF_01_4 = { //
  6.42906079231301386123220709123415872454643249511719e-01, // 0.100000
  2.30941904807187903259091399377211928367614746093750e-01, // 0.200000
  1.07473852696625682412445712543558329343795776367188e-01, // 0.300000
  5.56083695858133747469409513541904743760824203491211e-02, // 0.400000
  3.04932249412341767336176445724049699492752552032471e-02, // 0.500000
  1.73469227014205092107790306954484549351036548614502e-02, // 0.600000
  1.01216785315276381479465683810303744394332170486450e-02, // 0.700000
  6.01647331475562135300050314867803535889834165573120e-03, // 0.800000
  3.62732886466578339362820670999099093023687601089478e-03, // 0.900000
  2.21150231109318176972444724981414765352383255958557e-03, // 1.000000
  1.36055526775470539760370947135470487410202622413635e-03, // 1.100000
  8.43312796876827144680610626181760380859486758708954e-04, // 1.200000
  5.25999101373743902301804986620936688268557190895081e-04, // 1.300000
  3.29838232387004816944381380139361681358423084020615e-04, // 1.400000
  2.07786008544730223289789816654149490204872563481331e-04, // 1.500000
  1.31423387335168528802092913210231017728801816701889e-04, // 1.600000
  8.34178167284063996423162934412687263829866424202919e-05, // 1.700000
  5.31128738330743021493068889427036083361599594354630e-05, // 1.800000
  3.39116578546244545910338941130390821854234673082829e-05, // 1.900000
  2.17061337053406344915068570955440918623935431241989e-05, // 2.000000
  3.81810575458691755557083524763584136962890625000000e+03, // 0.000010
  1.20743934931413218379020690917968750000000000000000e+08, // 0.000000
  4.84212362445597510607342428556876257061958312988281e-01, // 0.123457
  1.50288248944390466015246020196893805831450663390569e-07, // 3.141593
  9.30810123487737271986064077622380352750042220577598e-07, // 2.718282
  9.74271275055482721683119962108321487903594970703125e-02, // 0.314159
  1.31457803694411845540912509022746235132217407226562e-01, // 0.271828
  };

  public static final double[] SCIPY_GAMMA_CDF_01_1 = { //
  8.27551759585850255085404114652192220091819763183594e-01, // 0.100000
  8.79419626790056918608229352685157209634780883789062e-01, // 0.200000
  9.08357989730034232067623634065967053174972534179688e-01, // 0.300000
  9.27573833553704485410662528011016547679901123046875e-01, // 0.400000
  9.41402445890133443562319826014572754502296447753906e-01, // 0.500000
  9.51832144669906954348448380187619477510452270507812e-01, // 0.600000
  9.59944796430632019124118414765689522027969360351562e-01, // 0.700000
  9.66394653856728291785316287132445722818374633789062e-01, // 0.800000
  9.71606904600970766594514316238928586244583129882812e-01, // 0.900000
  9.75872656273672145488262685830704867839813232421875e-01, // 1.000000
  9.79399221790659857411753819178557023406028747558594e-01, // 1.100000
  9.82338840734720442071647994453087449073791503906250e-01, // 1.200000
  9.84806083916309082937345920072402805089950561523438e-01, // 1.300000
  9.86888912463439682554167120542842894792556762695312e-01, // 1.400000
  9.88655983362194623609298105293419212102890014648438e-01, // 1.500000
  9.90161634314574046200618795410264283418655395507812e-01, // 1.600000
  9.91449379513895889814989459409844130277633666992188e-01, // 1.700000
  9.92554419222070327677442946878727525472640991210938e-01, // 1.800000
  9.93505478144843912069461566716199740767478942871094e-01, // 1.900000
  9.94326176020188468029914474755059927701950073242188e-01, // 2.000000
  3.32398405040503219787240141158690676093101501464844e-01, // 0.000010
  1.05113700610222168818630450459750136360526084899902e-01, // 0.000000
  8.43459089726093846905996542773209512233734130859375e-01, // 0.123457
  9.98686603432971331528733571758493781089782714843750e-01, // 3.141593
  9.97771302397556292262947863491717725992202758789062e-01, // 2.718282
  9.11526840920496961295782512024743482470512390136719e-01, // 0.314159
  9.01485773262812539741162254358641803264617919921875e-01, // 0.271828
  };

  public static final double[] SCIPY_GAMMA_PDF_01_1 = { //
  7.55492013825307062724334628001088276505470275878906e-01, // 0.100000
  3.66330799305670196108764002929092384874820709228516e-01, // 0.200000
  2.30123967106513782621135533190681599080562591552734e-01, // 0.300000
  1.60726519807825291019653946023026946932077407836914e-01, // 0.400000
  1.18970443671299608290325977577595040202140808105469e-01, // 0.500000
  9.13579848700025454188988760506617836654186248779297e-02, // 0.600000
  7.19556586194085856522661970302578993141651153564453e-02, // 0.700000
  5.77354762017969619369850420298462267965078353881836e-02, // 0.800000
  4.69868178615557574584471467460389249026775360107422e-02, // 0.900000
  3.86691694403023741855029982161795487627387046813965e-02, // 1.000000
  3.21130813374652795966213147949019912630319595336914e-02, // 1.100000
  2.68684631741564101947705722750470158644020557403564e-02, // 1.200000
  2.26218168783205615668396859518907149322330951690674e-02, // 1.300000
  1.91483703787232971416099047701209201477468013763428e-02, // 1.400000
  1.62830392611040195016691711771272821351885795593262e-02, // 1.500000
  1.39020923964533350131178579545121465343981981277466e-02, // 1.600000
  1.19111769796363797108140758496119815390557050704956e-02, // 1.700000
  1.02372663794025164224477109087274584453552961349487e-02, // 1.800000
  8.82310747761274466460790222299692686647176742553711e-03, // 1.900000
  7.62330623530854158131919717789060086943209171295166e-03, // 2.000000
  3.32395383249902215538895688951015472412109375000000e+03, // 0.000010
  1.05113700600666418671607971191406250000000000000000e+08, // 0.000000
  6.10491420220252267725413730659056454896926879882812e-01, // 0.123457
  1.62124289852739653615409931575186419649980962276459e-03, // 3.141593
  2.82006743783194159524985167308841482736170291900635e-03, // 2.718282
  2.17664099893520729400719915247464086860418319702148e-01, // 0.314159
  2.58666872715845264085743338000611402094364166259766e-01, // 0.271828
  };

  public static final double[] GNUR_GAMMA_CDF_01_1 = { //
  8.27551759585850477130009039683500304818153381347656e-01, // 0.100000
  8.79419626790056807585926890169503167271614074707031e-01, // 0.200000
  9.08357989730034232067623634065967053174972534179688e-01, // 0.300000
  9.27573833553704485410662528011016547679901123046875e-01, // 0.400000
  9.41402445890133554584622288530226796865463256835938e-01, // 0.500000
  9.51832144669907287415355767734581604599952697753906e-01, // 0.600000
  9.59944796430632130146420877281343564391136169433594e-01, // 0.700000
  9.66394653856728513829921212163753807544708251953125e-01, // 0.800000
  9.71606904600970988639119241270236670970916748046875e-01, // 0.900000
  9.75872656273672256510565148346358910202980041503906e-01, // 1.000000
  9.79399221790659524344846431631594896316528320312500e-01, // 1.100000
  9.82338840734720664116252919484395533800125122070312e-01, // 1.200000
  9.84806083916308971915043457556748762726783752441406e-01, // 1.300000
  9.86888912463439793576469583058496937155723571777344e-01, // 1.400000
  9.88655983362194734631600567809073254466056823730469e-01, // 1.500000
  9.90161634314574046200618795410264283418655395507812e-01, // 1.600000
  9.91449379513895889814989459409844130277633666992188e-01, // 1.700000
  9.92554419222070327677442946878727525472640991210938e-01, // 1.800000
  9.93505478144843912069461566716199740767478942871094e-01, // 1.900000
  9.94326176020188468029914474755059927701950073242188e-01, // 2.000000
  3.32398405040503330809542603674344718456268310546875e-01, // 0.000010
  1.05113700610222196574206066088663646951317787170410e-01, // 0.000000
  8.43459089726094068950601467804517596960067749023438e-01, // 0.123457
  9.98686603432971664595640959305455908179283142089844e-01, // 3.141593
  9.97771302397558956798206963867414742708206176757812e-01, // 2.718282
  9.11526840920501624232485937682213261723518371582031e-01, // 0.314159
  9.01485773262837186692308932833839207887649536132812e-01, // 0.271828
  };

  public static final double[] GNUR_GAMMA_PDF_01_1 = { //
  7.55492013825307506813544478063704445958137512207031e-01, // 0.100000
  3.66330799305670307131066465444746427237987518310547e-01, // 0.200000
  2.30123967106513865887862380077422130852937698364258e-01, // 0.300000
  1.60726519807825346530805177280853968113660812377930e-01, // 0.400000
  1.18970443671299608290325977577595040202140808105469e-01, // 0.500000
  9.13579848700025592966866838651185389608144760131836e-02, // 0.600000
  7.19556586194086134078418126591714099049568176269531e-02, // 0.700000
  5.77354762017969758147728498443029820919036865234375e-02, // 0.800000
  4.69868178615557713362349545604956801980733871459961e-02, // 0.900000
  3.86691694403023811243969021234079264104366302490234e-02, // 1.000000
  3.21130813374652934744091226093587465584278106689453e-02, // 1.100000
  2.68684631741564206031114281358895823359489440917969e-02, // 1.200000
  2.26218168783205719751805418127332814037799835205078e-02, // 1.300000
  1.91483703787233006110568567237351089715957641601562e-02, // 1.400000
  1.62830392611040264405630750843556597828865051269531e-02, // 1.500000
  1.39020923964533436867352378385476185940206050872803e-02, // 1.600000
  1.19111769796363866497079797568403591867536306381226e-02, // 1.700000
  1.02372663794025233613416148159558360930532217025757e-02, // 1.800000
  8.82310747761274292988442624618983245454728603363037e-03, // 1.900000
  7.62330623530854418340441114310124248731881380081177e-03, // 2.000000
  3.32395383249902442912571132183074951171875000000000e+03, // 0.000010
  1.05113700600666448473930358886718750000000000000000e+08, // 0.000000
  6.10491420220252156703111268143402412533760070800781e-01, // 0.123457
  1.62124289852696415632771209658358202432282269001007e-03, // 3.141593
  2.82006743782835809022935258383313339436426758766174e-03, // 2.718282
  2.17664099893503326654808915918692946434020996093750e-01, // 0.314159
  2.58666872715738793697681785488384775817394256591797e-01, // 0.271828
  };

  public static final double[] P_QUANT = { //
  0.0001, 0.001, 0.01, 0.1, 0.25, 0.5, 0.75, 0.9, 0.99, 0.999, 0.9999 //
  };

  public static final double[] SCIPY_GAMMA_QUANT_1_1 = { //
  1.00005000333358370239768275755665172255248762667179e-04, // 0.000100
  1.00050033358353349620395444929954464896582067012787e-03, // 0.001000
  1.00503358535014367114435174244135851040482521057129e-02, // 0.010000
  1.05360515657826322999390811219200259074568748474121e-01, // 0.100000
  2.87682072451780956878764072826015762984752655029297e-01, // 0.250000
  6.93147180559945286226763982995180413126945495605469e-01, // 0.500000
  1.38629436111989079449813289102166891098022460937500e+00, // 0.750000
  2.30258509299404590109361379290930926799774169921875e+00, // 0.900000
  4.60517018598809002583038818556815385818481445312500e+00, // 0.990000
  6.90775527898213592692400197847746312618255615234375e+00, // 0.999000
  9.21034037197629196214165858691558241844177246093750e+00, // 0.999900
  };

  public static final double[] GNUR_GAMMA_QUANT_1_1 = { //
  1.00005000333358343134713963618054322068928740918636e-04, // 0.000100
  1.00050033358353349620395444929954464896582067012787e-03, // 0.001000
  1.00503358535014419156139453548348683398216962814331e-02, // 0.010000
  1.05360515657826309121603003404743503779172897338867e-01, // 0.100000
  2.87682072451780901367612841568188741803169250488281e-01, // 0.250000
  6.93147180559945286226763982995180413126945495605469e-01, // 0.500000
  1.38629436111989057245352796599036082625389099121094e+00, // 0.750000
  2.30258509299404590109361379290930926799774169921875e+00, // 0.900000
  4.60517018598809002583038818556815385818481445312500e+00, // 0.990000
  6.90775527898213592692400197847746312618255615234375e+00, // 0.999000
  9.21034037197629196214165858691558241844177246093750e+00, // 0.999900
  };

  public static final double[] SCIPY_GAMMA_QUANT_2_1 = { //
  1.42092376217775075153415542672519222833216190338135e-02, // 0.000100
  4.54020177694895513131889686064823763445019721984863e-02, // 0.001000
  1.48554740253265954441630469773372169584035873413086e-01, // 0.010000
  5.31811608389612056058126654534135013818740844726562e-01, // 0.100000
  9.61278763114777112797071367822354659438133239746094e-01, // 0.250000
  1.67834699001666076689787132636411115527153015136719e+00, // 0.500000
  2.69263452888969556653364634257741272449493408203125e+00, // 0.750000
  3.88972016986742952227018577104900032281875610351562e+00, // 0.900000
  6.63835206799381172260154926334507763385772705078125e+00, // 0.990000
  9.23341347645158450063718191813677549362182617187500e+00, // 0.999000
  1.17563712224955398966130815097130835056304931640625e+01, // 0.999900
  };

  public static final double[] GNUR_GAMMA_QUANT_2_1 = { //
  1.42092376217774988417241743832164502236992120742798e-02, // 0.000100
  4.54020177694895721298706803281675092875957489013672e-02, // 0.001000
  1.48554740253265982197206085402285680174827575683594e-01, // 0.010000
  5.31811608389611945035824192018480971455574035644531e-01, // 0.100000
  9.61278763114777001774768905306700617074966430664062e-01, // 0.250000
  1.67834699001666054485326640133280307054519653320312e+00, // 0.500000
  2.69263452888969601062285619264002889394760131835938e+00, // 0.750000
  3.88972016986742952227018577104900032281875610351562e+00, // 0.900000
  6.63835206799381083442312956321984529495239257812500e+00, // 0.990000
  9.23341347645158450063718191813677549362182617187500e+00, // 0.999000
  1.17563712224955381202562421094626188278198242187500e+01, // 0.999900
  };

  public static final double[] SCIPY_GAMMA_QUANT_4_1 = { //
  2.31796895172818012698101597379718441516160964965820e-01, // 0.000100
  4.28552413628422945723883685786859132349491119384766e-01, // 0.001000
  8.23248686345385172202782086969818919897079467773438e-01, // 0.010000
  1.74476956282491135752366062661167234182357788085938e+00, // 0.100000
  2.53532021190009304589807470620144158601760864257812e+00, // 0.250000
  3.67206074885089650550185069732833653688430786132812e+00, // 0.500000
  5.10942748512337985289377684239298105239868164062500e+00, // 0.750000
  6.68078306825586487605050933780148625373840332031250e+00, // 0.900000
  1.00451175148316167451412184163928031921386718750000e+01, // 0.990000
  1.30622407791880714711396649363450706005096435546875e+01, // 0.999000
  1.59138140006312944763067207532003521919250488281250e+01, // 0.999900
  };

  public static final double[] GNUR_GAMMA_QUANT_4_1 = { //
  2.31796895172817957186950366121891420334577560424805e-01, // 0.000100
  4.28552413628423112257337379560340195894241333007812e-01, // 0.001000
  8.23248686345385172202782086969818919897079467773438e-01, // 0.010000
  1.74476956282491157956826555164298042654991149902344e+00, // 0.100000
  2.53532021190009304589807470620144158601760864257812e+00, // 0.250000
  3.67206074885089650550185069732833653688430786132812e+00, // 0.500000
  5.10942748512337896471535714226774871349334716796875e+00, // 0.750000
  6.68078306825586398787208963767625391483306884765625e+00, // 0.900000
  1.00451175148316149687843790161423385143280029296875e+01, // 0.990000
  1.30622407791880696947828255360946059226989746093750e+01, // 0.999000
  1.59138140006312944763067207532003521919250488281250e+01, // 0.999900
  };

  public static final double[] SCIPY_GAMMA_QUANT_4_10 = { //
  2.31796895172818040453677213008631952106952667236328e-02, // 0.000100
  4.28552413628423001235034917044686153531074523925781e-02, // 0.001000
  8.23248686345385283225084549485472962260246276855469e-02, // 0.010000
  1.74476956282491157956826555164298042654991149902344e-01, // 0.100000
  2.53532021190009337896498209374840371310710906982422e-01, // 0.250000
  3.67206074885089661652415315984399057924747467041016e-01, // 0.500000
  5.10942748512338007493838176742428913712501525878906e-01, // 0.750000
  6.68078306825586554218432411289541050791740417480469e-01, // 0.900000
  1.00451175148316163010520085663301870226860046386719e+00, // 0.990000
  1.30622407791880723593180846364703029394149780273438e+00, // 0.999000
  1.59138140006312944763067207532003521919250488281250e+00, // 0.999900
  };

  public static final double[] GNUR_GAMMA_QUANT_4_10 = { //
  2.31796895172817971064738173936348175629973411560059e-02, // 0.000100
  4.28552413628423140012912995189253706485033035278320e-02, // 0.001000
  8.23248686345385283225084549485472962260246276855469e-02, // 0.010000
  1.74476956282491157956826555164298042654991149902344e-01, // 0.100000
  2.53532021190009337896498209374840371310710906982422e-01, // 0.250000
  3.67206074885089661652415315984399057924747467041016e-01, // 0.500000
  5.10942748512337896471535714226774871349334716796875e-01, // 0.750000
  6.68078306825586443196129948773887008428573608398438e-01, // 0.900000
  1.00451175148316163010520085663301870226860046386719e+00, // 0.990000
  1.30622407791880701388720353861572220921516418457031e+00, // 0.999000
  1.59138140006312944763067207532003521919250488281250e+00, // 0.999900
  };

  public static final double[] SCIPY_GAMMA_QUANT_01_10 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000100
  0.00000000000000000000000000000000000000000000000000e+00, // 0.001000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.010000
  6.07304836274677903746487345757596094421304488975011e-12, // 0.100000
  5.79171329496954621446304020682127600139210699126124e-08, // 0.250000
  5.93391104460224945785218331195665086852386593818665e-05, // 0.500000
  3.53063580735582700775854192443148349411785602569580e-03, // 0.750000
  2.66154553738837257315097417631477583199739456176758e-02, // 0.900000
  1.58847781792950559776045338367111980915069580078125e-01, // 0.990000
  3.36367701171875421728429955692263320088386535644531e-01, // 0.999000
  5.31624347769055760615231065457919612526893615722656e-01, // 0.999900
  };

  public static final double[] GNUR_GAMMA_QUANT_01_10 = { //
  6.07304836240800246013734290758296395601191608171445e-42, // 0.000100
  6.07304836240794013868566283512457787341965380549669e-32, // 0.001000
  6.07304836240792099284182672275736116917595330090291e-22, // 0.010000
  6.07304836274317627815629288782017336338625579372774e-12, // 0.100000
  5.79171329496960180100020377028102736005621409276500e-08, // 0.250000
  5.93391104460226165512662377388153345236787572503090e-05, // 0.500000
  3.53063580735583307929070784325631393585354089736938e-03, // 0.750000
  2.66154553738837638954262132529038353823125362396240e-02, // 0.900000
  1.58847781792950504264894107109284959733486175537109e-01, // 0.990000
  3.36367701171875477239581186950090341269969940185547e-01, // 0.999000
  5.31624347769055760615231065457919612526893615722656e-01, // 0.999900
  };

  public static final double[] SCIPY_GAMMA_QUANT_01_20 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000100
  0.00000000000000000000000000000000000000000000000000e+00, // 0.001000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.010000
  3.03652418137338951873243672878798047210652244487505e-12, // 0.100000
  2.89585664748477310723152010341063800069605349563062e-08, // 0.250000
  2.96695552230112472892609165597832543426193296909332e-05, // 0.500000
  1.76531790367791350387927096221574174705892801284790e-03, // 0.750000
  1.33077276869418628657548708815738791599869728088379e-02, // 0.900000
  7.94238908964752798880226691835559904575347900390625e-02, // 0.990000
  1.68183850585937710864214977846131660044193267822266e-01, // 0.999000
  2.65812173884527880307615532728959806263446807861328e-01, // 0.999900
  };

  public static final double[] GNUR_GAMMA_QUANT_01_20 = { //
  3.03652418120400123006867145379148197800595804085722e-42, // 0.000100
  3.03652418120397006934283141756228893670982690274834e-32, // 0.001000
  3.03652418120396049642091336137868058458797665045146e-22, // 0.010000
  3.03652418137158813907814644391008668169312789686387e-12, // 0.100000
  2.89585664748480090050010188514051368002810704638250e-08, // 0.250000
  2.96695552230113082756331188694076672618393786251545e-05, // 0.500000
  1.76531790367791653964535392162815696792677044868469e-03, // 0.750000
  1.33077276869418819477131066264519176911562681198120e-02, // 0.900000
  7.94238908964752521324470535546424798667430877685547e-02, // 0.990000
  1.68183850585937738619790593475045170634984970092773e-01, // 0.999000
  2.65812173884527880307615532728959806263446807861328e-01, // 0.999900
  };

  public static final double[] SCIPY_GAMMA_QUANT_01_4 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000100
  0.00000000000000000000000000000000000000000000000000e+00, // 0.001000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.010000
  1.51826209068669467858686166976238136189225613748022e-11, // 0.100000
  1.44792832374238655361576005170531900034802674781531e-07, // 0.250000
  1.48347776115056236446304582798916271713096648454666e-04, // 0.500000
  8.82658951838956665203461682267516152933239936828613e-03, // 0.750000
  6.65386384347093073898804505006410181522369384765625e-02, // 0.900000
  3.97119454482376343928962114659952931106090545654297e-01, // 0.990000
  8.40919252929688498809923657972831279039382934570312e-01, // 0.999000
  1.32906086942263934602692643238697201013565063476562e+00, // 0.999900
  };

  public static final double[] GNUR_GAMMA_QUANT_01_4 = { //
  1.51826209060200048758698283629955882669254719901167e-41, // 0.000100
  1.51826209060198492519497318340481080243853975684947e-31, // 0.001000
  1.51826209060198020119068264779783997354452683633590e-21, // 0.010000
  1.51826209068579382720100313806021671836354869356001e-11, // 0.100000
  1.44792832374240031790115293408582886058866279199719e-07, // 0.250000
  1.48347776115056534601902016312635623762616887688637e-04, // 0.500000
  8.82658951838958226454590061393901123665273189544678e-03, // 0.750000
  6.65386384347094045343951052018383052200078964233398e-02, // 0.900000
  3.97119454482376232906659652144298888742923736572266e-01, // 0.990000
  8.40919252929688609832226120488485321402549743652344e-01, // 0.999000
  1.32906086942263934602692643238697201013565063476562e+00, // 0.999900
  };

  public static final double[] SCIPY_GAMMA_QUANT_01_1 = { //
  0.00000000000000000000000000000000000000000000000000e+00, // 0.000100
  0.00000000000000000000000000000000000000000000000000e+00, // 0.001000
  0.00000000000000000000000000000000000000000000000000e+00, // 0.010000
  6.07304836274677871434744667904952544756902454992087e-11, // 0.100000
  5.79171329496954621446304020682127600139210699126124e-07, // 0.250000
  5.93391104460224945785218331195665086852386593818665e-04, // 0.500000
  3.53063580735582666081384672907006461173295974731445e-02, // 0.750000
  2.66154553738837229559521802002564072608947753906250e-01, // 0.900000
  1.58847781792950537571584845863981172442436218261719e+00, // 0.990000
  3.36367701171875399523969463189132511615753173828125e+00, // 0.999000
  5.31624347769055738410770572954788804054260253906250e+00, // 0.999900
  };

  public static final double[] GNUR_GAMMA_QUANT_01_1 = { //
  6.07304836240800195034793134519823530677018879604667e-41, // 0.000100
  6.07304836240793970077989273361924320975415902739790e-31, // 0.001000
  6.07304836240792080476273059119135989417810734534360e-21, // 0.010000
  6.07304836274317530880401255224086687345419477424002e-11, // 0.100000
  5.79171329496960127160461173634331544235465116798878e-07, // 0.250000
  5.93391104460226138407608065250542495050467550754547e-04, // 0.500000
  3.53063580735583290581836024557560449466109275817871e-02, // 0.750000
  2.66154553738837618137580420807353220880031585693359e-01, // 0.900000
  1.58847781792950493162663860857719555497169494628906e+00, // 0.990000
  3.36367701171875443932890448195394128561019897460938e+00, // 0.999000
  5.31624347769055738410770572954788804054260253906250e+00, // 0.999900
  };

  @Test
  public void testPDF() {
    checkPDF(new GammaDistribution(1., 1.), P_CDFPDF, SCIPY_GAMMA_PDF_1_1, 1e-12);
    checkPDF(new GammaDistribution(2., 1.), P_CDFPDF, SCIPY_GAMMA_PDF_2_1, 1e-12);
    checkPDF(new GammaDistribution(4., 1.), P_CDFPDF, SCIPY_GAMMA_PDF_4_1, 1e-12);
    checkPDF(new GammaDistribution(4., 10), P_CDFPDF, SCIPY_GAMMA_PDF_4_10, 1e-13);
    checkPDF(new GammaDistribution(.1, 10), P_CDFPDF, SCIPY_GAMMA_PDF_01_10, 1e-11);
    checkPDF(new GammaDistribution(.1, 20), P_CDFPDF, SCIPY_GAMMA_PDF_01_20, 1e-14);
    checkPDF(new GammaDistribution(.1, 4.), P_CDFPDF, SCIPY_GAMMA_PDF_01_4, 1e-12);
    checkPDF(new GammaDistribution(.1, 1.), P_CDFPDF, SCIPY_GAMMA_PDF_01_1, 1e-12);
    checkPDF(new GammaDistribution(1., 1.), P_CDFPDF, GNUR_GAMMA_PDF_1_1, 1e-15);
    checkPDF(new GammaDistribution(2., 1.), P_CDFPDF, GNUR_GAMMA_PDF_2_1, 1e-16);
    checkPDF(new GammaDistribution(4., 1.), P_CDFPDF, GNUR_GAMMA_PDF_4_1, 1e-14);
    checkPDF(new GammaDistribution(4., 10), P_CDFPDF, GNUR_GAMMA_PDF_4_10, 1e-14);
    checkPDF(new GammaDistribution(.1, 10), P_CDFPDF, GNUR_GAMMA_PDF_01_10, 1e-15);
    checkPDF(new GammaDistribution(.1, 20), P_CDFPDF, GNUR_GAMMA_PDF_01_20, 1e-14);
    checkPDF(new GammaDistribution(.1, 4.), P_CDFPDF, GNUR_GAMMA_PDF_01_4, 1e-15);
    checkPDF(new GammaDistribution(.1, 1.), P_CDFPDF, GNUR_GAMMA_PDF_01_1, 1e-15);
  }

  @Test
  public void testCDF() {
    checkCDF(new GammaDistribution(1., 1.), P_CDFPDF, SCIPY_GAMMA_CDF_1_1, 1e-13);
    checkCDF(new GammaDistribution(2., 1.), P_CDFPDF, SCIPY_GAMMA_CDF_2_1, 1e-12);
    checkCDF(new GammaDistribution(4., 1.), P_CDFPDF, SCIPY_GAMMA_CDF_4_1, 1e-12);
    checkCDF(new GammaDistribution(4., 10), P_CDFPDF, SCIPY_GAMMA_CDF_4_10, 1e-12);
    checkCDF(new GammaDistribution(.1, 10), P_CDFPDF, SCIPY_GAMMA_CDF_01_10, 1e-14);
    checkCDF(new GammaDistribution(.1, 20), P_CDFPDF, SCIPY_GAMMA_CDF_01_20, 1e-15);
    checkCDF(new GammaDistribution(.1, 4.), P_CDFPDF, SCIPY_GAMMA_CDF_01_4, 1e-13);
    checkCDF(new GammaDistribution(.1, 1.), P_CDFPDF, SCIPY_GAMMA_CDF_01_1, 1e-13);
    checkCDF(new GammaDistribution(1., 1.), P_CDFPDF, GNUR_GAMMA_CDF_1_1, 1e-15);
    checkCDF(new GammaDistribution(2., 1.), P_CDFPDF, GNUR_GAMMA_CDF_2_1, 1e-15);
    checkCDF(new GammaDistribution(4., 1.), P_CDFPDF, GNUR_GAMMA_CDF_4_1, 1e-14);
    checkCDF(new GammaDistribution(4., 10), P_CDFPDF, GNUR_GAMMA_CDF_4_10, 1e-15);
    checkCDF(new GammaDistribution(.1, 10), P_CDFPDF, GNUR_GAMMA_CDF_01_10, 1e-15);
    checkCDF(new GammaDistribution(.1, 20), P_CDFPDF, GNUR_GAMMA_CDF_01_20, 1e-15);
    checkCDF(new GammaDistribution(.1, 4.), P_CDFPDF, GNUR_GAMMA_CDF_01_4, 1e-15);
    checkCDF(new GammaDistribution(.1, 1.), P_CDFPDF, GNUR_GAMMA_CDF_01_1, 1e-15);
  }

  @Test
  public void testProbit() {
    checkQuantile(new GammaDistribution(1., 1.), P_QUANT, SCIPY_GAMMA_QUANT_1_1, 1e-14);
    checkQuantile(new GammaDistribution(2., 1.), P_QUANT, SCIPY_GAMMA_QUANT_2_1, 1e-13);
    checkQuantile(new GammaDistribution(4., 1.), P_QUANT, SCIPY_GAMMA_QUANT_4_1, 1e-13);
    checkQuantile(new GammaDistribution(4., 10), P_QUANT, SCIPY_GAMMA_QUANT_4_10, 1e-13);
    checkQuantile(new GammaDistribution(.1, 10), P_QUANT, SCIPY_GAMMA_QUANT_01_10, 1e-13);
    checkQuantile(new GammaDistribution(.1, 20), P_QUANT, SCIPY_GAMMA_QUANT_01_20, 1e-14);
    checkQuantile(new GammaDistribution(.1, 4.), P_QUANT, SCIPY_GAMMA_QUANT_01_4, 1e-13);
    checkQuantile(new GammaDistribution(.1, 1.), P_QUANT, SCIPY_GAMMA_QUANT_01_1, 1e-13);
    checkQuantile(new GammaDistribution(1., 1.), P_QUANT, GNUR_GAMMA_QUANT_1_1, 1e-14);
    checkQuantile(new GammaDistribution(2., 1.), P_QUANT, GNUR_GAMMA_QUANT_2_1, 1e-13);
    checkQuantile(new GammaDistribution(4., 1.), P_QUANT, GNUR_GAMMA_QUANT_4_1, 1e-13);
    checkQuantile(new GammaDistribution(4., 10), P_QUANT, GNUR_GAMMA_QUANT_4_10, 1e-13);
    checkQuantile(new GammaDistribution(.1, 10), P_QUANT, GNUR_GAMMA_QUANT_01_10, 1e-13);
    checkQuantile(new GammaDistribution(.1, 20), P_QUANT, GNUR_GAMMA_QUANT_01_20, 1e-14);
    checkQuantile(new GammaDistribution(.1, 4.), P_QUANT, GNUR_GAMMA_QUANT_01_4, 1e-13);
    checkQuantile(new GammaDistribution(.1, 1.), P_QUANT, GNUR_GAMMA_QUANT_01_1, 1e-13);
  }

  @Test
  public void testRandomAndEstimation() {
    GammaDistribution g = new GammaDistribution(1.2345, 0.12345, new Random(0));
    double[] data = new double[10000];
    for (int i = 0; i < data.length; i++) {
      data[i] = g.nextRandom();
    }
    GammaDistribution g2 = GammaDistribution.CHOI_WETTE_ESTIMATOR.estimate(data, ArrayLikeUtil.DOUBLEARRAYADAPTER);
    assertEquals("k does not match.", g.getK(), g2.getK(), 1E-2);
    assertEquals("theta does not match.", g.getTheta(), g2.getTheta(), 1E-5);
  }

  @Test
  public void extremeValues() {
    // TODO: tested values
    GammaDistribution dist = new GammaDistribution(1.1987906546993674E12, 1.1987905236089673E12);
    assertEquals(0.0, dist.cdf(Double.MIN_VALUE), 1e-50);
    // FIXME: NEITHER OF THESE VALUE IS NOT VERIFIED.
    // THIS IS SOLELY A REGRESSION TEST.
    // assertEquals(0.45430463189141745, dist.cdf(1.0), 1e-15);
    assertEquals(3.6332619726763034E-5, dist.cdf(1.0), 1e-15);
  }
}
