//package uk.ac.manchester.cs.chainsaw;
//
//import java.util.*;
//
//import org.semanticweb.owlapi.apibinding.OWLManager;
//import org.semanticweb.owlapi.model.*;
//import org.semanticweb.owlapi.profiles.*;
//import org.semanticweb.owlapi.reasoner.*;
//import org.semanticweb.owlapi.reasoner.impl.*;
//import org.semanticweb.owlapi.util.MultiMap;
//import org.semanticweb.owlapi.util.Version;
//import org.semanticweb.owlapi.vocab.OWL2Datatype;
//
//import edu.arizona.bio5.onto.decomposition.Atom;
//import edu.arizona.bio5.onto.decomposition.SignatureLabel;
//
//import uk.ac.manchester.cs.atomicdecomposition.nativeimpl.AtomicDecomposerNativeImpl;
//import uk.ac.manchester.cs.demost.ui.adextension.ExtendedAtom;
//import uk.ac.manchester.cs.owlapi.modularity.ModuleType;
//import uk.ac.manchester.cs.owlapi.modularity.SyntacticLocalityModuleExtractor;
//
//public class CopyOfChainsawReasoner implements OWLReasoner, OWLOntologyChangeListener {
//	enum PapillonType {
//		TOP, BOTTOM, ALL
//	}
//
//	private final OWLOntology rootOntology;
//	private OWLReasonerFactory delegateFactory;
//	private final OWLDataFactory df = OWLManager.getOWLDataFactory();
//	private final OWLReasonerConfiguration config;
//	private AtomicDecomposerNativeImpl ad;
//	private final ArrayIntMap topCone = new ArrayIntMap();
//	private final ArrayIntMap bottomCone = new ArrayIntMap();
//	private final MultiMap<OWLClass, Node<OWLClass>> subClassCache = new MultiMap<OWLClass, Node<OWLClass>>();
//	private final MultiMap<OWLClass, Node<OWLClass>> superClassCache = new MultiMap<OWLClass, Node<OWLClass>>();
//	private final Map<OWLClass, Node<OWLClass>> equivalentClassCache = new HashMap<OWLClass, Node<OWLClass>>();
//	private final List<OWLAxiom> axiomsList = new ArrayList<OWLAxiom>();
//	private final List<OWLEntity> entityList = new ArrayList<OWLEntity>();
//	Map<OWLEntity, Integer> temp = new HashMap<OWLEntity, Integer>();
//	Map<OWLAxiom, Integer> tempAxiom = new HashMap<OWLAxiom, Integer>();
//	private SyntacticLocalityModuleExtractor extractor;
//
//	public CopyOfChainsawReasoner(OWLReasonerFactory f, OWLOntology o,
//			OWLReasonerConfiguration config) {
//		this.rootOntology = o;
//		Set<OWLAxiom> axioms = new HashSet<OWLAxiom>();
//		for (OWLOntology ont : rootOntology.getImportsClosure()) {
//			for(OWLAxiom ax:ont.getAxioms()) {
//			axioms.add(ax.getAxiomWithoutAnnotations());
//			}
//		}
//		axiomsList.addAll(axioms);
//		entityList.addAll(rootOntology.getSignature(true));
//		for (int i = 0; i < entityList.size(); i++) {
//			temp.put(entityList.get(i), i);
//		}
//		for (int i = 0; i < axiomsList.size(); i++) {
//			tempAxiom.put(axiomsList.get(i), i);
//		}
//		this.delegateFactory = f;
//		this.config = config;
//		extractor = new SyntacticLocalityModuleExtractor(o.getOWLOntologyManager(), o,
//				ModuleType.BOT);
//		initAtomicDecomposition();
//	}
//
//	class MapEntry<K, V> {
//		private K k;
//		V v;
//
//		public MapEntry(K key, V value) {
//			k = key;
//			v = value;
//		}
//
//		public K getKey() {
//			return k;
//		}
//
//		public V getValue() {
//			return v;
//		}
//	}
//
//	private final List<OWLDeclarationAxiom> declarations = new ArrayList<OWLDeclarationAxiom>();
//
//	private void initAtomicDecomposition() {
//		declarations.clear();
//		Set<OWLEntity> entities = new HashSet<OWLEntity>();
//		for (OWLEntity e : entityList) {
//			if (!e.isBuiltIn() && !e.isOWLNamedIndividual()) {
//				//declarations.add(df.getOWLDeclarationAxiom(e));
//				entities.add(e);
//				//	System.out.println("ChainsawReasoner.initAtomicDecomposition() " + e);
//			}
//		}
//		topCone.clear();
//		bottomCone.clear();
//		this.ad = new AtomicDecomposerNativeImpl(rootOntology, ModuleType.BOT);
//		for (Atom atom : ad.getAtoms()) {
//			Set<OWLEntity> signature = computeSignature(atom);
//			entities.removeAll(signature);
//			computeLabel(atom, signature);
//			for (OWLAxiom ax : atom.getAxioms()) {
//				for (OWLEntity e : signature) {
//					bottomCone.put(temp.get(e), tempAxiom.get(ax));
//					topCone.put(temp.get(e), tempAxiom.get(ax));
//				}
//			}
//			//			List<OWLAxiom> axiomsToCache = new ArrayList<OWLAxiom>(atom.getAxioms());
//			for (Atom d : ad.getDependencies(atom)) {
//				for (OWLAxiom ax : d.getAxioms()) {
//					for (OWLEntity e : signature) {
//						bottomCone.put(temp.get(e), tempAxiom.get(ax));
//					}
//				}
//				//				axiomsToCache.addAll(d.getAxioms());
//			}
//			//			for (OWLEntity e : signature) {
//			//				bottomCone.putAll(e, axiomsToCache);
//			//			}
//			for (Atom d : ad.getDependents(atom)) {
//				for (OWLAxiom ax : d.getAxioms()) {
//					for (OWLEntity e : signature) {
//						topCone.put(temp.get(e), tempAxiom.get(ax));
//					}
//				}
//			}
//			//			axiomsToCache = new ArrayList<OWLAxiom>(atom.getAxioms());
//			//			for (Atom d : ad.getDependents(atom)) {
//			//				axiomsToCache.addAll(d.getAxioms());
//			//			}
//			//			for (OWLEntity e : signature) {
//			//				topCone.putAll(e, axiomsToCache);
//			//			}
//		}
//		List<MapEntry<OWLClass, FastSet>> halfPapillons = new ArrayList<MapEntry<OWLClass, FastSet>>();
//		for (int i : topCone.keySet()) {
//			OWLEntity e = entityList.get(i);
//			if (e.isOWLClass()) {
//				halfPapillons.add(new MapEntry<OWLClass, FastSet>(e.asOWLClass(), topCone
//						.get(i)));
//			}
//		}
//		Collections.sort(halfPapillons, new Comparator<MapEntry<?, FastSet>>() {
//			public int compare(MapEntry<?, FastSet> o1, MapEntry<?, FastSet> o2) {
//				return o2.getValue().size() - o1.getValue().size();
//			}
//		});
//		Set<Node<OWLClass>> done = new HashSet<Node<OWLClass>>();
//		for (MapEntry<OWLClass, FastSet> ax : halfPapillons) {
//			System.out.println("ChainsawReasoner.initAtomicDecomposition() "+ax.getKey());
//			final OWLClass key = ax.getKey();
//			//if (!done.contains(key)) {
//				Set<OWLAxiom> set = asSet(ax.getValue());
//				System.out.println("ChainsawReasoner.initAtomicDecomposition() axioms: "+set.size());
//				OWLReasoner r = getDelegate(set);
//				iterate(r, done, cachedEquivalentClasses(r, key));
//			//}
//		}
//		List<OWLClass> roots = new ArrayList<OWLClass>();
//		for (MapEntry<OWLClass, FastSet> ax : halfPapillons) {
//			if (!superClassCache.containsKey(ax.getKey())) {
//				roots.add(ax.getKey());
//			}
//		}
//		final Node<OWLClass> top = getEquivalentClasses(df.getOWLThing());
//		for (OWLEntity e : entities) {
//			declarations.add(df.getOWLDeclarationAxiom(e));
//			if (e.isOWLClass()) {
//				final OWLClassNode value = new OWLClassNode(e.asOWLClass());
//				subClassCache.put(df.getOWLThing(), value);
//				superClassCache.put(df.getOWLNothing(), value);
//			}
//		}
//		for (OWLClass e : roots) {
//			final Node<OWLClass> equivalentClasses = cachedEquivalentClasses(
//					getDelegate(buildPapillon(PapillonType.BOTTOM, e)), e);
//			subClassCache.put(df.getOWLThing(), equivalentClasses);
//			for (OWLClass eq : equivalentClasses) {
//				superClassCache.put(eq, top);
//			}
//		}
//		//		for (OWLAxiom ax : rootOntology.getAxioms(AxiomType.DISJOINT_CLASSES, true)) {
//		//			for (OWLEntity e : ax.getSignature()) {
//		//				if (!topCone.get(e).contains(ax)) {
//		//					System.out.println("topcone " + ax
//		//							+ "\tnot found for "+e);
//		//				}
//		//				if (!bottomCone.get(e).contains(ax)) {
//		//					System.out.println("bottomcone " + ax
//		//							+ "\tnot found for "+e);
//		//				}
//		//
//		//			}
//		//		}
//	}
//
//	public Set<OWLAxiom> asSet(FastSet ax) {
//		Set<OWLAxiom> set = new HashSet<OWLAxiom>();
//		for (int i = 0; i < ax.size(); i++) {
//			set.add(axiomsList.get(ax.get(i)));
//		}
//		return set;
//	}
//
//	public Set<OWLEntity> computeSignature(Atom atom) {
//		Set<OWLEntity> signature = new HashSet<OWLEntity>();
//		for (OWLAxiom ax : atom.getAllAxioms()) {
//			signature.addAll(ax.getSignature());
//		}
//		List<OWLEntity> toRemove = new ArrayList<OWLEntity>();
//		for (OWLEntity e : signature) {
//			if (e.isBuiltIn()) {
//				toRemove.add(e);
//			}
//		}
//		signature.removeAll(toRemove);
//		return signature;
//	}
//
//	private void computeLabel(Atom atom, Set<OWLEntity> signature) {
//		Iterator<Atom> dependencies = ad.getDependencies(atom).iterator();
//		Set<OWLEntity> labelSignature = new HashSet<OWLEntity>(signature);
//		while (labelSignature.size() > 0 && dependencies.hasNext()) {
//			ExtendedAtom a = (ExtendedAtom) dependencies.next();
//			if (!a.equals(atom)) {
//				labelSignature.removeAll(a.getSignature());
//			}
//		}
//		atom.setLabel(new SignatureLabel(labelSignature));
//	}
//
//	private void iterate(OWLReasoner r, Set<Node<OWLClass>> done, Node<OWLClass> node) {
//		OWLClass key = node.getEntities().iterator().next();
//		if (!done.contains(node)) {
//			done.add(node);
//			// = cachedEquivalentClasses(r, key);
//			if(key==null) {
//				System.out.println("ChainsawReasoner.iterate() strange!");
//				return;
//			}
//			NodeSet<OWLClass> subClasses = r.getSubClasses(key, true);
//			for (Node<OWLClass> sub : subClasses.getNodes()) {
//				subClassCache.put(key, sub);
//				final Set<OWLClass> entities = sub.getEntities();
//				for (OWLClass subClass : entities) {
//					superClassCache.put(subClass, node);
//
//				}
//				if(!entities.isEmpty()) {
//				iterate(r, done, sub);
//				}else {
//					System.out.println("ChainsawReasoner.iterate() funny!");
//				}
//			}
//		}
//	}
//
//	private Node<OWLClass> cachedEquivalentClasses(OWLReasoner r, OWLClass key) {
//		Node<OWLClass> node = equivalentClassCache.get(key);
//		if (node == null) {
//			node = r.getEquivalentClasses(key);
//			System.out.println("ChainsawReasoner.equivalent "+key);
//			for (OWLClass c : node.getEntities()) {
//				equivalentClassCache.put(c, node);
//			}
//		}
//		return node;
//	}
//
//	public String getReasonerName() {
//		return "Chainsaw";
//	}
//
//	public Version getReasonerVersion() {
//		return new Version(0, 1, 0, 0);
//	}
//
//	public BufferingMode getBufferingMode() {
//		return BufferingMode.BUFFERING;
//	}
//
//	public void flush() {
//		initAtomicDecomposition();
//		nextChanges.clear();
//	}
//
//	private final List<OWLOntologyChange> nextChanges = new ArrayList<OWLOntologyChange>();
//
//	public void ontologiesChanged(List<? extends OWLOntologyChange> changes)
//			throws OWLException {
//		nextChanges.addAll(changes);
//	}
//
//	public List<OWLOntologyChange> getPendingChanges() {
//		return new ArrayList<OWLOntologyChange>(nextChanges);
//	}
//
//	public Set<OWLAxiom> getPendingAxiomAdditions() {
//		Set<OWLAxiom> added = new HashSet<OWLAxiom>();
//		for (OWLOntologyChange c : nextChanges) {
//			if (c instanceof AddAxiom) {
//				added.add(c.getAxiom());
//			}
//		}
//		return added;
//	}
//
//	public static void main(String[] args) {}
//
//	public Set<OWLAxiom> getPendingAxiomRemovals() {
//		Set<OWLAxiom> added = new HashSet<OWLAxiom>();
//		for (OWLOntologyChange c : nextChanges) {
//			if (c instanceof RemoveAxiom) {
//				added.add(c.getAxiom());
//			}
//		}
//		return added;
//	}
//
//	public OWLOntology getRootOntology() {
//		return rootOntology;
//	}
//
//	public void interrupt() {
//		// TODO Auto-generated method stub
//	}
//
//	@SuppressWarnings("unused")
//	public void precomputeInferences(InferenceType... inferenceTypes)
//			throws ReasonerInterruptedException, TimeOutException,
//			InconsistentOntologyException {
//		// nothing in this implementation
//	}
//
//	@SuppressWarnings("unused")
//	public boolean isPrecomputed(InferenceType inferenceType) {
//		return false;
//	}
//
//	public Set<InferenceType> getPrecomputableInferenceTypes() {
//		return Collections.emptySet();
//	}
//
//	public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
//		return getDelegate(new HashSet<OWLAxiom>(axiomsList), false).isConsistent();
//	}
//
//	public boolean isSatisfiable(OWLClassExpression classExpression)
//			throws ReasonerInterruptedException, TimeOutException,
//			ClassExpressionNotInProfileException, FreshEntitiesException,
//			InconsistentOntologyException {
//		return getDelegate(
//				buildPapillon(PapillonType.BOTTOM, classExpression.getSignature()))
//				.isSatisfiable(classExpression);
//	}
//
//	private Set<OWLAxiom> buildPapillon(PapillonType type, OWLEntity... signature) {
//		return buildPapillon(type, Arrays.asList(signature));
//	}
//
//	private Set<OWLAxiom> buildPapillon(PapillonType type,
//			Collection<? extends OWLEntity> signature) {
//		try {
//			Set<OWLAxiom> toReturn = new HashSet<OWLAxiom>();
//			for (OWLEntity e : signature) {
//				if (temp.containsKey(e)) {
//					if (type == PapillonType.TOP || type == PapillonType.ALL) {
//						toReturn.addAll(asSet(topCone.get(temp.get(e))));
//					}
//					if (type == PapillonType.BOTTOM || type == PapillonType.ALL) {
//						toReturn.addAll(asSet(bottomCone.get(temp.get(e))));
//					}
//				} else {
//					// fresh entity or owl:thing or similar. Skip
//				}
//			}
//			toReturn.addAll(declarations);
//			return toReturn;
//		} catch (NullPointerException e) {
//			System.out.println("ChainsawReasoner.buildPapillon() null");
//			e.printStackTrace();
//			throw e;
//		}
//	}
//
//	private final int max = 20;
//	private final LinkedHashMap<Set<OWLAxiom>, OWLReasoner> reasonersHardCache = new LinkedHashMap<Set<OWLAxiom>, OWLReasoner>() {
//		protected boolean removeEldestEntry(
//				Map.Entry<java.util.Set<OWLAxiom>, OWLReasoner> eldest) {
//			if (size() > max) {
//				eldest.getValue().dispose();
//				return true;
//			}
//			return false;
//		}
//	};
//	private final LinkedHashMap<Set<OWLEntity>, Set<OWLAxiom>> modulesCache = new LinkedHashMap<Set<OWLEntity>, Set<OWLAxiom>>() {
//		protected boolean removeEldestEntry(
//				Map.Entry<Set<OWLEntity>, Set<OWLAxiom>> eldest) {
//			if (size() > max) {
//				return true;
//			}
//			return false;
//		}
//	};
//
//	private OWLReasoner getDelegate(Set<OWLAxiom> axioms) {
//		return getDelegate(axioms, true);
//	}
//
//	private void verify(OWLOntology o) {
//		OWL2DLProfile profile = new OWL2DLProfile();
//		OWLProfileReport report = profile.checkOntology(o);
//		for (OWLProfileViolation v : report.getViolations()) {
//			System.out.println(v);
//		}
//	}
//
//	private OWLReasoner getDelegate(Set<OWLAxiom> axioms, boolean precompute) {
//		if (axioms.isEmpty()) {}
//		OWLReasoner reasoner = reasonersHardCache.get(axioms);
//		try {
//			if (reasoner == null) {
//				//				System.out.println("KnowledgeExplorerGraph.getReasoner() cache miss");
//				final OWLOntologyManager m = OWLManager.createOWLOntologyManager();
//				OWLOntology temp = m.createOntology(axioms);
//				//verify(temp);
//				reasoner = delegateFactory.createReasoner(temp, config);
//				reasonersHardCache.put(axioms, reasoner);
//			}
//			return reasoner;
//		} catch (OWLOntologyCreationException e) {
//			throw new RuntimeException("Cannot create the ontology", e);
//		}
//	}
//
//	private Set<OWLAxiom> getModule(Set<OWLEntity> sig) {
//		Set<OWLAxiom> module = modulesCache.get(sig);
//		if (module == null) {
//			module = extractor.extract(sig);
//			modulesCache.put(sig, module);
//		}
//		return module;
//	}
//
//	public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException,
//			TimeOutException, InconsistentOntologyException {
//		return getBottomClassNode();
//	}
//
//	public boolean isEntailed(OWLAxiom axiom) throws ReasonerInterruptedException,
//			UnsupportedEntailmentTypeException, TimeOutException,
//			AxiomNotInProfileException, FreshEntitiesException,
//			InconsistentOntologyException {
//		return getDelegate(getModule(axiom.getSignature())).isEntailed(axiom);
//	}
//
//	public boolean isEntailed(Set<? extends OWLAxiom> axioms)
//			throws ReasonerInterruptedException, UnsupportedEntailmentTypeException,
//			TimeOutException, AxiomNotInProfileException, FreshEntitiesException,
//			InconsistentOntologyException {
//		// TODO investigate a tradeoff on grouping the axioms together
//		for (OWLAxiom ax : axioms) {
//			if (!isEntailed(ax)) {
//				return false;
//			}
//		}
//		return true;
//	}
//
//	@SuppressWarnings("unused")
//	public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
//		return true;
//	}
//
//	public Node<OWLClass> getTopClassNode() {
//		return getEquivalentClasses(df.getOWLThing());
//	}
//
//	public Node<OWLClass> getBottomClassNode() {
//		return getEquivalentClasses(df.getOWLNothing());
//	}
//
//	public OWLClassNodeSet assembleNodeSet(boolean direct, OWLClass root,
//			MultiMap<OWLClass, Node<OWLClass>> map) {
//		List<Node<OWLClass>> list = new ArrayList<Node<OWLClass>>();
//		list.addAll(map.get(root));
//		if (!direct) {
//			Set<OWLClass> done = new HashSet<OWLClass>();
//			done.add(root);
//			for (int i = 0; i < list.size(); i++) {
//				for (OWLClass c : list.get(i).getEntities()) {
//					if (!done.contains(c)) {
//						done.add(c);
//						list.addAll(map.get(c));
//					}
//				}
//			}
//		}
//		return new OWLClassNodeSet(new HashSet<Node<OWLClass>>(list));
//	}
//
//	public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct)
//			throws ReasonerInterruptedException, TimeOutException,
//			FreshEntitiesException, InconsistentOntologyException,
//			ClassExpressionNotInProfileException {
//		if (ce.isBottomEntity()) {
//			return new OWLClassNodeSet();
//		}
//		if (!ce.isAnonymous()) {
//			NodeSet<OWLClass> toReturn = assembleNodeSet(direct, ce.asOWLClass(),
//					subClassCache);
//			if (!toReturn.isEmpty()) {
//				return toReturn;
//			}
//		}
//		return getDelegate(buildPapillon(PapillonType.TOP, ce.getSignature()))
//				.getSubClasses(ce, direct);
//	}
//
//	public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct)
//			throws InconsistentOntologyException, ClassExpressionNotInProfileException,
//			FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
//		if (ce.isTopEntity()) {
//			return new OWLClassNodeSet();
//		}
//		if (!ce.isAnonymous()) {
//			NodeSet<OWLClass> toReturn = assembleNodeSet(direct, ce.asOWLClass(),
//					superClassCache);
//			if (!toReturn.isEmpty()) {
//				return toReturn;
//			}
//		}
//		return getDelegate(buildPapillon(PapillonType.BOTTOM, ce.getSignature()))
//				.getSuperClasses(ce, direct);
//	}
//
//	public Node<OWLClass> getEquivalentClasses(OWLClassExpression ce)
//			throws InconsistentOntologyException, ClassExpressionNotInProfileException,
//			FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
//		if (!ce.isAnonymous()) {
//			Node<OWLClass> toReturn = equivalentClassCache.get(ce.asOWLClass());
//			if (toReturn != null) {
//				return toReturn;
//			}
//		}
//		return getDelegate(buildPapillon(PapillonType.BOTTOM, ce.getSignature()))
//				.getEquivalentClasses(ce);
//	}
//
//	public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression ce)
//			throws ReasonerInterruptedException, TimeOutException,
//			FreshEntitiesException, InconsistentOntologyException {
//		Set<OWLEntity> sig = new HashSet<OWLEntity>(ce.getSignature());
//		Set<OWLEntity> newsig = new HashSet<OWLEntity>();
//		NodeSet<OWLClass> disjointClasses;
//		do {
//			newsig.addAll(sig);
//			disjointClasses = getDelegate(buildPapillon(PapillonType.ALL, sig))
//					.getDisjointClasses(ce);
//			sig.addAll(disjointClasses.getFlattened());
//		} while (!sig.equals(newsig));
//		return disjointClasses;
//	}
//
//	public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
//		return getEquivalentObjectProperties(df.getOWLTopObjectProperty());
//	}
//
//	public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
//		return getEquivalentObjectProperties(df.getOWLBottomObjectProperty());
//	}
//
//	public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(
//			OWLObjectPropertyExpression pe, boolean direct)
//			throws InconsistentOntologyException, FreshEntitiesException,
//			ReasonerInterruptedException, TimeOutException {
//		return getDelegate(buildPapillon(PapillonType.ALL, pe.getSignature()))
//				.getSubObjectProperties(pe, direct);
//	}
//
//	public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(
//			OWLObjectPropertyExpression pe, boolean direct)
//			throws InconsistentOntologyException, FreshEntitiesException,
//			ReasonerInterruptedException, TimeOutException {
//		return getDelegate(buildPapillon(PapillonType.ALL, pe.getSignature()))
//				.getSuperObjectProperties(pe, direct);
//	}
//
//	public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(
//			OWLObjectPropertyExpression pe) throws InconsistentOntologyException,
//			FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
//		return getDelegate(buildPapillon(PapillonType.ALL, pe.getSignature()))
//				.getEquivalentObjectProperties(pe);
//	}
//
//	public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(
//			OWLObjectPropertyExpression pe) throws InconsistentOntologyException,
//			FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
//		return getDelegate(buildPapillon(PapillonType.ALL, pe.getSignature()))
//				.getDisjointObjectProperties(pe);
//	}
//
//	public Node<OWLObjectPropertyExpression> getInverseObjectProperties(
//			OWLObjectPropertyExpression pe) throws InconsistentOntologyException,
//			FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
//		return getDelegate(buildPapillon(PapillonType.ALL, pe.getSignature()))
//				.getInverseObjectProperties(pe);
//	}
//
//	public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe,
//			boolean direct) throws InconsistentOntologyException, FreshEntitiesException,
//			ReasonerInterruptedException, TimeOutException {
//		Set<OWLEntity> sig = new HashSet<OWLEntity>(pe.getSignature());
//		Set<OWLEntity> newsig = new HashSet<OWLEntity>();
//		NodeSet<OWLClass> toReturn;
//		do {
//			newsig.addAll(sig);
//			toReturn = getDelegate(buildPapillon(PapillonType.ALL, sig))
//					.getObjectPropertyDomains(pe, direct);
//			sig.addAll(toReturn.getFlattened());
//		} while (!sig.equals(newsig));
//		return toReturn;
//	}
//
//	public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe,
//			boolean direct) throws InconsistentOntologyException, FreshEntitiesException,
//			ReasonerInterruptedException, TimeOutException {
//		Set<OWLEntity> sig = new HashSet<OWLEntity>(pe.getSignature());
//		Set<OWLEntity> newsig = new HashSet<OWLEntity>();
//		NodeSet<OWLClass> toReturn;
//		do {
//			newsig.addAll(sig);
//			toReturn = getDelegate(buildPapillon(PapillonType.ALL, sig))
//					.getObjectPropertyRanges(pe, direct);
//			sig.addAll(toReturn.getFlattened());
//		} while (!sig.equals(newsig));
//		return toReturn;
//	}
//
//	public Node<OWLDataProperty> getTopDataPropertyNode() {
//		OWLDataPropertyNode toReturn = new OWLDataPropertyNode();
//		toReturn.add(df.getOWLTopDataProperty());
//		return toReturn;
//	}
//
//	public Node<OWLDataProperty> getBottomDataPropertyNode() {
//		return getEquivalentDataProperties(df.getOWLBottomDataProperty());
//	}
//
//	public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe,
//			boolean direct) throws InconsistentOntologyException, FreshEntitiesException,
//			ReasonerInterruptedException, TimeOutException {
//		return getDelegate(buildPapillon(PapillonType.ALL, pe.getSignature()))
//				.getSubDataProperties(pe, direct);
//	}
//
//	public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe,
//			boolean direct) throws InconsistentOntologyException, FreshEntitiesException,
//			ReasonerInterruptedException, TimeOutException {
//		return getDelegate(buildPapillon(PapillonType.ALL, pe.getSignature()))
//				.getSuperDataProperties(pe, direct);
//	}
//
//	public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty pe)
//			throws InconsistentOntologyException, FreshEntitiesException,
//			ReasonerInterruptedException, TimeOutException {
//		return getDelegate(buildPapillon(PapillonType.ALL, pe.getSignature()))
//				.getEquivalentDataProperties(pe);
//	}
//
//	public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression pe)
//			throws InconsistentOntologyException, FreshEntitiesException,
//			ReasonerInterruptedException, TimeOutException {
//		return getDelegate(buildPapillon(PapillonType.ALL, pe.getSignature()))
//				.getDisjointDataProperties(pe);
//	}
//
//	public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, boolean direct)
//			throws InconsistentOntologyException, FreshEntitiesException,
//			ReasonerInterruptedException, TimeOutException {
//		Set<OWLEntity> sig = new HashSet<OWLEntity>(pe.getSignature());
//		Set<OWLEntity> newsig = new HashSet<OWLEntity>();
//		NodeSet<OWLClass> toReturn;
//		do {
//			newsig.addAll(sig);
//			toReturn = getDelegate(buildPapillon(PapillonType.ALL, sig))
//					.getDataPropertyDomains(pe, direct);
//			sig.addAll(toReturn.getFlattened());
//		} while (!sig.equals(newsig));
//		return toReturn;
//	}
//
//	public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct)
//			throws InconsistentOntologyException, FreshEntitiesException,
//			ReasonerInterruptedException, TimeOutException {
//		final Set<OWLAxiom> buildPapillon = buildPapillon(PapillonType.ALL,
//				ind.getSignature());
//		//		System.out.println("ChainsawReasoner.getTypes() " + ind + "\t" + direct);
//		//		for (OWLAxiom ax : buildPapillon) {
//		//			System.out.println("ChainsawReasoner.getTypes() " + ax);
//		//		}
//		//		for (OWLOntology o : rootOntology.getImportsClosure()) {
//		//			for (OWLAxiom a : o.getAxioms()) {
//		//				if (a.getSignature().containsAll(ind.getSignature())) {
//		//					System.out.println("def: " + a);
//		//				}
//		//			}
//		//		}
//		return getDelegate(buildPapillon).getTypes(ind, direct);
//	}
//
//	public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct)
//			throws InconsistentOntologyException, ClassExpressionNotInProfileException,
//			FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
//		if (ce.isTopEntity()) {
//			Set<Node<OWLNamedIndividual>> set = new HashSet<Node<OWLNamedIndividual>>();
//			for (OWLNamedIndividual n : rootOntology.getIndividualsInSignature(true)) {
//				set.add(new OWLNamedIndividualNode(n));
//			}
//			return new OWLNamedIndividualNodeSet(set);
//		}
//		if (ce.isBottomEntity()) {
//			return new OWLNamedIndividualNodeSet();
//		}
//		return getDelegate(buildPapillon(PapillonType.BOTTOM, ce.getSignature()))
//				.getInstances(ce, direct);
//	}
//
//	public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual ind,
//			OWLObjectPropertyExpression pe) throws InconsistentOntologyException,
//			FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
//		Set<OWLAxiom> props = buildPapillon(PapillonType.ALL, pe.getSignature());
//		props.addAll(buildPapillon(PapillonType.ALL, ind.getSignature()));
//		return getDelegate(props).getObjectPropertyValues(ind, pe);
//	}
//
//	public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual ind,
//			OWLDataProperty pe) throws InconsistentOntologyException,
//			FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
//		Set<OWLAxiom> props = buildPapillon(PapillonType.ALL, pe.getSignature());
//		props.addAll(buildPapillon(PapillonType.ALL, ind.getSignature()));
//		return getDelegate(props).getDataPropertyValues(ind, pe);
//	}
//
//	public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual ind)
//			throws InconsistentOntologyException, FreshEntitiesException,
//			ReasonerInterruptedException, TimeOutException {
//		return getDelegate(buildPapillon(PapillonType.ALL, ind.getSignature()))
//				.getSameIndividuals(ind);
//	}
//
//	public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual ind)
//			throws InconsistentOntologyException, FreshEntitiesException,
//			ReasonerInterruptedException, TimeOutException {
//		return getDelegate(buildPapillon(PapillonType.ALL, ind.getSignature()))
//				.getDifferentIndividuals(ind);
//	}
//
//	public long getTimeOut() {
//		return config.getTimeOut();
//	}
//
//	public FreshEntityPolicy getFreshEntityPolicy() {
//		return config.getFreshEntityPolicy();
//	}
//
//	public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
//		return config.getIndividualNodeSetPolicy();
//	}
//
//	public void dispose() {
//		this.ad = null;
//		this.delegateFactory = null;
//		for (OWLReasoner r : reasonersHardCache.values()) {
//			r.dispose();
//		}
//		this.declarations.clear();
//		reasonersHardCache.clear();
//		this.topCone.clear();
//		this.bottomCone.clear();
//		this.rootOntology.getOWLOntologyManager().removeOntologyChangeListener(this);
//	}
//}
